/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.element;

import java.awt.Graphics;
import net.sourceforge.jeuclid.MathBase;
import net.sourceforge.jeuclid.element.generic.AbstractMathElement;
import net.sourceforge.jeuclid.element.helpers.AttributesHelper;

public class MathFrac
extends AbstractMathElement {
    public static final String ELEMENT = "mfrac";
    public static final double FRAC_TILT_ANGLE = 0.577;
    public static final String ATTRIBUTE_LINETHICKNESS = "linethickness";
    private String m_linethickness = "medium";
    private boolean m_bevelled = false;

    public MathFrac(MathBase base) {
        super(base);
        this.m_displaystyle = false;
        this.m_inheritdisplaystyle = false;
    }

    public void setLinethickness(String linethickness) {
        this.m_linethickness = linethickness;
    }

    public int getLinethickness(Graphics g) {
        try {
            this.m_linethickness = String.valueOf(String.valueOf(Integer.valueOf(this.m_linethickness).shortValue() * AttributesHelper.getPixels("medium", this.getFontMetrics(g)))) + "px";
        }
        catch (Exception exception) {
            // empty catch block
        }
        return AttributesHelper.getPixels(this.m_linethickness, this.getFontMetrics(g));
    }

    public void setBevelled(boolean bevelled) {
        this.m_bevelled = bevelled;
    }

    public boolean getBevelled() {
        return this.m_bevelled;
    }

    public void paint(Graphics g, int posX, int posY) {
        if (this.getBackgroundColor() != null) {
            g.setColor(this.getBackgroundColor());
            g.fillRect(posX, posY - this.getAscentHeight(g), this.getWidth(g), this.getHeight(g));
        }
        g.setColor(this.getForegroundColor());
        g.setFont(this.getFont());
        AbstractMathElement e1 = this.getMathElement(0);
        AbstractMathElement e2 = this.getMathElement(1);
        int middle = posY - this.getMiddleShift(g);
        int dist = AttributesHelper.getPixels("0.1em", this.getFontMetrics(g));
        if (this.getBevelled()) {
            int w1 = Math.max((int)Math.round((double)e2.getHeight(g) * 0.577), e1.getWidth(g) + dist);
            e1.paint(g, posX + w1 - e1.getWidth(g), middle - e1.getDescentHeight(g));
            int linef = this.getLinethickness(g);
            e2.paint(g, posX + w1 + dist + linef, posY - this.getAscentHeight(g) + e1.getHeight(g) + e2.getAscentHeight(g));
            int i = 0;
            while (i < linef) {
                g.drawLine(posX + w1 + i - (int)Math.round((double)e2.getHeight(g) * 0.577), middle + e2.getHeight(g), posX + w1 + i + (int)Math.round((double)e1.getHeight(g) * 0.577), middle - e1.getHeight(g));
                ++i;
            }
        } else {
            int width = this.getWidth(g);
            e1.paint(g, (posX += dist) + (width - 2 * dist - e1.getWidth(g)) / 2, middle - e1.getDescentHeight(g) - 2 - this.getLinethickness(g) / 2);
            int linef = this.getLinethickness(g);
            int i = 0;
            while (i < linef) {
                g.drawLine(posX, middle + i - linef / 2, posX + width - dist * 2, middle + i - linef / 2);
                ++i;
            }
            e2.paint(g, posX + (width - 2 * dist - e2.getWidth(g)) / 2, middle + e2.getAscentHeight(g) + 2 + this.getLinethickness(g) / 2);
        }
    }

    public int calculateWidth(Graphics g) {
        AbstractMathElement e1 = this.getMathElement(0);
        AbstractMathElement e2 = this.getMathElement(1);
        int dist = AttributesHelper.getPixels("0.1em", this.getFontMetrics(g));
        if (this.getBevelled()) {
            int w1 = Math.max((int)Math.round((double)e2.getHeight(g) * 0.577), e1.getWidth(g) + dist);
            int w2 = Math.max((int)Math.round((double)e1.getHeight(g) * 0.577), e2.getWidth(g) + dist);
            return w1 + w2 + this.getLinethickness(g);
        }
        return Math.max(e1.getWidth(g), e2.getWidth(g)) + dist * 2;
    }

    public int calculateAscentHeight(Graphics g) {
        if (this.getBevelled()) {
            return this.getMathElement(0).getHeight(g) + this.getMiddleShift(g);
        }
        return this.getMathElement(0).getHeight(g) + 2 + this.getLinethickness(g) / 2 + this.getMiddleShift(g);
    }

    public int calculateDescentHeight(Graphics g) {
        if (this.getBevelled()) {
            return Math.max(0, this.getMathElement(1).getHeight(g) - this.getMiddleShift(g));
        }
        return Math.max(0, this.getMathElement(1).getHeight(g) + 2 + this.getLinethickness(g) / 2 - this.getMiddleShift(g));
    }
}

