/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.element;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import net.sourceforge.jeuclid.MathBase;
import net.sourceforge.jeuclid.element.generic.AbstractMathElementWithChildren;

public class MathEnclose
extends AbstractMathElementWithChildren {
    public static final String ELEMENT = "menclose";
    public static final char LONGDIV_CHAR = ')';
    private String m_notation;
    private Integer isLongdiv;
    private Integer isRadical;
    private Integer isUpdiagonalstrike;
    private Integer isDowndiagonalstrike;
    private SortedSet notations = new TreeSet();

    public MathEnclose(MathBase base) {
        super(base);
    }

    public String getNotation() {
        return this.m_notation;
    }

    public void setNotation(String notation) {
        this.isLongdiv = new Integer(notation.indexOf("longdiv"));
        if (this.isLongdiv > -1) {
            this.notations.add(this.isLongdiv);
        }
        this.isUpdiagonalstrike = new Integer(notation.indexOf("updiagonalstrike"));
        if (this.isUpdiagonalstrike > -1) {
            this.notations.add(this.isUpdiagonalstrike);
        }
        this.isDowndiagonalstrike = new Integer(notation.indexOf("downdiagonalstrike"));
        if (this.isDowndiagonalstrike > -1) {
            this.notations.add(this.isDowndiagonalstrike);
        }
        this.isRadical = new Integer(notation.indexOf("radical"));
        if (this.isRadical > -1) {
            this.notations.add(this.isRadical);
        }
        this.m_notation = notation;
    }

    public void paint(Graphics g, int posX, int posY) {
        if (this.getBackgroundColor() != null) {
            g.setColor(this.getBackgroundColor());
            g.fillRect(posX, posY - this.getAscentHeight(g), this.getWidth(g), this.getHeight(g));
        }
        g.setColor(this.getForegroundColor());
        g.setFont(this.getFont());
        Integer currentNotation = null;
        int width = this.getWidth(g);
        int ascHeight = this.getAscentHeight(g);
        int descHeight = this.getDescentHeight(g);
        NotationDesc nd = new NotationDesc(posX, posY, width, ascHeight, descHeight);
        Iterator i = this.notations.iterator();
        while (i.hasNext()) {
            currentNotation = (Integer)i.next();
            this.drawNotation(currentNotation, g, nd);
        }
        super.paint(g, nd.m_posX, nd.m_posY);
    }

    private int getRootWidth(char root) {
        FontRenderContext context = new FontRenderContext(new AffineTransform(), false, false);
        GlyphVector gv = this.getFont().createGlyphVector(context, new char[]{root});
        int result = (int)gv.getGlyphMetrics(0).getBounds2D().getWidth();
        return result + 2;
    }

    private void drawNotation(Integer notation, Graphics g, NotationDesc nd) {
        if (notation == this.isLongdiv) {
            Font font = this.getFont();
            Graphics2D g2d = (Graphics2D)g;
            GlyphVector gv = font.createGlyphVector(g2d.getFontRenderContext(), new char[]{')'});
            Rectangle2D gbounds = gv.getGlyphMetrics(0).getBounds2D();
            double glyphWidth = gbounds.getWidth();
            double glyphHeight = gbounds.getHeight();
            double yScale = (double)(nd.m_ascHeight + nd.m_descHeight) / glyphHeight;
            double xScale = 1.0;
            AffineTransform transform = new AffineTransform();
            AffineTransform prevTransform = g2d.getTransform();
            transform.scale(xScale, yScale);
            double y = nd.m_posY + nd.m_descHeight;
            y -= (gbounds.getY() + gbounds.getHeight()) * yScale;
            double x = nd.m_posX;
            g2d.clipRect(nd.m_posX - 1, (int)((double)(nd.m_posY + nd.m_descHeight) - glyphHeight * yScale), (int)(glyphWidth * xScale + 2.0), (int)(glyphHeight * yScale + 2.0));
            g2d.setTransform(transform);
            g2d.drawGlyphVector(gv, (float)(x /= xScale), (float)(y /= yScale));
            g2d.setTransform(prevTransform);
            g2d.setClip(null);
            int rightTopPoint = (int)((double)(nd.m_posY + nd.m_descHeight) - glyphHeight * yScale);
            g.drawLine(nd.m_posX + 1, rightTopPoint, nd.m_posX + 1 + nd.m_width, rightTopPoint);
            nd.m_posX = nd.m_posX + this.getRootWidth(')') + 1;
            nd.m_width = nd.m_width - this.getRootWidth(')') - 2;
            nd.m_ascHeight = nd.m_ascHeight - 2;
            nd.m_descHeight = nd.m_descHeight - 2;
        } else if (notation == this.isUpdiagonalstrike) {
            g.drawLine(nd.m_posX, nd.m_posY + nd.m_descHeight, nd.m_posX + nd.m_width, nd.m_posY - nd.m_ascHeight);
        } else if (notation == this.isDowndiagonalstrike) {
            g.drawLine(nd.m_posX, nd.m_posY - nd.m_ascHeight, nd.m_posX + nd.m_width, nd.m_posY + nd.m_descHeight);
        }
    }

    public int calculateWidth(Graphics g) {
        int width = super.calculateWidth(g);
        Integer notation = null;
        Iterator i = this.notations.iterator();
        while (i.hasNext()) {
            notation = (Integer)i.next();
            if (notation != this.isLongdiv) continue;
            width = width + this.getRootWidth(')') + 2;
        }
        return width;
    }

    public int calculateAscentHeight(Graphics g) {
        int ah = super.calculateAscentHeight(g);
        Integer notation = null;
        Iterator i = this.notations.iterator();
        while (i.hasNext()) {
            notation = (Integer)i.next();
            if (notation != this.isLongdiv) continue;
            ah += 2;
        }
        return ah;
    }

    public int calculateDescentHeight(Graphics g) {
        int dh = super.calculateDescentHeight(g);
        Integer notation = null;
        Iterator i = this.notations.iterator();
        while (i.hasNext()) {
            notation = (Integer)i.next();
            if (notation != this.isLongdiv) continue;
            dh += 2;
        }
        return dh;
    }

    private class NotationDesc {
        private int m_posX;
        private int m_posY;
        private int m_width;
        private int m_ascHeight;
        private int m_descHeight;

        public NotationDesc(int posX, int posY, int width, int ascHeight, int descHeight) {
            this.m_posX = posX;
            this.m_posY = posY;
            this.m_width = width;
            this.m_ascHeight = ascHeight;
            this.m_descHeight = descHeight;
        }
    }
}

