/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.awt;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import net.sourceforge.jeuclid.DOMMathBuilder;
import net.sourceforge.jeuclid.MathBase;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.logger.NullLogger;
import org.w3c.dom.Document;

public class MathComponent
extends Component {
    private static final long serialVersionUID = 1L;
    private MathBase base = null;
    private boolean debug = false;
    private Document document = null;
    private Logger logger = new NullLogger();

    public MathComponent() {
    }

    public MathComponent(Document document, Font font, Logger logger) {
        this();
        this.setDocument(document);
        this.setFont(font);
        this.setLogger(logger);
    }

    public Document getDocument() {
        return this.document;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public Dimension getMinimumSize() {
        if (this.base == null) {
            return new Dimension(1, 1);
        }
        return new Dimension(this.base.getWidth(), this.base.getHeight());
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.base != null) {
            this.base.paint(g);
        }
    }

    private void redo() {
        if (this.document != null) {
            this.base = new MathBase(this.getFont());
            new DOMMathBuilder(this.document, this.logger, this.base);
            this.base.setDebug(this.debug);
        } else {
            this.base = null;
        }
        this.repaint();
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
        this.redo();
    }

    public void setDocument(Document document) {
        this.document = document;
        this.redo();
    }

    public void setFont(Font f) {
        super.setFont(f);
        this.redo();
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }
}

