/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.ant;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.fop.apps.Driver;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.Options;
import org.apache.fop.apps.XSLTInputHandler;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.XMLReader;

public class TestsConverter
extends MatchingTask {
    private File m_style;
    private File m_inDir;
    private File m_outDir;
    private File m_fontConfig;
    private File m_dtdDir;
    private String m_httpShare;

    public void execute() throws BuildException {
        Document doc;
        Driver driver = new Driver();
        driver.setRenderer(1);
        if (this.m_fontConfig != null) {
            if (!this.m_fontConfig.exists()) {
                System.out.println("WARNING: FOP config file was not found:" + this.m_fontConfig);
            } else {
                try {
                    new Options(this.m_fontConfig);
                }
                catch (FOPException e) {
                    System.out.println("ERROR: FOP config cannot be applied:" + e.getMessage());
                }
            }
        }
        if (this.m_inDir == null) {
            throw new BuildException("ERROR: tests source directory, \"tests.inDir\" ,is not specified");
        }
        if (this.m_outDir == null) {
            throw new BuildException("ERROR: tests output directory, \"tests.outDir\" ,is not specified");
        }
        DirectoryScanner scanner = this.getDirectoryScanner(this.m_inDir);
        String[] dirs = scanner.getIncludedDirectories();
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            doc = documentBuilderFactory.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e1) {
            doc = null;
        }
        Element root = doc.createElement("test_results");
        int i = 0;
        while (i < dirs.length) {
            if (!dirs[i].trim().equals("")) {
                this.setIncludes("*.xml");
                File testDir = new File(this.m_inDir, dirs[i]);
                DirectoryScanner testScanner = this.getDirectoryScanner(testDir);
                String[] xmls = testScanner.getIncludedFiles();
                int j = 0;
                while (j < xmls.length) {
                    Document xmlDoc;
                    String pdfName = String.valueOf(xmls[j].substring(0, xmls[j].length() - 3)) + "pdf";
                    File outPdf = new File(this.m_outDir, pdfName);
                    this.process(driver, new File(testDir, xmls[j]), outPdf);
                    try {
                        DocumentBuilder parser = documentBuilderFactory.newDocumentBuilder();
                        xmlDoc = parser.parse(String.valueOf(testDir.getPath()) + "/" + xmls[j]);
                    }
                    catch (Exception e) {
                        throw new BuildException("Can't found input source for FOP:" + e.getMessage(), (Throwable)e);
                    }
                    String desc = xmlDoc.getDocumentElement().getAttribute("description");
                    Element description = doc.createElement("description");
                    description.appendChild(doc.createTextNode(desc));
                    Element name = doc.createElement("pdf_name");
                    name.appendChild(doc.createTextNode(outPdf.getName()));
                    Element pdfFile = doc.createElement("pdf_file");
                    pdfFile.appendChild(doc.createTextNode(String.valueOf(this.m_httpShare) + "/" + outPdf.getName()));
                    Element result = doc.createElement("test_result");
                    result.appendChild(description);
                    result.appendChild(name);
                    result.appendChild(pdfFile);
                    root.appendChild(result);
                    ++j;
                }
            }
            ++i;
        }
        doc.appendChild(root);
        try {
            File f = new File(this.m_outDir.getAbsolutePath(), "testsresults.xml");
            StreamResult sr = new StreamResult(f);
            Transformer t = TransformerFactory.newInstance().newTransformer();
            t.transform(new DOMSource(doc), sr);
        }
        catch (Exception e) {
            throw new BuildException("ERROR: Error during creating tests-result.xml:" + e.getMessage(), (Throwable)e);
        }
    }

    private void process(Driver driver, File xmlFile, File resultFile) throws BuildException {
        if (this.m_style == null) {
            throw new BuildException("Stylesheet has to be typed as \"tests.stylesheet\" attribute.");
        }
        try {
            driver.setOutputStream((OutputStream)new FileOutputStream(resultFile));
        }
        catch (FileNotFoundException e) {
            throw new BuildException("Can't set output source for FOP:" + e.getMessage(), (Throwable)e);
        }
        try {
            XSLTInputHandler inputHandler = new XSLTInputHandler(xmlFile, this.m_style);
            inputHandler.setParameter("testPath", (Object)(String.valueOf(xmlFile.getParent()) + "\\"));
            inputHandler.setParameter("dtdPath", (Object)(this.m_dtdDir + "\\"));
            XMLReader parser = inputHandler.getParser();
            driver.render(parser, inputHandler.getInputSource());
        }
        catch (FOPException e) {
            throw new BuildException("ERROR: Fop error during rendering:" + e.getMessage(), (Throwable)e);
        }
    }

    public void setStyle(File stylesheet) {
        this.m_style = stylesheet;
    }

    public void setInDir(File inDir) {
        this.m_inDir = inDir;
    }

    public void setOutDir(File outDir) {
        this.m_outDir = outDir;
    }

    public void setFontConfig(File fontConfig) {
        this.m_fontConfig = fontConfig;
    }

    public void setDtdDir(File dtdDir) {
        this.m_dtdDir = dtdDir;
    }

    public void setHttpShare(String httpShare) {
        this.m_httpShare = httpShare;
    }
}

