/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.ant;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.fop.apps.Driver;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.Options;
import org.apache.fop.apps.XSLTInputHandler;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class PDFConverter
extends MatchingTask {
    private File m_fontConfig;
    private File m_foFile;
    private File m_style;
    private File m_inDir;
    private File m_outDir;
    private File m_mml;
    private File m_outpdf;

    public void execute() throws BuildException {
        Driver driver = new Driver();
        driver.setRenderer(1);
        if (this.m_fontConfig != null) {
            if (!this.m_fontConfig.exists()) {
                System.out.println("WARNING: FOP config file was not found:" + this.m_fontConfig);
            } else {
                try {
                    new Options(this.m_fontConfig);
                }
                catch (FOPException e) {
                    System.out.println("ERROR: FOP config cannot be applied:" + e.getMessage());
                }
            }
        }
        if (this.m_foFile != null) {
            try {
                driver.setOutputStream((OutputStream)new FileOutputStream(this.m_outpdf));
            }
            catch (FileNotFoundException e) {
                throw new BuildException("Can't set output source for FOP:" + e.getMessage(), (Throwable)e);
            }
            try {
                driver.setInputSource(new InputSource(new FileInputStream(this.m_foFile)));
            }
            catch (FileNotFoundException e) {
                throw new BuildException("Can't set input source for FOP:" + e.getMessage(), (Throwable)e);
            }
            try {
                driver.run();
            }
            catch (IOException e) {
                throw new BuildException("Error while FOP rendering:" + e.getMessage(), (Throwable)e);
            }
            catch (FOPException e) {
                throw new BuildException("Error while FOP rendering:" + e.getMessage(), (Throwable)e);
            }
        }
        if (this.m_mml != null) {
            this.process(driver, this.m_mml, this.m_outpdf);
        } else if (this.m_inDir != null) {
            if (this.m_outDir == null) {
                throw new BuildException("ERROR: destination directory, \"outDir\" ,is not specified");
            }
            DirectoryScanner scanner = this.getDirectoryScanner(this.m_inDir);
            String[] list = scanner.getIncludedFiles();
            String[] dirs = scanner.getIncludedDirectories();
            int i = 0;
            while (i < list.length) {
                File outPdf = new File(this.m_outDir, String.valueOf(list[i]) + ".pdf");
                if (!outPdf.getParentFile().exists()) {
                    outPdf.getParentFile().mkdirs();
                }
                this.process(driver, new File(this.m_inDir, list[i]), outPdf);
                ++i;
            }
            int j = 0;
            while (j < dirs.length) {
                File intDir = new File(this.m_inDir, dirs[j]);
                if (!intDir.exists()) {
                    intDir.mkdirs();
                }
                String[] internalList = intDir.list();
                int i2 = 0;
                while (i2 < internalList.length) {
                    this.process(driver, new File(this.m_inDir, internalList[i2]), new File(this.m_outDir, String.valueOf(internalList[i2]) + ".pdf"));
                    ++i2;
                }
                ++j;
            }
        }
    }

    private void process(Driver driver, File mmlFile, File resultFile) throws BuildException {
        if (this.m_style == null) {
            throw new BuildException("Stylesheet has to be typed as \"style\" attribute.");
        }
        try {
            driver.setOutputStream((OutputStream)new FileOutputStream(resultFile));
        }
        catch (FileNotFoundException e) {
            throw new BuildException("Can't set output source for FOP:" + e.getMessage(), (Throwable)e);
        }
        try {
            XSLTInputHandler inputHandler = new XSLTInputHandler(mmlFile, this.m_style);
            XMLReader parser = inputHandler.getParser();
            driver.render(parser, inputHandler.getInputSource());
        }
        catch (FOPException e) {
            throw new BuildException("ERROR: Fop error during rendering:" + e.getMessage(), (Throwable)e);
        }
    }

    public void setStyle(File stylesheet) {
        this.m_style = stylesheet;
    }

    public void setFoFile(File foFile) {
        this.m_foFile = foFile;
    }

    public void setInDir(File inDir) {
        this.m_inDir = inDir;
    }

    public void setOutDir(File outDir) {
        this.m_outDir = outDir;
    }

    public void setMml(File inFile) {
        this.m_mml = inFile;
    }

    public void setOutPdf(File outFile) {
        this.m_outpdf = outFile;
    }

    public void setFontConfig(File fontConfig) {
        this.m_fontConfig = fontConfig;
    }
}

