/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.ant;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.sourceforge.jeuclid.DOMMathBuilder;
import net.sourceforge.jeuclid.MathBase;
import org.apache.avalon.framework.logger.ConsoleLogger;
import org.apache.avalon.framework.logger.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.shetline.io.GIFOutputStream;
import org.w3c.dom.Document;
import org.xml.sax.SAXParseException;

public class MathMLConverter
extends MatchingTask {
    private File m_destDir = null;
    private File m_baseDir = null;
    private File m_inFile = null;
    private File m_outFile = null;
    private boolean m_force = false;

    public void execute() throws BuildException {
        if (this.m_baseDir == null) {
            this.m_baseDir = this.getProject().resolveFile(".");
        }
        if (this.m_inFile != null && this.m_outFile != null) {
            this.process(this.m_inFile, this.m_outFile);
            return;
        }
        if (this.m_destDir == null) {
            String msg = "m_destDir attributes must be set!";
            throw new BuildException(msg);
        }
        DirectoryScanner scanner = this.getDirectoryScanner(this.m_baseDir);
        this.log("Transforming into " + this.m_destDir, 2);
        String[] list = scanner.getIncludedFiles();
        int i = 0;
        while (i < list.length) {
            this.process(this.m_baseDir, list[i], this.m_destDir);
            ++i;
        }
        String[] dirs = scanner.getIncludedDirectories();
        int j = 0;
        while (j < dirs.length) {
            list = new File(this.m_baseDir, dirs[j]).list();
            int i2 = 0;
            while (i2 < list.length) {
                this.process(this.m_baseDir, list[i2], this.m_destDir);
                ++i2;
            }
            ++j;
        }
    }

    public void setForce(boolean force) {
        this.m_force = force;
    }

    public void setBasedir(File dir) {
        this.m_baseDir = dir;
    }

    public void setDestdir(File dir) {
        this.m_destDir = dir;
    }

    public void setOut(File outFile) {
        this.m_outFile = outFile;
    }

    public void setIn(File inFile) {
        this.m_inFile = inFile;
    }

    private void ensureDirectoryFor(File targetFile) throws BuildException {
        File directory = new File(targetFile.getParent());
        if (!directory.exists() && !directory.mkdirs()) {
            throw new BuildException("Unable to create directory: " + directory.getAbsolutePath());
        }
    }

    private void process(File baseDir, String xmlFile, File destDir) throws BuildException {
        block5: {
            File outFile = null;
            File inFile = null;
            try {
                inFile = new File(baseDir, xmlFile);
                int dotPos = xmlFile.lastIndexOf(46);
                outFile = dotPos > 0 ? new File(destDir, String.valueOf(xmlFile.substring(0, xmlFile.lastIndexOf(46))) + ".gif") : new File(destDir, String.valueOf(xmlFile) + ".gif");
                if (!this.m_force && inFile.lastModified() <= outFile.lastModified()) break block5;
                this.ensureDirectoryFor(outFile);
                MathBase base = new MathBase(new Font("Arial Unicode MS", 0, 12));
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder parser = documentBuilderFactory.newDocumentBuilder();
                Document document = null;
                try {
                    document = parser.parse(inFile.toString());
                }
                catch (SAXParseException se) {
                    this.log("The grammar file is not valid: " + se.getMessage());
                    return;
                }
                new DOMMathBuilder(document, (Logger)new ConsoleLogger(), base);
                int width = base.getWidth();
                int height = base.getHeight();
                BufferedImage image = new BufferedImage(width, height, 1);
                Graphics2D g = image.createGraphics();
                Color transparency = new Color(78, 91, 234);
                g.setColor(transparency);
                g.fillRect(0, 0, width, height);
                g.setColor(Color.black);
                base.paint(g);
                BufferedOutputStream buffer = new BufferedOutputStream(new FileOutputStream(outFile));
                GIFOutputStream.writeGIF((OutputStream)buffer, (Image)image, (int)0, (Color)transparency);
                buffer.flush();
                buffer.close();
            }
            catch (Exception ex) {
                this.log("Failed to process " + inFile, 2);
                if (outFile != null) {
                    outFile.delete();
                }
                throw new BuildException((Throwable)ex);
            }
        }
    }

    private void process(File inFile, File outFile) throws BuildException {
        block5: {
            try {
                this.log("In file " + inFile + " time: " + inFile.lastModified(), 4);
                this.log("Out file " + outFile + " time: " + outFile.lastModified(), 4);
                if (!this.m_force && inFile.lastModified() <= outFile.lastModified()) break block5;
                this.ensureDirectoryFor(outFile);
                this.log("Processing " + inFile + " to " + outFile, 2);
                MathBase base = new MathBase(new Font("Arial Unicode MS", 0, 12));
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder parser = documentBuilderFactory.newDocumentBuilder();
                Document document = null;
                try {
                    document = parser.parse(inFile.toString());
                }
                catch (SAXParseException se) {
                    this.log("The grammar file is not valid: " + se.getMessage());
                    return;
                }
                new DOMMathBuilder(document, (Logger)new ConsoleLogger(), base);
                int width = base.getWidth();
                int height = base.getHeight();
                BufferedImage image = new BufferedImage(width, height, 1);
                Graphics2D g = image.createGraphics();
                Color transparency = new Color(78, 91, 234);
                g.setColor(transparency);
                g.fillRect(0, 0, width, height);
                g.setColor(Color.black);
                base.paint(g);
                BufferedOutputStream buffer = new BufferedOutputStream(new FileOutputStream(outFile));
                GIFOutputStream.writeGIF((OutputStream)buffer, (Image)image, (int)0, (Color)transparency);
                buffer.flush();
                buffer.close();
            }
            catch (Exception ex) {
                this.log("Failed to process " + inFile, 2);
                if (outFile != null) {
                    outFile.delete();
                }
                throw new BuildException((Throwable)ex);
            }
        }
    }
}

