/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid;

import java.awt.Font;
import java.util.Stack;
import net.sourceforge.jeuclid.MathBase;
import net.sourceforge.jeuclid.element.MathIdentifier;
import net.sourceforge.jeuclid.element.MathNumber;
import net.sourceforge.jeuclid.element.MathOperator;
import net.sourceforge.jeuclid.element.MathOver;
import net.sourceforge.jeuclid.element.MathPhantom;
import net.sourceforge.jeuclid.element.MathRoot;
import net.sourceforge.jeuclid.element.MathRootElement;
import net.sourceforge.jeuclid.element.MathRow;
import net.sourceforge.jeuclid.element.MathSqrt;
import net.sourceforge.jeuclid.element.MathSub;
import net.sourceforge.jeuclid.element.MathSubSup;
import net.sourceforge.jeuclid.element.MathSup;
import net.sourceforge.jeuclid.element.MathTable;
import net.sourceforge.jeuclid.element.MathTableData;
import net.sourceforge.jeuclid.element.MathTableRow;
import net.sourceforge.jeuclid.element.MathText;
import net.sourceforge.jeuclid.element.MathUnder;
import net.sourceforge.jeuclid.element.MathUnderOver;
import net.sourceforge.jeuclid.element.generic.AbstractMathElement;
import net.sourceforge.jeuclid.element.helpers.AttributeMap;
import net.sourceforge.jeuclid.element.helpers.SAXAttributeMap;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;

public class SAXMathBuilder
implements ContentHandler {
    private MathRootElement rootElement;
    private Stack stack;
    private MathBase m_base;

    public SAXMathBuilder(Font font) {
        this.m_base = new MathBase(font);
    }

    public MathRootElement getMathRootElement() {
        return this.rootElement;
    }

    public void characters(char[] ch, int start, int length) {
        if (!this.stack.empty()) {
            ((AbstractMathElement)this.stack.peek()).addText(new String(ch, start, length));
        }
    }

    public void endDocument() {
    }

    public void endElement(String namespaceURI, String localName, String qName) {
        if (!this.stack.empty()) {
            AbstractMathElement element = (AbstractMathElement)this.stack.pop();
            if (this.stack.empty()) {
                try {
                    this.rootElement = (MathRootElement)element;
                }
                catch (ClassCastException e) {
                    System.err.println("ClassCastException MathRootElement" + e.getMessage());
                }
            }
        }
    }

    public void startDocument() {
        this.rootElement = null;
        this.stack = new Stack();
    }

    private AbstractMathElement elementFromName(String localName, AttributeMap attributes) {
        if (localName.equals("math")) {
            MathRootElement element = new MathRootElement(this.m_base);
            String value = attributes.getString("display");
            if (value != null) {
                element.setDisplay(value.equals("block") ? 1 : 0);
            }
            return element;
        }
        if (localName.equals("mphantom")) {
            return new MathPhantom(this.m_base);
        }
        if (localName.equals("msup")) {
            return new MathSup(this.m_base);
        }
        if (localName.equals("msub")) {
            return new MathSub(this.m_base);
        }
        if (localName.equals("msubsup")) {
            return new MathSubSup(this.m_base);
        }
        if (localName.equals("munder")) {
            return new MathUnder(this.m_base);
        }
        if (localName.equals("mover")) {
            return new MathOver(this.m_base);
        }
        if (localName.equals("munderover")) {
            return new MathUnderOver(this.m_base);
        }
        if (localName.equals("msqrt")) {
            return new MathSqrt(this.m_base);
        }
        if (localName.equals("mroot")) {
            return new MathRoot(this.m_base);
        }
        if (localName.equals("mtable")) {
            return new MathTable(this.m_base);
        }
        if (localName.equals("mtr")) {
            return new MathTableRow(this.m_base);
        }
        if (localName.equals("mtd")) {
            return new MathTableData(this.m_base);
        }
        if (localName.equals("mo")) {
            MathOperator element = new MathOperator(this.m_base);
            element.setStretchy(attributes.getBoolean("stretchy", true));
            return element;
        }
        if (localName.equals("mi")) {
            return new MathIdentifier(this.m_base);
        }
        if (localName.equals("mn")) {
            return new MathNumber(this.m_base);
        }
        if (localName.equals("mtext")) {
            return new MathText(this.m_base);
        }
        return new MathRow(this.m_base);
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes attributes) {
        if (this.stack.empty() && !localName.equals("math")) {
            return;
        }
        AbstractMathElement element = this.elementFromName(localName, new SAXAttributeMap(attributes));
        if (!this.stack.empty()) {
            ((AbstractMathElement)this.stack.peek()).addMathElement(element);
        }
        this.stack.push(element);
    }

    public void endPrefixMapping(String prefix) {
    }

    public void ignorableWhitespace(char[] ch, int start, int length) {
    }

    public void processingInstruction(String target, String data) {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void skippedEntity(String name) {
    }

    public void startPrefixMapping(String prefix, String uri) {
    }
}

