/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import net.sourceforge.jeuclid.element.MathRootElement;
import net.sourceforge.jeuclid.element.helpers.AttributesHelper;
import org.apache.avalon.framework.logger.Logger;

public class MathBase {
    private Logger m_log = null;
    private Font m_font;
    public static final int INLINE = 0;
    public static final int DISPLAY = 1;
    public static final int NORMAL = 0;
    public static final int BOLD = 1;
    public static final int ITALIC = 2;
    public static final int BOLD_ITALIC = 3;
    public static final int DOUBLE_STRUCK = 4;
    public static final int BOLD_FRAKTUR = 5;
    public static final int SCRIPT = 6;
    public static final int BOLD_SCRIPT = 7;
    public static final int FRAKTUR = 8;
    public static final int SANS_SERIF = 9;
    public static final int BOLD_SANS_SERIF = 10;
    public static final int ITALIC_SANS_SERIF = 11;
    public static final int BOLD_ITALIC_SANS_SERIF = 12;
    public static final int MONOSPACE = 13;
    private boolean m_debug = false;
    private MathRootElement rootElement;

    public int getAscender(Graphics g) {
        return this.rootElement.getAscentHeight(g);
    }

    public int getAscender() {
        Graphics2D g = new BufferedImage(1, 1, 1).createGraphics();
        return this.getAscender(g);
    }

    public int getDescender(Graphics g) {
        return this.rootElement.getDescentHeight(g);
    }

    public int getDescender() {
        Graphics2D g = new BufferedImage(1, 1, 1).createGraphics();
        return this.getDescender(g);
    }

    public MathBase(Font font) {
        if (font == null) {
            font = new Font(null);
        }
        this.m_font = font;
    }

    public Font getFont() {
        return this.m_font;
    }

    public boolean isInline() {
        return this.rootElement == null ? false : this.rootElement.getDisplay() == 0;
    }

    public void setRootElement(MathRootElement element) {
        if (element == null) {
            return;
        }
        this.rootElement = element;
        this.rootElement.setMathBase(this);
        this.rootElement.setDebug(this.isDebug());
        if (this.rootElement.getLogger() != null) {
            this.m_log = this.rootElement.getLogger();
        }
    }

    public void setDebug(boolean debug) {
        this.m_debug = debug;
        if (this.rootElement != null) {
            this.rootElement.setDebug(debug);
        }
    }

    public boolean isDebug() {
        return this.m_debug;
    }

    public void paint(Graphics g) {
        if (this.rootElement != null) {
            this.rootElement.paint(g);
        }
    }

    public int getWidth(Graphics g) {
        if (this.rootElement != null) {
            return this.rootElement.getWidth(g);
        }
        return 0;
    }

    public int getHeight() {
        Graphics2D g = new BufferedImage(1, 1, 1).createGraphics();
        return this.getHeight(g);
    }

    public int getWidth() {
        Graphics2D g = new BufferedImage(1, 1, 1).createGraphics();
        return this.getWidth(g);
    }

    public int getHeight(Graphics g) {
        if (this.rootElement != null) {
            return this.rootElement.getHeight(g);
        }
        return 0;
    }

    public Logger getLogger() {
        return this.m_log;
    }

    public void setLogger(Logger log) {
        this.m_log = log;
    }

    public Font getFont(float fontsize, int mathVariant) {
        return this.m_font.deriveFont(MathBase.convertToStyle(mathVariant), fontsize);
    }

    public Font getFont(String mathSize, int mathVariant, Font m_font2) {
        Font font = this.m_font.deriveFont(MathBase.convertToStyle(mathVariant), AttributesHelper.getFontSize(mathSize, m_font2));
        return font;
    }

    public static int convertToStyle(int mathVariant) {
        int result = 0;
        switch (mathVariant) {
            case 1: {
                result = 1;
                break;
            }
            case 2: {
                result = 2;
                break;
            }
            case 3: {
                result = 0;
                break;
            }
            case 4: {
                result = 0;
                break;
            }
            case 5: {
                result = 0;
                break;
            }
            case 6: {
                result = 0;
                break;
            }
            case 7: {
                result = 1;
                break;
            }
            case 8: {
                result = 0;
                break;
            }
            case 9: {
                result = 0;
                break;
            }
            case 10: {
                result = 1;
                break;
            }
            case 11: {
                result = 2;
                break;
            }
            case 12: {
                result = 0;
                break;
            }
            case 13: {
                result = 0;
                break;
            }
            default: {
                result = 0;
            }
        }
        return result;
    }
}

