/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid;

import net.sourceforge.jeuclid.MathBase;
import net.sourceforge.jeuclid.element.MathAlignGroup;
import net.sourceforge.jeuclid.element.MathAlignMark;
import net.sourceforge.jeuclid.element.MathAnnotation;
import net.sourceforge.jeuclid.element.MathEnclose;
import net.sourceforge.jeuclid.element.MathFenced;
import net.sourceforge.jeuclid.element.MathFrac;
import net.sourceforge.jeuclid.element.MathIdentifier;
import net.sourceforge.jeuclid.element.MathLabeledTableRow;
import net.sourceforge.jeuclid.element.MathMultiScripts;
import net.sourceforge.jeuclid.element.MathNumber;
import net.sourceforge.jeuclid.element.MathOperator;
import net.sourceforge.jeuclid.element.MathOver;
import net.sourceforge.jeuclid.element.MathPhantom;
import net.sourceforge.jeuclid.element.MathPreScripts;
import net.sourceforge.jeuclid.element.MathRoot;
import net.sourceforge.jeuclid.element.MathRootElement;
import net.sourceforge.jeuclid.element.MathRow;
import net.sourceforge.jeuclid.element.MathSemantics;
import net.sourceforge.jeuclid.element.MathSpace;
import net.sourceforge.jeuclid.element.MathSqrt;
import net.sourceforge.jeuclid.element.MathString;
import net.sourceforge.jeuclid.element.MathStyle;
import net.sourceforge.jeuclid.element.MathSub;
import net.sourceforge.jeuclid.element.MathSubSup;
import net.sourceforge.jeuclid.element.MathSup;
import net.sourceforge.jeuclid.element.MathTable;
import net.sourceforge.jeuclid.element.MathTableData;
import net.sourceforge.jeuclid.element.MathTableRow;
import net.sourceforge.jeuclid.element.MathText;
import net.sourceforge.jeuclid.element.MathUnder;
import net.sourceforge.jeuclid.element.MathUnderOver;
import net.sourceforge.jeuclid.element.generic.AbstractMathElement;
import net.sourceforge.jeuclid.element.helpers.DOMAttributeMap;
import org.apache.avalon.framework.logger.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMMathBuilder {
    private MathRootElement rootElement;
    private Logger m_log;
    private MathBase m_base;

    public DOMMathBuilder(Document document, Logger logger, MathBase mathBase) {
        if (logger == null) {
            throw new RuntimeException("Logger must not be null.");
        }
        this.m_base = mathBase;
        this.m_log = logger;
        Element documentElement = document.getDocumentElement();
        this.rootElement = new MathRootElement(this.m_base);
        this.rootElement.setLogger(logger);
        mathBase.setRootElement(this.rootElement);
        DOMAttributeMap attributes = new DOMAttributeMap(documentElement.getAttributes());
        if (attributes.hasAttribute("display")) {
            String display = attributes.getString("display", "inline");
            if (display.equalsIgnoreCase("block")) {
                this.rootElement.setDisplay(1);
            } else {
                this.rootElement.setDisplay(0);
            }
        }
        this.traverse(documentElement, this.rootElement, null);
        this.rootElement.eventAllElementsComplete();
    }

    public MathRootElement getMathRootElement() {
        return this.rootElement;
    }

    private void traverse(Node node, AbstractMathElement parent, MathTableData alignmentScope) {
        AbstractMathElement element;
        if (node.getNodeType() != 1) {
            return;
        }
        String tagname = node.getNodeName();
        int posSeparator = -1;
        posSeparator = tagname.indexOf(":");
        if (posSeparator >= 0) {
            tagname = tagname.substring(posSeparator + 1);
        }
        DOMAttributeMap attributes = new DOMAttributeMap(node.getAttributes());
        if (tagname.equals("math")) {
            element = new MathRow(this.m_base);
        } else if (tagname.equals("mfenced")) {
            element = new MathFenced(this.m_base);
        } else if (tagname.equals("mfrac")) {
            element = new MathFrac(this.m_base);
            if (attributes.hasAttribute("linethickness")) {
                ((MathFrac)element).setLinethickness(attributes.getString("linethickness", "2px"));
            }
            ((MathFrac)element).setBevelled(attributes.getBoolean("bevelled", false));
        } else if (tagname.equals("msup")) {
            element = new MathSup(this.m_base);
        } else if (tagname.equals("msub")) {
            element = new MathSub(this.m_base);
        } else if (tagname.equals("msubsup")) {
            element = new MathSubSup(this.m_base);
        } else if (tagname.equals("mmultiscripts")) {
            element = new MathMultiScripts(this.m_base);
        } else if (tagname.equals("mprescripts")) {
            element = new MathPreScripts(this.m_base);
        } else if (tagname.equals("munder")) {
            element = new MathUnder(this.m_base);
            ((MathUnder)element).setAccentUnder(attributes.getBoolean("accentunder", false));
        } else if (tagname.equals("mover")) {
            element = new MathOver(this.m_base);
            ((MathOver)element).setAccent(attributes.getBoolean("accent", false));
        } else if (tagname.equals("munderover")) {
            element = new MathUnderOver(this.m_base);
            ((MathUnderOver)element).setAccent(attributes.getBoolean("accent", false));
            ((MathUnderOver)element).setAccentUnder(attributes.getBoolean("accentunder", false));
        } else if (tagname.equals("mspace")) {
            element = new MathSpace(this.m_base);
            MathSpace space = (MathSpace)element;
            if (attributes.hasAttribute("height")) {
                space.setSpaceHeight(attributes.getString("height", "0"));
            }
            if (attributes.hasAttribute("width")) {
                space.setSpaceWidth(attributes.getString("width", "0"));
            }
            if (attributes.hasAttribute("depth")) {
                space.setDepth(attributes.getString("depth", "0"));
            }
        } else if (tagname.equals("msqrt")) {
            element = new MathSqrt(this.m_base);
        } else if (tagname.equals("ms")) {
            element = new MathString(this.m_base);
            ((MathString)element).setLQuote(attributes.getString("lquote", "\""));
            ((MathString)element).setRQuote(attributes.getString("rquote", "\""));
        } else if (tagname.equals("mroot")) {
            element = new MathRoot(this.m_base);
        } else if (tagname.equals("mtable")) {
            element = new MathTable(this.m_base);
            MathTable tabl = (MathTable)element;
            if (attributes.hasAttribute("groupalign")) {
                tabl.setGroupAlign(attributes.getString("groupalign", ""));
            }
            if (attributes.hasAttribute("rowspacing")) {
                tabl.setRowspacing(attributes.getString("rowspacing", ""));
            }
            if (attributes.hasAttribute("columnpacing")) {
                tabl.setColumnspacing(attributes.getString("columnpacing", ""));
            }
            if (attributes.hasAttribute("framespacing")) {
                tabl.setFramespacing(attributes.getString("framespacing", ""));
            }
            if (attributes.hasAttribute("align")) {
                tabl.setAlign(attributes.getString("align", "axis"));
            }
        } else if (tagname.equals("mtr")) {
            element = new MathTableRow(this.m_base);
            if (attributes.hasAttribute("groupalign")) {
                ((MathTableRow)element).setGroupAlign(attributes.getString("groupalign", ""));
            }
        } else if (tagname.equals("mlabeledtr")) {
            element = new MathLabeledTableRow(this.m_base);
        } else if (tagname.equals("menclose")) {
            element = new MathEnclose(this.m_base);
            if (attributes.hasAttribute("notation")) {
                ((MathEnclose)element).setNotation(attributes.getString("notation", ""));
            }
        } else if (tagname.equals("mtd")) {
            element = new MathTableData(this.m_base);
            alignmentScope = (MathTableData)element;
            if (attributes.hasAttribute("groupalign")) {
                ((MathTableData)element).setGroupAlign(attributes.getString("groupalign", ""));
            }
        } else if (tagname.equals("mo")) {
            MathOperator mo = new MathOperator(this.m_base);
            element = mo;
            mo.setMoveableLimits(attributes.getBoolean("movablelimits", false));
            if (attributes.hasAttribute("rspace")) {
                mo.setRSpace(attributes.getString("rspace", ""));
            }
            if (attributes.hasAttribute("lspace")) {
                mo.setLSpace(attributes.getString("lspace", ""));
            }
            if (attributes.hasAttribute("form")) {
                String form = attributes.getString("form", "uknown");
                if (form.equals("uknown")) {
                    mo.setForm(-1);
                } else if (form.equals("infix")) {
                    mo.setForm(101);
                } else if (form.equals("postfix")) {
                    mo.setForm(102);
                } else if (form.equals("prefix")) {
                    mo.setForm(100);
                }
            }
        } else if (tagname.equals("mphantom")) {
            element = new MathPhantom(this.m_base);
        } else if (tagname.equals("mrow")) {
            element = new MathRow(this.m_base);
        } else if (tagname.equals("mstyle")) {
            element = new MathStyle(this.m_base);
            if (attributes.hasAttribute("scriptlevel")) {
                String scriptlevel = attributes.getString("scriptlevel", "0");
                if (scriptlevel.charAt(0) == '+') {
                    scriptlevel = scriptlevel.substring(1);
                }
                ((MathStyle)element).setScriptlevel(Integer.valueOf(scriptlevel));
            }
            if (attributes.hasAttribute("scriptsizemultiplier")) {
                float scrm = Float.valueOf(attributes.getString("scriptsizemultiplier", String.valueOf(element.getScriptSizeMultiplier()))).floatValue();
                element.setScriptSizeMultiplier(scrm);
            }
            if (attributes.hasAttribute("scriptminsize")) {
                ((MathStyle)element).setScriptminsize(attributes.getString("scriptminsize", "0"));
            }
        } else if (tagname.equals("mi")) {
            element = new MathIdentifier(this.m_base);
        } else if (tagname.equals("mn")) {
            element = new MathNumber(this.m_base);
        } else if (tagname.equals("mtext")) {
            element = new MathText(this.m_base);
        } else if (tagname.equals("maligngroup")) {
            element = new MathAlignGroup(this.m_base);
            if (alignmentScope != null) {
                alignmentScope.addAlignGroupElement((MathAlignGroup)element);
            }
        } else if (tagname.equals("malignmark")) {
            element = new MathAlignMark(this.m_base);
            if (alignmentScope != null) {
                alignmentScope.addAlignMarkElement((MathAlignMark)element);
            }
        } else if (tagname.equals("semantics")) {
            element = new MathSemantics(this.m_base);
        } else if (tagname.equals("annotation")) {
            element = new MathAnnotation(this.m_base);
        } else {
            if (!tagname.equals("none")) {
                this.log("Warning: element " + tagname + " is not implemented.");
            }
            element = new MathRow(this.m_base);
        }
        element.setLogger(this.rootElement.getLogger());
        if (parent instanceof MathLabeledTableRow) {
            if (((MathLabeledTableRow)parent).labelIgnored) {
                parent.addMathElement(element);
            } else {
                ((MathLabeledTableRow)parent).labelIgnored = true;
            }
        } else {
            parent.addMathElement(element);
        }
        if (attributes.hasAttribute("mathvariant")) {
            String mathvariant = attributes.getString("mathvariant", "normal");
            element.setInheritMathVariant(false);
            if (mathvariant.equalsIgnoreCase("normal")) {
                element.setMathVariant(0);
            } else if (mathvariant.equalsIgnoreCase("bold")) {
                element.setMathVariant(1);
            } else if (mathvariant.equalsIgnoreCase("italic")) {
                element.setMathVariant(2);
            } else if (mathvariant.equalsIgnoreCase("bold-italic")) {
                element.setMathVariant(3);
            } else if (mathvariant.equalsIgnoreCase("double-struck")) {
                element.setMathVariant(4);
            } else if (mathvariant.equalsIgnoreCase("bold-fraktur")) {
                element.setMathVariant(5);
            } else if (mathvariant.equalsIgnoreCase("script")) {
                element.setMathVariant(6);
            } else if (mathvariant.equalsIgnoreCase("bold-script")) {
                element.setMathVariant(7);
            } else if (mathvariant.equalsIgnoreCase("fraktur")) {
                element.setMathVariant(8);
            } else if (mathvariant.equalsIgnoreCase("sans-serif")) {
                element.setMathVariant(9);
            } else if (mathvariant.equalsIgnoreCase("bold-sans-serif")) {
                element.setMathVariant(10);
            } else if (mathvariant.equalsIgnoreCase("sans-serif-italic")) {
                element.setMathVariant(11);
            } else if (mathvariant.equalsIgnoreCase("sans-serif-bold-italic")) {
                element.setMathVariant(12);
            } else if (mathvariant.equalsIgnoreCase("monospace")) {
                element.setMathVariant(13);
            }
        }
        if (attributes.hasAttribute("displaystyle")) {
            boolean parentDisplayStyle = element.getParent() == null ? false : element.getParent().getDisplayStyle();
            element.setDisplayStyle(attributes.getBoolean("displaystyle", parentDisplayStyle));
        } else {
            element.setDisplayStyle(element.getParent() == null ? false : element.getParent().getDisplayStyle());
        }
        attributes.hasAttribute("mathbackground");
        NodeList childs = node.getChildNodes();
        MathTableData prevScope = null;
        if (tagname.equals("mtd")) {
            prevScope = alignmentScope;
            alignmentScope = (MathTableData)element;
        }
        int i = 0;
        while (i < childs.getLength()) {
            String entityValue;
            if (childs.item(i).getNodeType() == 1) {
                this.traverse(childs.item(i), element, alignmentScope);
            } else if (childs.item(i).getNodeType() == 3) {
                System.out.println("DOMMathBuilder@ " + childs.item(i).getNodeValue());
                element.addText(childs.item(i).getNodeValue());
            } else if (childs.item(i).getNodeType() == 5 && childs.item(i).hasChildNodes() && (entityValue = childs.item(i).getFirstChild().getNodeValue()) != null) {
                element.addText(entityValue);
            }
            ++i;
        }
        element.eventInitSpecificAttributes(attributes);
        element.eventElementComplete();
        if (prevScope != null) {
            alignmentScope = prevScope;
        }
    }

    private void log(String info) {
        this.m_log.debug(info);
    }
}

