/*
 * Decompiled with CFR 0.152.
 */
package com.schematron.ant;

import com.schematron.ant.SVRLHandler;
import com.schematron.ant.SchematronTask;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.apache.tools.ant.BuildException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class SchematronResult {
    private String systemID;
    private String svrl;
    private final ArrayList<String> failedAssertions = new ArrayList();
    private final ArrayList<String> successfulReports = new ArrayList();

    public SchematronResult(String systemID) {
        this.systemID = systemID;
    }

    public String getSystemID() {
        return this.systemID;
    }

    public boolean isValid() {
        return this.failedAssertions.size() == 0;
    }

    public void setSVRL(String svrl) throws BuildException {
        this.svrl = this.removeXMLheader(svrl);
        try {
            this.parseSVRL();
        }
        catch (Exception ex) {
            this.svrl = svrl;
        }
    }

    public String getSVRLAsString() {
        return this.svrl;
    }

    public void printFailedMessage(SchematronTask task) {
        if (this.failedAssertions.size() > 0) {
            task.log("Source file: " + this.removePath(this.systemID));
            for (int i = 0; i < this.failedAssertions.size(); ++i) {
                task.log(this.failedAssertions.get(i));
            }
        }
    }

    public String getFailedMessage() {
        String erroutput = "";
        if (this.failedAssertions.size() > 0) {
            for (int i = 0; i < this.failedAssertions.size(); ++i) {
                erroutput = erroutput + this.failedAssertions.get(i);
            }
        }
        return erroutput;
    }

    public void printAllMessage(SchematronTask task) {
        if (this.failedAssertions.size() > 0 || this.successfulReports.size() > 0) {
            task.log("Source file: " + this.removePath(this.systemID));
            int failedAssertionsCount = 0;
            int successfulReportsCount = 0;
            for (String s : this.failedAssertions) {
                try {
                    String theAssertion = s;
                    task.log(theAssertion);
                    if (!theAssertion.startsWith("[assert]")) continue;
                    ++failedAssertionsCount;
                }
                catch (Exception ex) {}
            }
            for (int i = 0; i < this.successfulReports.size(); ++i) {
                task.log(this.successfulReports.get(i));
                if (!this.successfulReports.get(i).startsWith("[assert]")) continue;
                ++successfulReportsCount;
            }
            task.log("Failed assertions: " + failedAssertionsCount);
            task.log("Successful reports: " + successfulReportsCount);
        }
    }

    private void parseSVRL() throws IOException, SAXException, ParserConfigurationException {
        SVRLHandler handler = new SVRLHandler(this.failedAssertions, this.successfulReports);
        InputSource is = new InputSource(new StringReader(this.svrl));
        is.setEncoding("UTF-16");
        SAXParserFactory.newInstance().newSAXParser().parse(is, (DefaultHandler)handler);
    }

    private String removeXMLheader(String svrl) {
        int firstLineEnd = svrl.indexOf("\n");
        if (svrl.startsWith("<?xml ") || svrl.startsWith("<?xml ", 1) || svrl.startsWith("<?xml ", 2) || svrl.startsWith("<?xml ", 3)) {
            return svrl.substring(firstLineEnd + 1);
        }
        return svrl;
    }

    private String removePath(String filename) {
        String[] splitted = filename.split("/");
        return splitted[splitted.length - 1];
    }
}

