/*
 * Decompiled with CFR 0.152.
 */
package com.schematron.ant;

import com.schematron.ant.SchematronResult;
import com.schematron.ant.SchematronTask;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;

public final class SchematronReport {
    private final Hashtable results = new Hashtable();

    public void add(String systemId, String svrl) {
        this.results.put(systemId, svrl);
    }

    public void add(SchematronResult result) {
        this.results.put(result.getSystemID(), result);
    }

    public SchematronResult get(String systemID) {
        return (SchematronResult)this.results.get(systemID);
    }

    public void saveAs(File file) throws IOException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        String date = sdf.format(new Date());
        PrintStream pout = new PrintStream(file, "UTF-8");
        pout.println("<?xml version=\"1.0\" encoding=\"utf-8\" ?>");
        pout.println("<fileset date=\"" + date + "\">");
        Enumeration e = this.results.keys();
        while (e.hasMoreElements()) {
            String sourcefile = (String)e.nextElement();
            String svrlfile = this.get(sourcefile).getSVRLAsString();
            pout.println("<file name=\"" + this.removePath(sourcefile) + "\">");
            pout.println(svrlfile);
            pout.println("</file>");
        }
        pout.println("</fileset>");
        pout.close();
    }

    public void printLog(SchematronTask task) {
        Enumeration e = this.results.keys();
        while (e.hasMoreElements()) {
            String sourcefile = (String)e.nextElement();
            SchematronResult schResult = this.get(sourcefile);
            schResult.printAllMessage(task);
        }
    }

    private String removePath(String filename) {
        String[] splitted = filename.split("/");
        return splitted[splitted.length - 1];
    }
}

