/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner;

import com.hp.hpl.jena.graph.BulkUpdateHandler;
import com.hp.hpl.jena.graph.Capabilities;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphEvents;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Reifier;
import com.hp.hpl.jena.graph.TransactionHandler;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.compose.Union;
import com.hp.hpl.jena.graph.impl.AllCapabilities;
import com.hp.hpl.jena.graph.impl.GraphBase;
import com.hp.hpl.jena.graph.impl.SimpleBulkUpdateHandler;
import com.hp.hpl.jena.graph.impl.TransactionHandlerBase;
import com.hp.hpl.jena.reasoner.FGraph;
import com.hp.hpl.jena.reasoner.Finder;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerException;
import com.hp.hpl.jena.reasoner.StandardValidityReport;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.ValidityReport;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.Iterator;

public abstract class BaseInfGraph
extends GraphBase
implements InfGraph {
    protected Reasoner reasoner;
    protected FGraph fdata;
    protected boolean recordDerivations;
    protected boolean isPrepared = false;
    protected volatile int version = 0;

    public PrefixMapping getPrefixMapping() {
        return this.getRawGraph().getPrefixMapping();
    }

    public Reifier constructReifier() {
        return this.getRawGraph().getReifier();
    }

    public BaseInfGraph(Graph data, Reasoner reasoner) {
        this(data, reasoner, ReificationStyle.Minimal);
    }

    public BaseInfGraph(Graph data, Reasoner reasoner, ReificationStyle style) {
        super(style);
        this.fdata = new FGraph(data);
        this.reasoner = reasoner;
    }

    public Capabilities getCapabilities() {
        if (this.capabilities == null) {
            return this.getReasoner().getGraphCapabilities();
        }
        return this.capabilities;
    }

    public BulkUpdateHandler getBulkUpdateHandler() {
        if (this.bulkHandler == null) {
            this.bulkHandler = new InfBulkUpdateHandler(this);
        }
        return this.bulkHandler;
    }

    public TransactionHandler getTransactionHandler() {
        return new InfTransactionHandler(this);
    }

    protected void discardState() {
    }

    public Graph getRawGraph() {
        return this.fdata.getGraph();
    }

    public Reasoner getReasoner() {
        return this.reasoner;
    }

    public void rebind(Graph data) {
        this.fdata = new FGraph(data);
        this.isPrepared = false;
    }

    public void rebind() {
        ++this.version;
        this.isPrepared = false;
    }

    public void reset() {
        ++this.version;
    }

    public void prepare() {
        this.isPrepared = true;
    }

    public Graph getDeductionsGraph() {
        return null;
    }

    public Node getGlobalProperty(Node property) {
        throw new ReasonerException("Global property not implemented: " + property);
    }

    public boolean testGlobalProperty(Node property) {
        Object result;
        Node resultNode = this.getGlobalProperty(property);
        if (resultNode.isLiteral() && (result = resultNode.getLiteralValue()) instanceof Boolean) {
            return (Boolean)result;
        }
        throw new ReasonerException("Global property test returned non-boolean value\nTest was: " + property + "\nResult was: " + resultNode);
    }

    public ValidityReport validate() {
        this.checkOpen();
        return new StandardValidityReport();
    }

    public ExtendedIterator find(Node subject, Node property, Node object, Graph param) {
        return this.cloneWithPremises(param).find(subject, property, object);
    }

    public ExtendedIterator graphBaseFind(TripleMatch m) {
        return this.graphBaseFind(m.getMatchSubject(), m.getMatchPredicate(), m.getMatchObject());
    }

    public ExtendedIterator graphBaseFind(Node subject, Node property, Node object) {
        return this.findWithContinuation(new TriplePattern(subject, property, object), this.fdata);
    }

    public abstract ExtendedIterator findWithContinuation(TriplePattern var1, Finder var2);

    public ExtendedIterator find(TriplePattern pattern) {
        this.checkOpen();
        return this.findWithContinuation(pattern, this.fdata);
    }

    public void setDerivationLogging(boolean logOn) {
        this.recordDerivations = logOn;
    }

    public Iterator getDerivation(Triple triple) {
        return null;
    }

    public int graphBaseSize() {
        this.checkOpen();
        return this.fdata.getGraph().size();
    }

    public boolean isEmpty() {
        return this.fdata.getGraph().isEmpty();
    }

    public void close() {
        if (!this.closed) {
            this.fdata.getGraph().close();
            this.fdata = null;
            super.close();
        }
    }

    public int getVersion() {
        return this.version;
    }

    public synchronized void performAdd(Triple t) {
        ++this.version;
        if (!this.isPrepared) {
            this.prepare();
        }
        this.fdata.getGraph().add(t);
    }

    public void performDelete(Triple t) {
        ++this.version;
        if (!this.isPrepared) {
            this.prepare();
        }
        this.fdata.getGraph().delete(t);
    }

    public abstract Graph getSchemaGraph();

    public InfGraph cloneWithPremises(Graph premises) {
        return this.getReasoner().bindSchema(this.getSchemaGraph()).bind(new Union(this.getRawGraph(), premises));
    }

    public boolean isPrepared() {
        return this.isPrepared;
    }

    public static class InfTransactionHandler
    extends TransactionHandlerBase
    implements TransactionHandler {
        protected final BaseInfGraph base;

        public InfTransactionHandler(BaseInfGraph base) {
            this.base = base;
        }

        public boolean transactionsSupported() {
            return this.getBaseHandler().transactionsSupported();
        }

        protected TransactionHandler getBaseHandler() {
            return this.base.getRawGraph().getTransactionHandler();
        }

        public void begin() {
            this.getBaseHandler().begin();
        }

        public void abort() {
            this.getBaseHandler().abort();
            this.base.rebind();
        }

        public void commit() {
            this.getBaseHandler().commit();
        }
    }

    static class InfBulkUpdateHandler
    extends SimpleBulkUpdateHandler {
        public InfBulkUpdateHandler(BaseInfGraph graph) {
            super(graph);
        }

        public void remove(Node s, Node p, Node o) {
            BaseInfGraph g = (BaseInfGraph)this.graph;
            g.getRawGraph().getBulkUpdateHandler().remove(s, p, o);
            g.discardState();
            g.rebind();
            this.manager.notifyEvent(this.graph, GraphEvents.remove(s, p, o));
        }

        public void removeAll() {
            BaseInfGraph g = (BaseInfGraph)this.graph;
            g.getRawGraph().getBulkUpdateHandler().removeAll();
            g.discardState();
            g.rebind();
            g.getEventManager().notifyEvent(g, GraphEvents.removeAll);
        }
    }

    public static class InfFindSafeCapabilities
    extends InfCapabilities {
        public boolean findContractSafe() {
            return true;
        }
    }

    public static class InfCapabilities
    extends AllCapabilities {
        public boolean sizeAccurate() {
            return false;
        }

        public boolean deleteAllowed(boolean every) {
            return !every;
        }

        public boolean iteratorRemoveAllowed() {
            return false;
        }

        public boolean findContractSafe() {
            return false;
        }
    }
}

