/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.impl.LiteralLabel;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.impl.LiteralImpl;
import com.hp.hpl.jena.rdf.model.impl.PropertyImpl;
import com.hp.hpl.jena.rdf.model.impl.ResourceImpl;
import com.hp.hpl.jena.rdf.model.impl.StatementImpl;

public class ResourceFactory {
    protected static Interface instance = new Impl();

    private ResourceFactory() {
    }

    public static Interface getInstance() {
        return instance;
    }

    public static Interface setInstance(Interface newInstance) {
        Interface previousInstance = instance;
        instance = newInstance;
        return previousInstance;
    }

    public static Resource createResource() {
        return instance.createResource();
    }

    public static Resource createResource(String uriref) {
        return instance.createResource(uriref);
    }

    public static Literal createPlainLiteral(String string) {
        return instance.createPlainLiteral(string);
    }

    public static Literal createTypedLiteral(String string, RDFDatatype dType) {
        return instance.createTypedLiteral(string, dType);
    }

    public static Literal createTypedLiteral(Object value) {
        return instance.createTypedLiteral(value);
    }

    public static Property createProperty(String uriref) {
        return instance.createProperty(uriref);
    }

    public static Property createProperty(String namespace, String localName) {
        return instance.createProperty(namespace, localName);
    }

    public static Statement createStatement(Resource subject, Property predicate, RDFNode object) {
        return instance.createStatement(subject, predicate, object);
    }

    static class Impl
    implements Interface {
        Impl() {
        }

        public Resource createResource() {
            return new ResourceImpl();
        }

        public Resource createResource(String uriref) {
            return new ResourceImpl(uriref);
        }

        public Literal createPlainLiteral(String string) {
            return new LiteralImpl(string);
        }

        public Literal createTypedLiteral(String string, RDFDatatype dType) {
            return new LiteralImpl(Node.createLiteral(string, "", dType), null);
        }

        public Literal createTypedLiteral(Object value) {
            return new LiteralImpl(Node.createLiteral(new LiteralLabel(value)), null);
        }

        public Property createProperty(String uriref) {
            return new PropertyImpl(uriref);
        }

        public Property createProperty(String namespace, String localName) {
            return new PropertyImpl(namespace, localName);
        }

        public Statement createStatement(Resource subject, Property predicate, RDFNode object) {
            return new StatementImpl(subject, predicate, object);
        }
    }

    public static interface Interface {
        public Resource createResource();

        public Resource createResource(String var1);

        public Literal createPlainLiteral(String var1);

        public Literal createTypedLiteral(String var1, RDFDatatype var2);

        public Literal createTypedLiteral(Object var1);

        public Property createProperty(String var1);

        public Property createProperty(String var1, String var2);

        public Statement createStatement(Resource var1, Property var2, RDFNode var3);
    }
}

