/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.n3;

import com.hp.hpl.jena.n3.Cache1;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.util.FileUtils;
import com.hp.hpl.jena.util.cache.Cache;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Pattern;
import org.apache.commons.logging.LogFactory;

public class RelURI {
    private static String globalBase = null;
    static Cache baseCache = new Cache1();
    static Pattern patternHttp = Pattern.compile("^http://[^/]*/[^/]+");
    static Pattern patternFile = Pattern.compile("^file:/*[^/]+/");
    static Pattern patEnc1 = Pattern.compile("_");
    static String encStr1 = "__";
    static Pattern patEnc2 = Pattern.compile(" ");
    static String encStr2 = "_20";
    static Pattern patDec1 = Pattern.compile("_20");
    static String decStr1 = " ";
    static Pattern patDec2 = Pattern.compile("__");
    static String decStr2 = "_";

    public static String resolve(String relStr, String baseStr) {
        if (relStr.equals(".") && (baseStr.startsWith("http://") || baseStr.startsWith("file:/"))) {
            if (baseStr.endsWith("/")) {
                return baseStr;
            }
            if (patternHttp.matcher(baseStr).find()) {
                int j = baseStr.lastIndexOf("/");
                return baseStr.substring(0, j + 1);
            }
            if (patternFile.matcher(baseStr).find()) {
                int j = baseStr.lastIndexOf("/");
                return baseStr.substring(0, j + 1);
            }
        }
        baseStr = RelURI.encode(baseStr);
        relStr = RelURI.encode(relStr);
        String s = RelURI._resolve(relStr, baseStr);
        s = RelURI.decode(s);
        return s;
    }

    private static String encode(String s) {
        if (s == null) {
            return s;
        }
        s = patEnc1.matcher(s).replaceAll(encStr1);
        s = patEnc2.matcher(s).replaceAll(encStr2);
        return s;
    }

    private static String decode(String s) {
        s = patDec1.matcher(s).replaceAll(decStr1);
        s = patDec2.matcher(s).replaceAll(decStr2);
        return s;
    }

    private static String _resolve(String relStr, String baseStr) {
        URI abs;
        URI rel = null;
        try {
            rel = new URI(relStr);
        }
        catch (URISyntaxException ex) {
            throw new JenaURIException("Illegal URI: " + relStr);
        }
        if (rel.isAbsolute()) {
            String s = rel.getScheme();
            if (rel.getScheme().equals("file")) {
                return RelURI.resolveFileURL(relStr);
            }
            return relStr;
        }
        if (baseStr == null) {
            if (rel.isAbsolute()) {
                return relStr;
            }
            throw new JenaURIException("Null base for relative URI resolution: " + relStr);
        }
        if (baseStr.length() == 0) {
            throw new JenaURIException("Empty base for relative URI resolution");
        }
        if (baseStr.indexOf(35) >= 0) {
            int i = baseStr.indexOf(35);
            baseStr = baseStr.substring(0, i);
        }
        if (baseStr.endsWith(":")) {
            return RelURI.resolve(baseStr + relStr);
        }
        if (relStr.equals("")) {
            return baseStr;
        }
        URI base = (URI)baseCache.get(baseStr);
        if (base == null) {
            try {
                base = new URI(baseStr);
            }
            catch (URISyntaxException ex) {
                throw new JenaURIException("Illegal URI (base): " + baseStr);
            }
            if (!base.isAbsolute()) {
                throw new RelativeURIException("Relative URI for base: " + baseStr);
            }
            if (base.isOpaque()) {
                if (base.getScheme().equals("file") && relStr.startsWith("#")) {
                    return baseStr + relStr;
                }
                throw new RelativeURIException("Can't resolve a relative URI against an opaque URI: rel=" + relStr + " : base=" + baseStr);
            }
            baseCache.put(baseStr, base);
        }
        if (base.getPath().length() == 0 && !relStr.startsWith("/")) {
            try {
                base = new URI(baseStr + "/");
            }
            catch (URISyntaxException ex) {
                LogFactory.getLog((Class)RelURI.class).fatal((Object)("Base now illegal fixing up path-less base URI (" + baseStr + ")"));
                throw new JenaURIException("Illegal URI (base) ptII: " + baseStr);
            }
        }
        if ((abs = RelURI.resolve(rel, base)) == null) {
            return null;
        }
        String s = abs.toString();
        if (s.startsWith("file:")) {
            s = RelURI.resolveFileURL(s);
        }
        return s;
    }

    private static URI resolve(URI rel, URI base) {
        try {
            URI abs = base.resolve(rel);
            if (!abs.isAbsolute()) {
                return null;
            }
            return abs;
        }
        catch (RuntimeException ex) {
            LogFactory.getLog((Class)RelURI.class).warn((Object)("\nException in Java library: " + ex.getMessage() + "\nresolve(" + rel.toString() + ", " + base.toString() + ")"));
            throw ex;
        }
    }

    public static String resolve(String relURI) {
        if (globalBase == null) {
            globalBase = RelURI.chooseBaseURI();
        }
        return RelURI.resolve(relURI, globalBase);
    }

    public static void setBaseURI(String uriBase) {
        if (uriBase != null && uriBase.startsWith("file:/") && !uriBase.startsWith("file:///")) {
            LogFactory.getLog((Class)RelURI.class).warn((Object)"setBaseURI: File URIs should look like 'file:///path' (or at least file://host/path)");
        }
        globalBase = uriBase;
    }

    public static String getBaseURI() {
        return globalBase;
    }

    public static String chooseBaseURI() {
        return RelURI.chooseBaseURI(null);
    }

    public static String chooseBaseURI(String baseURI) {
        String scheme;
        if (baseURI == null) {
            baseURI = "file:.";
        }
        if ((scheme = FileUtils.getScheme(baseURI)) == null) {
            scheme = "file";
            baseURI = "file:" + baseURI;
        }
        if (scheme.equals("file") && !baseURI.startsWith("file:///")) {
            try {
                String tmp = baseURI.substring("file:".length());
                File f = new File(tmp);
                String s = f.getCanonicalPath();
                s = s.replace('\\', '/');
                if (s.indexOf(32) >= 0) {
                    s = s.replaceAll(" ", "%20");
                }
                baseURI = s.startsWith("/") ? "file://" + s : "file:///" + s;
                if (f.isDirectory() && !baseURI.endsWith("/")) {
                    baseURI = baseURI + "/";
                }
            }
            catch (IOException ex) {
                LogFactory.getLog((Class)RelURI.class).warn((Object)"IOException in chooseBase - ignored");
                return null;
            }
        }
        return baseURI;
    }

    public static String resolveFileURL(String filename) {
        String s = filename;
        try {
            if (s.indexOf(92) > -1) {
                s = s.replace('\\', '/');
            }
            if (s.startsWith("file:///")) {
                return s;
            }
            if (s.startsWith("file://")) {
                return s;
            }
            if (s.startsWith("file:/")) {
                s = filename.substring("file:/".length());
                return "file:///" + s;
            }
            if (s.startsWith("file:")) {
                s = filename.substring("file:".length());
            }
            File f = new File(s);
            s = s.endsWith("/") ? f.getAbsolutePath() + "/" : f.getCanonicalPath();
            s = s.replace('\\', '/');
            s = s.startsWith("/") ? "file://" + s : "file:///" + s;
            return s;
        }
        catch (IOException ex) {
            return null;
        }
    }

    public static class RelativeURIException
    extends JenaURIException {
        public RelativeURIException(String msg) {
            super(msg);
        }
    }

    public static class JenaURIException
    extends JenaException {
        public JenaURIException(String msg) {
            super(msg);
        }
    }
}

