/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.assembler.assemblers;

import com.hp.hpl.jena.assembler.Assembler;
import com.hp.hpl.jena.assembler.JA;
import com.hp.hpl.jena.assembler.Mode;
import com.hp.hpl.jena.assembler.assemblers.AssemblerBase;
import com.hp.hpl.jena.assembler.assemblers.RuleSetAssembler;
import com.hp.hpl.jena.assembler.exceptions.CannotHaveRulesException;
import com.hp.hpl.jena.assembler.exceptions.UnknownReasonerException;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerFactory;
import com.hp.hpl.jena.reasoner.ReasonerRegistry;
import com.hp.hpl.jena.reasoner.rulesys.GenericRuleReasoner;
import com.hp.hpl.jena.reasoner.rulesys.GenericRuleReasonerFactory;
import java.util.ArrayList;
import java.util.List;

public class ReasonerFactoryAssembler
extends AssemblerBase
implements Assembler {
    public Object open(Assembler a, Resource root, Mode irrelevant) {
        this.checkType(root, JA.ReasonerFactory);
        return this.addRules(root, a, ReasonerFactoryAssembler.getReasonerFactory(root));
    }

    private ReasonerFactory addRules(Resource root, Assembler a, final ReasonerFactory r) {
        final List rules = RuleSetAssembler.addRules(new ArrayList(), a, root);
        if ((long)rules.size() > 0L) {
            if (r instanceof GenericRuleReasonerFactory) {
                return new ReasonerFactory(){

                    public Reasoner create(Resource configuration) {
                        GenericRuleReasoner result = (GenericRuleReasoner)r.create(configuration);
                        result.addRules(rules);
                        return result;
                    }

                    public Model getCapabilities() {
                        return r.getCapabilities();
                    }

                    public String getURI() {
                        return r.getURI();
                    }
                };
            }
            throw new CannotHaveRulesException(root);
        }
        return r;
    }

    protected Reasoner getReasoner(Resource root) {
        return ReasonerFactoryAssembler.getReasonerFactory(root).create(root);
    }

    protected static ReasonerFactory getReasonerFactory(Resource root) {
        Resource reasonerURL = ReasonerFactoryAssembler.getUniqueResource(root, JA.reasonerURL);
        return reasonerURL == null ? GenericRuleReasonerFactory.theInstance() : ReasonerFactoryAssembler.getReasonerFactoryByURL(root, reasonerURL);
    }

    public static ReasonerFactory getReasonerFactoryByURL(Resource root, Resource reasonerURL) {
        String url = reasonerURL.getURI();
        ReasonerFactory factory = ReasonerRegistry.theRegistry().getFactory(url);
        if (factory == null) {
            throw new UnknownReasonerException(root, reasonerURL);
        }
        return factory;
    }
}

