/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.block;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.block.AbstractBlock;
import org.jfree.chart.block.Block;
import org.jfree.chart.block.RectangleConstraint;
import org.jfree.text.TextBlock;
import org.jfree.text.TextBlockAnchor;
import org.jfree.text.TextUtilities;
import org.jfree.ui.Size2D;

public class LabelBlock
extends AbstractBlock
implements Block {
    private TextBlock label;
    private Font font;

    public LabelBlock(String label) {
        this(label, new Font("Bitstream Vera Sans", 0, 11));
    }

    public LabelBlock(String label, Font font) {
        this.label = TextUtilities.createTextBlock((String)label, (Font)font, (Paint)Color.black);
        this.font = font;
    }

    public Size2D arrange(Graphics2D g2, RectangleConstraint constraint) {
        g2.setFont(this.font);
        Size2D s = this.label.calculateDimensions(g2);
        return s;
    }

    public void draw(Graphics2D g2, Rectangle2D area) {
        g2.setPaint(Color.black);
        g2.setFont(this.font);
        this.label.draw(g2, (float)area.getX(), (float)area.getY(), TextBlockAnchor.TOP_LEFT);
    }
}

