/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.libsbml;

import org.sbml.libsbml.XMLErrorLog;
import org.sbml.libsbml.XMLToken;
import org.sbml.libsbml.libsbmlJNI;

public class XMLInputStream {
    private long swigCPtr;
    protected boolean swigCMemOwn;

    protected XMLInputStream(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(XMLInputStream xMLInputStream) {
        return xMLInputStream == null ? 0L : xMLInputStream.swigCPtr;
    }

    protected static long getCPtrAndDisown(XMLInputStream xMLInputStream) {
        long l = 0L;
        if (xMLInputStream != null) {
            l = xMLInputStream.swigCPtr;
            xMLInputStream.swigCMemOwn = false;
        }
        return l;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L && this.swigCMemOwn) {
            this.swigCMemOwn = false;
            libsbmlJNI.delete_XMLInputStream(this.swigCPtr);
        }
        this.swigCPtr = 0L;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        return this.swigCPtr == XMLInputStream.getCPtr((XMLInputStream)object);
    }

    public int hashCode() {
        return (int)(this.swigCPtr ^ this.swigCPtr >>> 32);
    }

    public XMLInputStream(String string, boolean bl, String string2, XMLErrorLog xMLErrorLog) {
        this(libsbmlJNI.new_XMLInputStream__SWIG_0(string, bl, string2, XMLErrorLog.getCPtr(xMLErrorLog), xMLErrorLog), true);
    }

    public XMLInputStream(String string, boolean bl, String string2) {
        this(libsbmlJNI.new_XMLInputStream__SWIG_1(string, bl, string2), true);
    }

    public XMLInputStream(String string, boolean bl) {
        this(libsbmlJNI.new_XMLInputStream__SWIG_2(string, bl), true);
    }

    public XMLInputStream(String string) {
        this(libsbmlJNI.new_XMLInputStream__SWIG_3(string), true);
    }

    public String getEncoding() {
        return libsbmlJNI.XMLInputStream_getEncoding(this.swigCPtr, this);
    }

    public String getVersion() {
        return libsbmlJNI.XMLInputStream_getVersion(this.swigCPtr, this);
    }

    public XMLErrorLog getErrorLog() {
        long l = libsbmlJNI.XMLInputStream_getErrorLog(this.swigCPtr, this);
        return l == 0L ? null : new XMLErrorLog(l, false);
    }

    public boolean isEOF() {
        return libsbmlJNI.XMLInputStream_isEOF(this.swigCPtr, this);
    }

    public boolean isError() {
        return libsbmlJNI.XMLInputStream_isError(this.swigCPtr, this);
    }

    public boolean isGood() {
        return libsbmlJNI.XMLInputStream_isGood(this.swigCPtr, this);
    }

    public XMLToken next() {
        return new XMLToken(libsbmlJNI.XMLInputStream_next(this.swigCPtr, this), true);
    }

    public XMLToken peek() {
        return new XMLToken(libsbmlJNI.XMLInputStream_peek(this.swigCPtr, this), false);
    }

    public void skipPastEnd(XMLToken xMLToken) {
        libsbmlJNI.XMLInputStream_skipPastEnd(this.swigCPtr, this, XMLToken.getCPtr(xMLToken), xMLToken);
    }

    public void skipText() {
        libsbmlJNI.XMLInputStream_skipText(this.swigCPtr, this);
    }

    public void setErrorLog(XMLErrorLog xMLErrorLog) {
        libsbmlJNI.XMLInputStream_setErrorLog(this.swigCPtr, this, XMLErrorLog.getCPtr(xMLErrorLog), xMLErrorLog);
    }

    public String toString() {
        return libsbmlJNI.XMLInputStream_toString(this.swigCPtr, this);
    }
}

