/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.libsbml;

import org.sbml.libsbml.CubicBezier;
import org.sbml.libsbml.LineSegment;
import org.sbml.libsbml.ListOfLineSegments;
import org.sbml.libsbml.SBase;
import org.sbml.libsbml.XMLNode;
import org.sbml.libsbml.libsbml;
import org.sbml.libsbml.libsbmlJNI;

public class Curve
extends SBase {
    private long swigCPtr;

    protected Curve(long l, boolean bl) {
        super(libsbmlJNI.SWIGCurveUpcast(l), bl);
        this.swigCPtr = l;
    }

    protected static long getCPtr(Curve curve) {
        return curve == null ? 0L : curve.swigCPtr;
    }

    protected static long getCPtrAndDisown(Curve curve) {
        long l = 0L;
        if (curve != null) {
            l = curve.swigCPtr;
            curve.swigCMemOwn = false;
        }
        return l;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L && this.swigCMemOwn) {
            this.swigCMemOwn = false;
            libsbmlJNI.delete_Curve(this.swigCPtr);
        }
        this.swigCPtr = 0L;
        super.delete();
    }

    public Curve() {
        this(libsbmlJNI.new_Curve__SWIG_0(), true);
    }

    public Curve(XMLNode xMLNode) {
        this(libsbmlJNI.new_Curve__SWIG_1(XMLNode.getCPtr(xMLNode), xMLNode), true);
    }

    public Curve(Curve curve) {
        this(libsbmlJNI.new_Curve__SWIG_2(Curve.getCPtr(curve), curve), true);
    }

    public void initDefaults() {
        libsbmlJNI.Curve_initDefaults(this.swigCPtr, this);
    }

    public ListOfLineSegments getListOfCurveSegments() {
        long l = libsbmlJNI.Curve_getListOfCurveSegments(this.swigCPtr, this);
        return l == 0L ? null : new ListOfLineSegments(l, false);
    }

    public LineSegment getCurveSegment(long l) {
        return (LineSegment)libsbml.DowncastSBase(libsbmlJNI.Curve_getCurveSegment__SWIG_0(this.swigCPtr, this, l), false);
    }

    public void addCurveSegment(LineSegment lineSegment) {
        libsbmlJNI.Curve_addCurveSegment(this.swigCPtr, this, LineSegment.getCPtr(lineSegment), lineSegment);
    }

    public long getNumCurveSegments() {
        return libsbmlJNI.Curve_getNumCurveSegments(this.swigCPtr, this);
    }

    public LineSegment createLineSegment() {
        return (LineSegment)libsbml.DowncastSBase(libsbmlJNI.Curve_createLineSegment(this.swigCPtr, this), false);
    }

    public CubicBezier createCubicBezier() {
        long l = libsbmlJNI.Curve_createCubicBezier(this.swigCPtr, this);
        return l == 0L ? null : new CubicBezier(l, false);
    }

    public String getElementName() {
        return libsbmlJNI.Curve_getElementName(this.swigCPtr, this);
    }

    public SBase cloneObject() {
        return libsbml.DowncastSBase(libsbmlJNI.Curve_cloneObject(this.swigCPtr, this), true);
    }

    public int getTypeCode() {
        return libsbmlJNI.Curve_getTypeCode(this.swigCPtr, this);
    }

    public XMLNode toXML() {
        return new XMLNode(libsbmlJNI.Curve_toXML(this.swigCPtr, this), true);
    }
}

