/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp;

import com.sun.media.Log;
import com.sun.media.rtp.OverallStats;
import com.sun.media.rtp.util.BadFormatException;
import com.sun.media.rtp.util.Packet;
import com.sun.media.rtp.util.PacketFilter;
import com.sun.media.rtp.util.RTPPacket;
import com.sun.media.rtp.util.RTPPacketReceiver;
import com.sun.media.rtp.util.UDPPacketReceiver;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import javax.media.rtp.RTPConnector;
import javax.media.rtp.RTPPushDataSource;
import javax.media.rtp.SessionAddress;

public class RTPRawReceiver
extends PacketFilter {
    private OverallStats stats = null;
    private boolean recvBufSizeSet = false;
    public DatagramSocket socket;
    private RTPConnector rtpConnector = null;

    public String filtername() {
        return "RTP Raw Packet Receiver";
    }

    public RTPRawReceiver() {
    }

    public RTPRawReceiver(DatagramSocket sock, OverallStats stats) {
        this.setSource(new UDPPacketReceiver(sock, 2000));
        this.stats = stats;
    }

    public RTPRawReceiver(SessionAddress localAddress, SessionAddress remoteAddress, OverallStats stats, DatagramSocket dataSocket) throws UnknownHostException, IOException, SocketException {
        this.stats = stats;
        UDPPacketReceiver recv = new UDPPacketReceiver(localAddress.getDataPort(), localAddress.getDataHostAddress(), remoteAddress.getDataPort(), remoteAddress.getDataHostAddress(), 2000, dataSocket);
        this.setSource(recv);
        this.socket = recv.getSocket();
    }

    public RTPRawReceiver(int localPort, String localAddress, OverallStats stats) throws UnknownHostException, IOException, SocketException {
        UDPPacketReceiver recv = new UDPPacketReceiver(localPort & 0xFFFFFFFE, localAddress, -1, null, 2000, null);
        this.setSource(recv);
        this.socket = recv.getSocket();
        this.stats = stats;
    }

    public RTPRawReceiver(RTPPushDataSource networkdatasource, OverallStats stats) {
        this.setSource(new RTPPacketReceiver(networkdatasource));
        this.stats = stats;
    }

    public RTPRawReceiver(RTPConnector rtpConnector, OverallStats stats) {
        try {
            this.setSource(new RTPPacketReceiver(rtpConnector.getDataInputStream()));
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        this.rtpConnector = rtpConnector;
        this.stats = stats;
    }

    public void setRecvBufSize(int size) {
        try {
            if (this.socket != null) {
                Class<?> cls = this.socket.getClass();
                Method m2 = cls.getMethod("setReceiveBufferSize", Integer.TYPE);
                m2.invoke((Object)this.socket, new Integer(size));
            } else if (this.rtpConnector != null) {
                this.rtpConnector.setReceiveBufferSize(size);
            }
        }
        catch (Exception e2) {
            Log.comment("Cannot set receive buffer size: " + e2);
        }
    }

    public int getRecvBufSize() {
        try {
            if (this.socket != null) {
                Class<?> cls = this.socket.getClass();
                Method m2 = cls.getMethod("getReceiveBufferSize", null);
                Integer res = (Integer)m2.invoke((Object)this.socket, null);
                return res;
            }
            if (this.rtpConnector != null) {
                return this.rtpConnector.getReceiveBufferSize();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1;
    }

    public void close() {
        if (this.socket != null) {
            this.socket.close();
        }
        if (this.getSource() instanceof RTPPacketReceiver) {
            this.getSource().closeSource();
        }
    }

    public Packet handlePacket(Packet p, int index) {
        return null;
    }

    public Packet handlePacket(Packet p, SessionAddress a2, boolean b2) {
        return null;
    }

    public Packet handlePacket(Packet p, SessionAddress a2) {
        return null;
    }

    public Packet handlePacket(Packet p) {
        RTPPacket result;
        this.stats.update(0, 1);
        this.stats.update(1, p.length);
        try {
            result = this.parse(p);
        }
        catch (BadFormatException e2) {
            this.stats.update(2, 1);
            return null;
        }
        if (!this.recvBufSizeSet) {
            this.recvBufSizeSet = true;
            switch (result.payloadType) {
                case 14: 
                case 26: 
                case 34: 
                case 42: {
                    this.setRecvBufSize(64000);
                    break;
                }
                case 31: {
                    this.setRecvBufSize(128000);
                    break;
                }
                case 32: {
                    this.setRecvBufSize(128000);
                    break;
                }
                default: {
                    if (result.payloadType < 96 || result.payloadType > 127) break;
                    this.setRecvBufSize(64000);
                }
            }
        }
        return result;
    }

    public RTPPacket parse(Packet packet) throws BadFormatException {
        RTPPacket p = new RTPPacket(packet);
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(p.data, p.offset, p.length));
        try {
            int firstbyte = in.readUnsignedByte();
            if ((firstbyte & 0xC0) != 128) {
                throw new BadFormatException();
            }
            if ((firstbyte & 0x10) != 0) {
                p.extensionPresent = true;
            }
            int padlen = 0;
            if ((firstbyte & 0x20) != 0) {
                padlen = p.data[p.offset + p.length - 1] & 0xFF;
            }
            firstbyte &= 0xF;
            p.payloadType = in.readUnsignedByte();
            p.marker = p.payloadType >> 7;
            p.payloadType &= 0x7F;
            p.seqnum = in.readUnsignedShort();
            p.timestamp = (long)in.readInt() & 0xFFFFFFFFL;
            p.ssrc = in.readInt();
            int offset = 0;
            if (p.extensionPresent) {
                p.extensionType = in.readUnsignedShort();
                int extlen = in.readUnsignedShort();
                p.extension = new byte[extlen <<= 2];
                in.readFully(p.extension);
                offset += extlen + 4;
            }
            p.csrc = new int[firstbyte];
            int i2 = 0;
            while (i2 < p.csrc.length) {
                p.csrc[i2] = in.readInt();
                ++i2;
            }
            p.payloadlength = p.length - ((offset += 12 + (p.csrc.length << 2)) + padlen);
            if (p.payloadlength < 1) {
                throw new BadFormatException();
            }
            p.payloadoffset = offset + p.offset;
        }
        catch (EOFException e2) {
            throw new BadFormatException("Unexpected end of RTP packet");
        }
        catch (IOException e3) {
            throw new IllegalArgumentException("Impossible Exception");
        }
        return p;
    }
}

