/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.protocol.avi;

import com.sun.media.JMFSecurity;
import com.sun.media.JMFSecurityManager;
import com.sun.media.util.ContentType;
import com.sun.media.util.JMFI18N;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import javax.media.MediaLocator;
import javax.media.Time;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PullDataSource;
import javax.media.protocol.PullSourceStream;
import javax.media.protocol.Seekable;

class FileDataSource
extends PullDataSource {
    private String fileName;
    private RandomAccessFile raf;
    private boolean connected = false;
    private long length = -1L;
    private String contentType = null;
    private PullSourceStream[] pssArray = new PullSourceStream[1];
    private static JMFSecurity jmfSecurity = null;
    private static boolean securityPrivelege = false;
    private Method[] m = new Method[1];
    private Class[] cl = new Class[1];
    private Object[][] args = new Object[1][0];

    public FileDataSource(String fileName) throws IOException {
        this.fileName = fileName;
    }

    public String getContentType() {
        if (!this.connected) {
            return null;
        }
        return this.contentType;
    }

    public void connect() throws IOException {
        if (this.connected) {
            return;
        }
        try {
            if (securityPrivelege && jmfSecurity != null) {
                try {
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 2);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                }
                catch (Exception e2) {
                    System.err.println("Unable to get read file privilege  " + e2);
                    securityPrivelege = false;
                }
            }
            this.contentType = ContentType.getCorrectedContentType("content/unknown", this.fileName);
            this.contentType = ContentType.getCorrectedContentType("content/unknown", this.fileName);
            this.contentType = ContentDescriptor.mimeTypeToPackageName(this.contentType);
            System.out.println("contentType is " + this.contentType);
            this.raf = new RandomAccessFile(this.fileName, "r");
            this.length = this.raf.length();
            if (this.length < 0L) {
                this.length = -1L;
            }
            RAFPullSourceStream pss = new RAFPullSourceStream();
            this.pssArray[0] = pss;
            this.connected = true;
        }
        catch (IOException ioe) {
            throw new IOException(JMFI18N.getResource("error.filenotfound"));
        }
    }

    public void disconnect() {
        try {
            if (this.raf != null) {
                this.raf.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.pssArray != null) {
            this.pssArray[0] = null;
        }
        this.connected = false;
    }

    public void start() throws IOException {
    }

    public void stop() throws IOException {
    }

    public void setLocator(MediaLocator ml) {
        if (ml != null && ml.getProtocol() != null && ml.getProtocol().equals("file")) {
            MediaLocator saved = ml;
            String file = ml.getRemainder();
            boolean changed = false;
            if (file == null) {
                super.setLocator(ml);
                return;
            }
            try {
                int idx = 0;
                while ((idx = file.indexOf("%", idx)) >= 0) {
                    if (file.length() > idx + 2) {
                        byte[] bytes = new byte[1];
                        try {
                            bytes[0] = (byte)Integer.valueOf(file.substring(idx + 1, idx + 3), 16).intValue();
                            file = file.substring(0, idx) + new String(bytes) + file.substring(idx + 3);
                            changed = true;
                        }
                        catch (NumberFormatException ne) {
                            // empty catch block
                        }
                    }
                    ++idx;
                }
                if (changed) {
                    ml = new MediaLocator(ml.getProtocol() + ":" + file);
                }
            }
            catch (Exception e2) {
                ml = saved;
            }
        }
        super.setLocator(ml);
    }

    public PullSourceStream[] getStreams() {
        return this.pssArray;
    }

    public Time getDuration() {
        return null;
    }

    public Object[] getControls() {
        return new Object[0];
    }

    public Object getControl(String controlType) {
        return null;
    }

    protected String getCorrectedContentType(String contentType) {
        if (contentType != null) {
            String type;
            if (contentType.equals("audio/wav")) {
                contentType = "audio/x-wav";
            } else if (contentType.equals("audio/aiff")) {
                contentType = "audio/x-aiff";
            } else if (contentType.equals("application/x-troff-msvideo")) {
                contentType = "video/x-msvideo";
            } else if (contentType.equals("video/msvideo")) {
                contentType = "video/x-msvideo";
            } else if (contentType.equals("audio/x-mpegaudio")) {
                contentType = "audio/mpeg";
            } else if (contentType.equals("content/unknown") && (type = this.guessContentType(this.getLocator())) != null) {
                contentType = type;
            }
        } else {
            contentType = "content/unknown";
        }
        return contentType;
    }

    private String guessContentType(MediaLocator locator) {
        String path = locator.getRemainder();
        int i2 = path.lastIndexOf(".");
        if (i2 != -1) {
            String ext = path.substring(i2 + 1).toLowerCase();
            if (ext.equals("mov")) {
                return "video/quicktime";
            }
            if (ext.equals("avi")) {
                return "video/x_msvideo";
            }
            if (ext.equals("mpg")) {
                return "video/mpeg";
            }
            if (ext.equals("mpv")) {
                return "video/mpeg";
            }
            if (ext.equals("viv")) {
                return "video/vivo";
            }
            if (ext.equals("au")) {
                return "audio/basic";
            }
            if (ext.equals("wav")) {
                return "audio/x_wav";
            }
            if (ext.equals("mid") || ext.equals("midi")) {
                return "audio/midi";
            }
            if (ext.equals("rmf")) {
                return "audio/rmf";
            }
            if (ext.equals("gsm")) {
                return "audio/x_gsm";
            }
            if (ext.equals("mp2")) {
                return "audio/mpeg";
            }
            if (ext.equals("mp3")) {
                return "audio/mpeg";
            }
            if (ext.equals("mpa")) {
                return "audio/mpeg";
            }
            if (ext.equals("swf")) {
                return "application/x-shockwave-flash";
            }
            if (ext.equals("spl")) {
                return "application/futuresplash";
            }
        }
        return null;
    }

    static {
        try {
            jmfSecurity = JMFSecurityManager.getJMFSecurity();
            securityPrivelege = true;
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    class RAFPullSourceStream
    implements PullSourceStream,
    Seekable {
        RAFPullSourceStream() {
        }

        public long seek(long where) {
            try {
                FileDataSource.this.raf.seek(where);
                return this.tell();
            }
            catch (IOException e2) {
                System.out.println("seek: " + e2);
                return -1L;
            }
        }

        public long tell() {
            try {
                return FileDataSource.this.raf.getFilePointer();
            }
            catch (IOException e2) {
                System.out.println("tell: " + e2);
                return -1L;
            }
        }

        public boolean isRandomAccess() {
            return true;
        }

        public boolean willReadBlock() {
            return false;
        }

        public int read(byte[] buffer, int offset, int length) throws IOException {
            return FileDataSource.this.raf.read(buffer, offset, length);
        }

        public ContentDescriptor getContentDescriptor() {
            return null;
        }

        public long getContentLength() {
            return FileDataSource.this.length;
        }

        public boolean endOfStream() {
            return false;
        }

        public Object[] getControls() {
            return new Object[0];
        }

        public Object getControl(String controlType) {
            return null;
        }
    }
}

