/*
 * Decompiled with CFR 0.152.
 */
package org.sbgn.schematron;

import java.util.ArrayList;
import java.util.List;
import org.sbgn.schematron.Issue;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SVRLHandler
extends DefaultHandler {
    private String roleAttribute;
    private String diagnosticAttribute;
    private String diagnosticId;
    private String message;
    private static final String FAILED_ASSERT_ELT = "svrl:failed-assert";
    private static final String TEXT_ELT = "svrl:text";
    private static final String DIAGNOSTIC_REFERENCE_ELT = "svrl:diagnostic-reference";
    private StringBuffer chars = new StringBuffer();
    private List<Issue> issues = new ArrayList<Issue>();
    private boolean underAssertorReport = false;

    SVRLHandler() {
    }

    @Override
    public void startElement(String uri, String localName, String rawName, Attributes attributes) {
        if (rawName.equals(FAILED_ASSERT_ELT)) {
            this.roleAttribute = attributes.getValue("role");
            if (this.roleAttribute == null) {
                this.roleAttribute = "Error";
            }
            this.underAssertorReport = true;
        } else if (rawName.equals(TEXT_ELT) && this.underAssertorReport) {
            this.getCharacters();
        } else if (rawName.equals(DIAGNOSTIC_REFERENCE_ELT)) {
            this.diagnosticAttribute = attributes.getValue("diagnostic");
            this.getCharacters();
        }
    }

    @Override
    public void endElement(String namespaceURL, String localName, String rawName) {
        if (rawName.equals(TEXT_ELT) && this.underAssertorReport) {
            this.message = this.getCharacters();
            this.underAssertorReport = false;
        } else if (rawName.equals(FAILED_ASSERT_ELT)) {
            this.issues.add(new Issue(this.roleAttribute, this.diagnosticId, this.message));
        } else if (rawName.equals(DIAGNOSTIC_REFERENCE_ELT) && "id".equals(this.diagnosticAttribute)) {
            this.diagnosticId = this.getCharacters();
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.chars.append(ch, start, length);
    }

    private String getCharacters() {
        String retstr = this.chars.toString();
        this.chars.setLength(0);
        return retstr;
    }

    public List<Issue> getIssues() {
        return this.issues;
    }
}

