/*
 * Decompiled with CFR 0.152.
 */
package org.sbgn;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.sbgn.InputStreamToReader;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class SbgnVersionFinder {
    public static int getVersion(File file) throws SAXException, FileNotFoundException, IOException {
        XMLReader xr = XMLReaderFactory.createXMLReader();
        VersionHandler versionHandler = new VersionHandler();
        xr.setEntityResolver(null);
        xr.setContentHandler(versionHandler);
        xr.setErrorHandler(versionHandler);
        xr.parse(new InputSource(InputStreamToReader.inputStreamToReader(new FileInputStream(file))));
        return versionHandler.getVersion();
    }

    private static class VersionHandler
    extends DefaultHandler {
        private int version = -1;

        private VersionHandler() {
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("sbgn".equals(qName)) {
                System.out.println(uri);
                this.version = "http://sbgn.org/libsbgn/0.2".equals(uri) ? 2 : ("http://sbgn.org/libsbgn/pd/0.1".equals(uri) ? 1 : -1);
            }
        }

        public int getVersion() {
            return this.version;
        }
    }
}

