/*
 * Decompiled with CFR 0.152.
 */
package org.jmathml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jmathml.ParseException;
import org.jmathml.RawToken;
import org.jmathml.Token;
import org.jmathml.TokenStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Tokenizer {
    static final String NAME_STR = "\\b[_A-Za-z]\\w*\\b";
    static final String NUMBER_STR = "\\b[0-9]*\\.?[0-9]+([eE][-+]?[0-9]+)?\\b";
    static final Pattern NAME = Pattern.compile("\\b[_A-Za-z]\\w*\\b");
    static final String INTEGER_STR = "[0-9]+";
    static final Pattern NUMBER = Pattern.compile("\\b[0-9]*\\.?[0-9]+([eE][-+]?[0-9]+)?\\b");
    static final Pattern LPAR = Pattern.compile("\\(");
    static final Pattern RPAR = Pattern.compile("\\)");
    static final Pattern ARG_SEP = Pattern.compile(",");
    static final Pattern PLUS = Pattern.compile("\\+");
    static final Pattern MINUS = Pattern.compile("\\-");
    static final Pattern TIMES = Pattern.compile("\\*");
    static final Pattern DIVIDE = Pattern.compile("/");
    static final Pattern POW = Pattern.compile("\\^");
    static final Pattern EQ = Pattern.compile("==");
    static final Pattern NOT = Pattern.compile("!(?!=)");
    static final Pattern NEQ = Pattern.compile("!=");
    static final Pattern GEQ = Pattern.compile(">=");
    static final Pattern GT = Pattern.compile(">");
    static final Pattern LEQ = Pattern.compile("<=");
    static final Pattern LT = Pattern.compile("<");
    static final Pattern AND = Pattern.compile("&&");
    static final Pattern OR = Pattern.compile("\\|\\|");
    static final Pattern[] patterns = new Pattern[]{NAME, NUMBER, LPAR, RPAR, ARG_SEP, PLUS, MINUS, TIMES, DIVIDE, POW, EQ, NOT, NEQ, LEQ, LT, GEQ, GT, AND, OR};

    Tokenizer() {
    }

    TokenStream tokenize(String string) throws ParseException {
        assert (string != null);
        ArrayList<RawToken> arrayList = new ArrayList<RawToken>();
        for (int i = 0; i < string.length(); ++i) {
            arrayList.add(new RawToken(string.charAt(i)));
        }
        ArrayList<Token> arrayList2 = new ArrayList<Token>();
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        for (int i = 0; i < patterns.length; ++i) {
            Pattern pattern = patterns[i];
            Iterator iterator = pattern.matcher(string);
            while (((Matcher)((Object)iterator)).find()) {
                String object2 = ((Matcher)((Object)iterator)).group();
                if (this.isAlreadyMatched(arrayList, (Matcher)((Object)iterator))) continue;
                hashMap.put(((Matcher)((Object)iterator)).start(), object2);
                for (int j = ((Matcher)((Object)iterator)).start(); j < ((Matcher)((Object)iterator)).end(); ++j) {
                    ((RawToken)arrayList.get(j)).setMatched(true);
                }
            }
        }
        ArrayList arrayList3 = new ArrayList(hashMap.keySet());
        Collections.sort(arrayList3);
        for (Iterator iterator : arrayList3) {
            Token token = new Token((String)hashMap.get(iterator));
            arrayList2.add(token);
        }
        int n = 0;
        for (RawToken rawToken : arrayList) {
            if (!rawToken.isMatched()) {
                throw new ParseException("[" + rawToken.getRawToken() + "] could not be parsed at position: " + n);
            }
            ++n;
        }
        return new TokenStream(arrayList2);
    }

    private boolean isAlreadyMatched(List<RawToken> list, Matcher matcher) {
        for (int i = matcher.start(); i < matcher.end(); ++i) {
            if (!list.get(i).isMatched()) continue;
            return true;
        }
        return false;
    }
}

