/*
 * Decompiled with CFR 0.152.
 */
package org.jmathml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jmathml.Token;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TokenStream
implements Iterable<Token> {
    private List<Token> tokens;

    TokenStream(List<Token> list) {
        this.tokens = list;
    }

    TokenStream subList(int n, int n2) {
        ArrayList<Token> arrayList = new ArrayList<Token>();
        for (int i = n; i < n2; ++i) {
            arrayList.add(this.tokens.get(i));
        }
        return new TokenStream(arrayList);
    }

    public int size() {
        return this.tokens.size();
    }

    public Token get(int n) {
        return this.tokens.get(n);
    }

    public TokenIterator iterator() {
        return new TokenIterator();
    }

    public boolean startsWith(Token token) {
        return this.tokens.indexOf(token) == 0;
    }

    public boolean endsWith(Token token) {
        return this.tokens.lastIndexOf(token) == this.tokens.size() - 1;
    }

    String join() {
        StringBuffer stringBuffer = new StringBuffer();
        for (Token token : this.tokens) {
            stringBuffer.append(token.getString());
        }
        return stringBuffer.toString();
    }

    public TokenStream trimExtraneousParentheses() {
        if (this.startsWith(new Token("(")) && this.endsWith(new Token(")")) && this.allOneElement()) {
            TokenStream tokenStream = new TokenStream(this.tokens.subList(1, this.tokens.size() - 1));
            return tokenStream.trimExtraneousParentheses();
        }
        return this;
    }

    private boolean allOneElement() {
        TokenIterator tokenIterator = this.iterator();
        int n = 0;
        while (tokenIterator.hasNext()) {
            Token token = tokenIterator.next();
            if (token.getString().equals("(")) {
                ++n;
            }
            if (token.getString().equals(")")) {
                --n;
            }
            if (n != 0 || tokenIterator.peek() == null) continue;
            return false;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TokenIterator
    implements Iterator<Token> {
        private int currIndx = -1;

        TokenIterator() {
        }

        Token previous() {
            if (this.currIndx <= 0) {
                return null;
            }
            return (Token)TokenStream.this.tokens.get(this.currIndx - 1);
        }

        @Override
        public boolean hasNext() {
            return this.currIndx < TokenStream.this.tokens.size() - 1;
        }

        Token peek() {
            if (this.hasNext()) {
                return (Token)TokenStream.this.tokens.get(this.currIndx + 1);
            }
            return null;
        }

        @Override
        public Token next() {
            return (Token)TokenStream.this.tokens.get(++this.currIndx);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

