/*
 * Decompiled with CFR 0.152.
 */
package org.jmathml;

import org.jmathml.ASTNumber;

class Token {
    private String string;
    private boolean isFunction = false;
    private boolean isUnaryMinus = false;

    Token(String string) {
        this.string = string;
    }

    String getString() {
        return this.string;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.string == null ? 0 : this.string.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Token token = (Token)object;
        return !(this.string == null ? token.string != null : !this.string.equals(token.string));
    }

    boolean isArithmeticOperator() {
        return this.string.equals("+") || this.string.equals("-") || this.string.equals("*") || this.string.equals("/") || this.string.equals("^");
    }

    boolean isRelationalOperator() {
        return this.string.equals(">") || this.string.equals("<") || this.string.equals(">=") || this.string.equals("<=") || this.string.equals("==") || this.string.equals("!=");
    }

    boolean isLogicalOperator() {
        return this.string.equals("&&") || this.string.equals("||") || this.string.equals("!");
    }

    boolean isOperator() {
        return this.isArithmeticOperator() || this.isRelationalOperator() || this.isLogicalOperator() || this.isArgSeparator();
    }

    private boolean isArgSeparator() {
        return this.string.equals(",");
    }

    boolean isLPar() {
        return this.string.equals("(");
    }

    boolean isRPar() {
        return this.string.equals(")");
    }

    public boolean isIdentifier() {
        return this.string.matches("\\b[_A-Za-z]\\w*\\b");
    }

    public boolean isUnary() {
        return this.isFunction || this.isUnaryMinus || this.string.matches("!");
    }

    void setIsFunction(boolean bl) {
        if (this.isIdentifier()) {
            this.isFunction = bl;
        }
    }

    boolean isFunction() {
        return this.isFunction;
    }

    public boolean isNumber() {
        return this.string.matches("\\b[0-9]*\\.?[0-9]+([eE][-+]?[0-9]+)?\\b");
    }

    public boolean isConstant() {
        return ASTNumber.isConstant(this.string);
    }

    public void setIsUnaryMinus(boolean bl) {
        if (this.string.equals("-")) {
            this.isUnaryMinus = bl;
        }
    }

    public boolean isUnaryMinus() {
        return this.isUnaryMinus;
    }

    public boolean isInteger() {
        return this.string.matches("[0-9]+");
    }
}

