/*
 * Decompiled with CFR 0.152.
 */
package org.jmathml;

import org.jmathml.ASTCi;
import org.jmathml.ASTDivide;
import org.jmathml.ASTFunction;
import org.jmathml.ASTLogical;
import org.jmathml.ASTMinus;
import org.jmathml.ASTNode;
import org.jmathml.ASTNumber;
import org.jmathml.ASTPlus;
import org.jmathml.ASTPower;
import org.jmathml.ASTRelational;
import org.jmathml.ASTSymbol;
import org.jmathml.ASTTimes;
import org.jmathml.SymbolRegistry;
import org.jmathml.Token;
import org.jmathml.TokenStream;
import org.jmathml.Tokenizer;

public class TextToASTNodeMathParser2 {
    public ASTNode parseString(String string, ASTNode aSTNode) {
        String string2 = string.replaceAll(" ", "");
        Tokenizer tokenizer = new Tokenizer();
        TokenStream tokenStream = tokenizer.tokenize(string2).trimExtraneousParentheses();
        return this.parseTokens(tokenStream, aSTNode);
    }

    ASTNode parseTokens(TokenStream tokenStream, ASTNode aSTNode) {
        Object object;
        int n = 0;
        Object object2 = null;
        int n2 = -1;
        int n3 = 10;
        int n4 = 0;
        TokenStream.TokenIterator tokenIterator = tokenStream.iterator();
        while (tokenIterator.hasNext()) {
            int n5;
            object = tokenIterator.next();
            if (((Token)object).getString().equals("(")) {
                ++n4;
            } else if (((Token)object).getString().equals(")")) {
                --n4;
            }
            if (n4 == 0 && (n5 = this.getPrecedenceForToken((Token)object, tokenIterator)) <= n3) {
                object2 = object;
                n3 = n5;
                n2 = n;
            }
            ++n;
        }
        object = null;
        if (n2 != -1) {
            object = this.createNodeForLowestPrecedence((Token)object2);
            if (object != null) {
                aSTNode.addChildNode((ASTNode)object);
            } else {
                object = aSTNode;
            }
            if (((Token)object2).isOperator() && !((Token)object2).isUnaryMinus()) {
                TokenStream tokenStream2 = tokenStream.subList(0, n2).trimExtraneousParentheses();
                TokenStream tokenStream3 = tokenStream.subList(n2 + 1, tokenStream.size()).trimExtraneousParentheses();
                this.parseTokens(tokenStream2, (ASTNode)object);
                this.parseTokens(tokenStream3, (ASTNode)object);
            } else if (((Token)object2).isUnary()) {
                TokenStream tokenStream4 = tokenStream.subList(n2 + 1, tokenStream.size()).trimExtraneousParentheses();
                this.parseTokens(tokenStream4, (ASTNode)object);
            } else {
                if (((Token)object2).isNumber()) {
                    return object;
                }
                if (((Token)object2).isIdentifier()) {
                    return object;
                }
            }
        }
        return object;
    }

    private ASTNode createNodeForLowestPrecedence(Token token) {
        String string = token.getString();
        if (string.equals("+")) {
            return new ASTPlus();
        }
        if (string.equals("-")) {
            return new ASTMinus();
        }
        if (string.equals("*")) {
            return new ASTTimes();
        }
        if (token.isConstant()) {
            ASTNumber aSTNumber = ASTNumber.getConstant(string);
            return aSTNumber;
        }
        if (token.isFunction()) {
            ASTSymbol aSTSymbol;
            ASTNode aSTNode = ASTFunction.createFunctionNode(ASTFunction.getFunctionTypeForName(string));
            if (aSTNode.getType().equals(ASTFunction.ASTFunctionType.MISCELLANEOUS) && (aSTSymbol = SymbolRegistry.getInstance().createSymbolFor(token.getString())) != null) {
                aSTNode = aSTSymbol;
            }
            return aSTNode;
        }
        if (token.isNumber()) {
            ASTNumber aSTNumber = null;
            aSTNumber = token.isInteger() ? ASTNumber.createNumber(Integer.parseInt(string)) : ASTNumber.createNumber(Double.parseDouble(string));
            return aSTNumber;
        }
        if (token.isIdentifier()) {
            ASTCi aSTCi = new ASTCi(string);
            return aSTCi;
        }
        if (string.equals("/")) {
            return new ASTDivide();
        }
        if (string.equals("^")) {
            return new ASTPower();
        }
        if (string.equals(">")) {
            return new ASTRelational(ASTRelational.ASTRelationalType.GT);
        }
        if (string.equals("<")) {
            return new ASTRelational(ASTRelational.ASTRelationalType.LT);
        }
        if (string.equals("<=")) {
            return new ASTRelational(ASTRelational.ASTRelationalType.LEQ);
        }
        if (string.equals(">=")) {
            return new ASTRelational(ASTRelational.ASTRelationalType.GEQ);
        }
        if (string.equals("==")) {
            return new ASTRelational(ASTRelational.ASTRelationalType.EQ);
        }
        if (string.equals("!=")) {
            return new ASTRelational(ASTRelational.ASTRelationalType.NEQ);
        }
        if (string.equals("||")) {
            return new ASTLogical(ASTLogical.ASTLogicalType.OR);
        }
        if (string.equals("&&")) {
            return new ASTLogical(ASTLogical.ASTLogicalType.AND);
        }
        if (string.equals("!")) {
            return new ASTLogical(ASTLogical.ASTLogicalType.NOT);
        }
        if (string.equals(",")) {
            return null;
        }
        return new ASTCi("");
    }

    private int getPrecedenceForToken(Token token, TokenStream.TokenIterator tokenIterator) {
        String string = token.getString();
        if (string.equals("+") || string.equals("-")) {
            if (string.equals("-")) {
                if (tokenIterator.previous() == null || tokenIterator.previous().isOperator() || tokenIterator.previous().isLPar()) {
                    token.setIsUnaryMinus(true);
                    return 7;
                }
                return 4;
            }
            return 4;
        }
        if (token.isRelationalOperator()) {
            return 3;
        }
        if (token.isLogicalOperator()) {
            return 2;
        }
        if (string.equals("*") || string.equals("/")) {
            return 5;
        }
        if (string.equals("^")) {
            return 6;
        }
        if (string.equals(",")) {
            return 1;
        }
        if (token.isIdentifier()) {
            if (tokenIterator.peek() != null && tokenIterator.peek().isLPar()) {
                token.setIsFunction(true);
                return 8;
            }
            return 9;
        }
        if (token.isNumber()) {
            return 9;
        }
        return 12;
    }
}

