/*
 * Decompiled with CFR 0.152.
 */
package org.jmathml;

import org.jmathml.ASTCi;
import org.jmathml.ASTDivide;
import org.jmathml.ASTFunction;
import org.jmathml.ASTLogical;
import org.jmathml.ASTMinus;
import org.jmathml.ASTNode;
import org.jmathml.ASTNumber;
import org.jmathml.ASTPlus;
import org.jmathml.ASTPower;
import org.jmathml.ASTRelational;
import org.jmathml.ASTTimes;
import org.jmathml.Token;
import org.jmathml.TokenStream;
import org.jmathml.Tokenizer;

public class TextToASTNodeMathParser {
    public ASTNode parseString(String string, ASTNode aSTNode) {
        string = this.tidyUp(string);
        String string2 = string.replaceAll(" ", "");
        Tokenizer tokenizer = new Tokenizer();
        TokenStream tokenStream = tokenizer.tokenize(string2);
        return this.parseTokens(tokenStream, aSTNode);
    }

    ASTNode parseTokens(TokenStream tokenStream, ASTNode aSTNode) {
        Object object;
        Object object2;
        int n;
        Object object32;
        int n2 = 0;
        String string = " ";
        int n3 = -1;
        int n4 = 7;
        int n5 = 0;
        for (Object object32 : tokenStream) {
            if (((Token)object32).getString().equals("(")) {
                ++n5;
            } else if (((Token)object32).getString().equals(")")) {
                --n5;
            }
            if (n5 == 0 && (n = this.getPrecedenceForToken((Token)object32)) <= n4) {
                string = ((Token)object32).getString();
                n4 = n;
                n3 = n2;
            }
            ++n2;
        }
        object32 = null;
        n = 0;
        if (n3 != -1) {
            object32 = this.createNodeForLowestPrecedence(string);
            if (object32 != null) {
                aSTNode.addChildNode((ASTNode)object32);
            } else {
                object32 = aSTNode;
            }
            object2 = tokenStream.subList(0, n3);
            object = tokenStream.subList(n3 + 1, tokenStream.size());
            this.parseTokens((TokenStream)object2, (ASTNode)object32);
            this.parseTokens((TokenStream)object, (ASTNode)object32);
            n = 1;
        }
        if (n != 0) {
            return object32;
        }
        object2 = this.tidyUp(this.join(tokenStream));
        if (ASTNumber.isConstant((String)object2)) {
            object = ASTNumber.getConstant((String)object2);
            aSTNode.addChildNode((ASTNode)object);
            return object;
        }
        if (this.isVarName(this.join(tokenStream))) {
            object = new ASTCi(((String)object2).trim());
            aSTNode.addChildNode((ASTNode)object);
            return object;
        }
        if (this.isNumber(((String)object2).trim())) {
            object = ASTNumber.createNumber(Double.parseDouble(((String)object2).trim()));
            aSTNode.addChildNode((ASTNode)object);
            return object;
        }
        if (this.isFunction(((String)object2).trim())) {
            object = ASTFunction.createFunctionNode(ASTFunction.getFunctionTypeForName(this.getCandidateFunctionName((String)object2)));
            if (((ASTNode)object).getType().equals(ASTFunction.ASTFunctionType.MISCELLANEOUS)) {
                object = new ASTFunction.ASTMiscellaneousFunction(this.getCandidateFunctionName((String)object2));
            }
            aSTNode.addChildNode((ASTNode)object);
            String string2 = ((String)object2).substring(((String)object2).indexOf(40) + 1, ((String)object2).lastIndexOf(41));
            return this.parseString(this.tidyUp(string2), (ASTNode)object);
        }
        if (this.isGroup(((String)object2).trim())) {
            while (((String)object2).charAt(1) == '(' && ((String)object2).charAt(((String)object2).length() - 2) == ')') {
                object2 = ((String)object2).substring(1, ((String)object2).length() - 1);
            }
            object = ((String)object2).substring(((String)object2).lastIndexOf(40) + 1, ((String)object2).indexOf(41));
            return this.parseString(this.tidyUp((String)object), aSTNode);
        }
        return object32;
    }

    private String tidyUp(String string) {
        if (string.startsWith("(") && string.endsWith(")")) {
            return string.substring(string.indexOf(40) + 1, string.lastIndexOf(41));
        }
        return string;
    }

    private boolean isGroup(String string) {
        return string.contains("(") && string.contains(")");
    }

    private String getCandidateFunctionName(String string) {
        if (!string.contains("(")) {
            return "";
        }
        return string.substring(0, string.indexOf(40));
    }

    private boolean isFunction(String string) {
        if (!string.contains("(")) {
            return false;
        }
        String string2 = this.getCandidateFunctionName(string);
        return this.isVarName(string2);
    }

    private boolean isVarName(String string) {
        return string.matches("[_A-Za-z][_\\w\\d]*");
    }

    private boolean isNumber(String string) {
        return string.matches("[-+]?[0-9]*\\.?[0-9]+([eE][-+]?[0-9]+)?");
    }

    private ASTNode createNodeForLowestPrecedence(String string) {
        if (string.equals("+")) {
            return new ASTPlus();
        }
        if (string.equals("-")) {
            return new ASTMinus();
        }
        if (string.equals("*")) {
            return new ASTTimes();
        }
        if (string.equals("/")) {
            return new ASTDivide();
        }
        if (string.equals("^")) {
            return new ASTPower();
        }
        if (string.equals(">")) {
            return new ASTRelational(ASTRelational.ASTRelationalType.GT);
        }
        if (string.equals("<")) {
            return new ASTRelational(ASTRelational.ASTRelationalType.LT);
        }
        if (string.equals("<=")) {
            return new ASTRelational(ASTRelational.ASTRelationalType.LEQ);
        }
        if (string.equals(">=")) {
            return new ASTRelational(ASTRelational.ASTRelationalType.GEQ);
        }
        if (string.equals("==")) {
            return new ASTRelational(ASTRelational.ASTRelationalType.EQ);
        }
        if (string.equals("!=")) {
            return new ASTRelational(ASTRelational.ASTRelationalType.NEQ);
        }
        if (string.equals("||")) {
            return new ASTLogical(ASTLogical.ASTLogicalType.OR);
        }
        if (string.equals("&&")) {
            return new ASTLogical(ASTLogical.ASTLogicalType.AND);
        }
        if (string.equals(",")) {
            return null;
        }
        return new ASTCi("");
    }

    private int getPrecedenceForToken(Token token) {
        String string = token.getString();
        if (string.equals("+") || string.equals("-")) {
            return 3;
        }
        if (string.equals(">") || string.equals("<") || string.equals("<=") || string.equals(">=") || string.equals("==") || string.equals("!=")) {
            return 2;
        }
        if (string.equals("*") || string.equals("/")) {
            return 4;
        }
        if (string.equals("^")) {
            return 5;
        }
        if (string.equals(",")) {
            return 1;
        }
        return 12;
    }

    private String join(TokenStream tokenStream) {
        StringBuffer stringBuffer = new StringBuffer();
        for (Token token : tokenStream) {
            stringBuffer.append(token.getString());
        }
        return stringBuffer.toString();
    }
}

