/*
 * Decompiled with CFR 0.152.
 */
package org.jmathml;

import java.util.ArrayList;
import java.util.List;
import org.jmathml.ASTSymbol;
import org.jmathml.ASTSymbolFactory;

public class SymbolRegistry {
    private static SymbolRegistry instance;
    private List<ASTSymbolFactory> listOfFactories = new ArrayList<ASTSymbolFactory>();

    private SymbolRegistry() {
    }

    public static SymbolRegistry getInstance() {
        if (instance == null) {
            instance = new SymbolRegistry();
        }
        return instance;
    }

    public final boolean addSymbolFactory(ASTSymbolFactory aSTSymbolFactory) {
        if (!this.listOfFactories.contains(aSTSymbolFactory)) {
            return this.listOfFactories.add(aSTSymbolFactory);
        }
        return false;
    }

    public final boolean removeSymbolFactory(ASTSymbolFactory aSTSymbolFactory) {
        return this.listOfFactories.remove(aSTSymbolFactory);
    }

    void clearFactories() {
        this.listOfFactories.clear();
    }

    ASTSymbol createSymbolFor(String string, String string2) {
        for (ASTSymbolFactory aSTSymbolFactory : this.listOfFactories) {
            if (!aSTSymbolFactory.canCreateSymbol(string)) continue;
            return aSTSymbolFactory.createSymbol(string);
        }
        return null;
    }

    ASTSymbol createSymbolFor(String string) {
        for (ASTSymbolFactory aSTSymbolFactory : this.listOfFactories) {
            if (!aSTSymbolFactory.canCreateSymbol(string)) continue;
            return aSTSymbolFactory.createSymbol(string);
        }
        return null;
    }
}

