/*
 * Decompiled with CFR 0.152.
 */
package org.jmathml;

import org.jmathml.ASTNumber;

class RealNumber
extends ASTNumber {
    Double real = 0.0;
    long intVal = 0L;
    final int UNKNOWN = 1;
    final int INTEGER = 2;
    final int DOUBLE = 1;
    int type = 1;

    RealNumber(Double d) {
        super(ASTNumber.ASTNumberType.NUMBER);
        this.real = d;
        this.type = 1;
        this.setName(this.getString());
    }

    RealNumber(int n) {
        super(ASTNumber.ASTNumberType.NUMBER);
        this.intVal = n;
        this.type = 2;
        this.setName(this.getString());
    }

    RealNumber(long l) {
        super(ASTNumber.ASTNumberType.NUMBER);
        this.intVal = l;
        this.type = 2;
        this.setName(this.getString());
    }

    public long getIntValue() {
        return this.intVal;
    }

    public String getString() {
        if (this.type == 2) {
            return Long.toString(this.intVal);
        }
        if (this.type == 1) {
            if (this.isInfinity()) {
                return "infinity";
            }
            if (this.real == Double.NEGATIVE_INFINITY) {
                return "-infinity";
            }
            if (this.isNaN()) {
                return "notanumber";
            }
            if (this.isE()) {
                return "exponentiale";
            }
            if (this.isPI()) {
                return "pi";
            }
            return Double.toString(this.real);
        }
        return Double.toString(Double.NaN);
    }

    public double getValue() {
        return this.type == 2 ? (double)this.intVal : this.real;
    }

    public boolean isInteger() {
        return this.type == 2;
    }
}

