/*
 * Decompiled with CFR 0.152.
 */
package org.jmathml;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Text;
import org.jdom.input.SAXBuilder;
import org.jmathml.ASTCi;
import org.jmathml.ASTDivide;
import org.jmathml.ASTFunction;
import org.jmathml.ASTLogical;
import org.jmathml.ASTMinus;
import org.jmathml.ASTNode;
import org.jmathml.ASTNumber;
import org.jmathml.ASTPlus;
import org.jmathml.ASTRelational;
import org.jmathml.ASTRootNode;
import org.jmathml.ASTSymbol;
import org.jmathml.ASTTimes;
import org.jmathml.ENotationNumber;
import org.jmathml.FormulaFormatter;
import org.jmathml.RationalNumber;
import org.jmathml.SymbolRegistry;

public class MathMLReader {
    private ASTNode curr;
    private ASTNode root;

    public static String MathMLXMLToText(String string) {
        System.err.println(string);
        MathMLReader mathMLReader = new MathMLReader();
        try {
            Element element = mathMLReader.readXML(new StringReader(string));
            ASTNode aSTNode = mathMLReader.parseMathML(element);
            return new FormulaFormatter().formulaToString(aSTNode);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return "Could not be formatted";
        }
    }

    public ASTNode parseMathMLFromString(String string) throws IOException {
        Element element = this.readXML(new StringReader(string));
        return this.parseMathML(element);
    }

    public Element readXML(Reader reader) throws IOException {
        try {
            SAXBuilder sAXBuilder = new SAXBuilder(false);
            Document document = sAXBuilder.build(reader);
            Element element = document.getRootElement();
            return element;
        }
        catch (JDOMException jDOMException) {
            jDOMException.printStackTrace(System.out);
            throw new IOException(jDOMException.getMessage());
        }
    }

    public ASTNode parseMathML(Element element) {
        List list;
        Object object;
        if (element.getName().equals("math")) {
            this.curr = this.root = new ASTRootNode();
        } else if (element.getName().equals("plus")) {
            object = new ASTPlus();
            this.curr.addChildNode((ASTNode)object);
            this.curr = object;
        } else if (element.getName().equals("minus")) {
            object = new ASTMinus();
            this.curr.addChildNode((ASTNode)object);
            this.curr = object;
        } else if (element.getName().equals("times")) {
            object = new ASTTimes();
            this.curr.addChildNode((ASTNode)object);
            this.curr = object;
        } else if (element.getName().equals("divide")) {
            object = new ASTDivide();
            this.curr.addChildNode((ASTNode)object);
            this.curr = object;
        } else if (element.getName().equals("ci")) {
            object = new ASTCi(element.getText().trim());
            this.curr.addChildNode((ASTNode)object);
        } else if (element.getName().equals("cn")) {
            this.parseNumberElement(element);
        } else if (element.getName().equals("csymbol")) {
            element.getValue();
            object = SymbolRegistry.getInstance().createSymbolFor(element.getAttributeValue("definitionURL"));
            if (object == null) {
                throw new RuntimeException("Could not create symbol for " + element.getAttributeValue("definitionURL"));
            }
            ((ASTSymbol)object).setDefinitionURL(element.getAttributeValue("definitionURL"));
            ((ASTSymbol)object).setEncoding(element.getAttributeValue("encoding"));
            ((ASTNode)object).setName(element.getValue());
            this.curr.addChildNode((ASTNode)object);
            List list2 = element.getParentElement().getChildren();
            list = (Element)list2.get(0);
            if (list.getName().equals("csymbol")) {
                this.curr = object;
            }
        } else if (this.isLogical(element)) {
            if (element.getName().equals("and")) {
                this.curr.addChildNode(new ASTLogical(ASTLogical.ASTLogicalType.AND));
            } else if (element.getName().equals("or")) {
                this.curr.addChildNode(new ASTLogical(ASTLogical.ASTLogicalType.OR));
            } else if (element.getName().equals("xor")) {
                this.curr.addChildNode(new ASTLogical(ASTLogical.ASTLogicalType.XOR));
            } else if (element.getName().equals("not")) {
                this.curr.addChildNode(new ASTLogical(ASTLogical.ASTLogicalType.NOT));
            }
            this.curr = this.curr.getRightChild();
        } else if (this.isRelational(element)) {
            if (element.getName().equals("eq")) {
                this.curr.addChildNode(new ASTRelational(ASTRelational.ASTRelationalType.EQ));
            } else if (element.getName().equals("neq")) {
                this.curr.addChildNode(new ASTRelational(ASTRelational.ASTRelationalType.NEQ));
            } else if (element.getName().equals("gt")) {
                this.curr.addChildNode(new ASTRelational(ASTRelational.ASTRelationalType.GT));
            } else if (element.getName().equals("geq")) {
                this.curr.addChildNode(new ASTRelational(ASTRelational.ASTRelationalType.GEQ));
            } else if (element.getName().equals("lt")) {
                this.curr.addChildNode(new ASTRelational(ASTRelational.ASTRelationalType.LT));
            } else if (element.getName().equals("leq")) {
                this.curr.addChildNode(new ASTRelational(ASTRelational.ASTRelationalType.LEQ));
            }
            this.curr = this.curr.getRightChild();
        } else if (element.getName().equals("logbase")) {
            object = (Element)element.getChildren().get(0);
            int n = Integer.parseInt(object.getText().trim());
            ((ASTFunction.ASTLog)this.curr).addChildNode(ASTNumber.createNumber(n));
        } else if (this.isFunction(element)) {
            int n;
            Element element2;
            object = ASTFunction.getFunctionTypeForName(element.getName());
            ASTFunction aSTFunction = null;
            if (((Enum)object).equals(ASTFunction.ASTFunctionType.LOG)) {
                list = ((Element)element.getParent()).getChildren();
                for (Element element3 : list) {
                    if (!element3.getName().equals("logbase")) continue;
                    element2 = (Element)element3.getChildren().get(0);
                    n = Integer.parseInt(element2.getText().trim());
                    aSTFunction = ASTFunction.createASTLog(n);
                }
            } else if (((Enum)object).equals(ASTFunction.ASTFunctionType.ROOT)) {
                list = ((Element)element.getParent()).getChildren();
                for (Element element3 : list) {
                    if (!element3.getName().equals("degree")) continue;
                    element2 = (Element)element3.getChildren().get(0);
                    n = Integer.parseInt(element2.getText().trim());
                    aSTFunction = ASTFunction.createASTRoot(n);
                }
            }
            if (aSTFunction == null) {
                aSTFunction = ASTFunction.createFunctionNode((ASTFunction.ASTFunctionType)object);
            }
            this.curr.addChildNode(aSTFunction);
            this.curr = aSTFunction;
        }
        object = element.getChildren();
        for (int i = 0; i < element.getChildren().size(); ++i) {
            if (this.shouldIgnore(((Element)object.get(i)).getName())) continue;
            this.parseMathML((Element)object.get(i));
            if (this.curr == this.root || !((Element)object.get(i)).getName().equals("apply")) continue;
            this.curr = this.curr.getParentNode();
        }
        return this.curr;
    }

    private boolean shouldIgnore(String string) {
        return string.equals("logbase") || string.equals("degree");
    }

    private boolean isLogical(Element element) {
        return element.getName().equals("and") || element.getName().equals("or") || element.getName().equals("not") || element.getName().equals("xor");
    }

    private boolean isRelational(Element element) {
        return element.getName().equals("eq") || element.getName().equals("neq") || element.getName().equals("geq") || element.getName().equals("gt") || element.getName().equals("leq") || element.getName().equals("lt");
    }

    private boolean isFunction(Element element) {
        return ASTFunction.getFunctionTypeForName(element.getName()) != null && !ASTFunction.getFunctionTypeForName(element.getName()).equals(ASTFunction.ASTFunctionType.MISCELLANEOUS);
    }

    private void parseNumberElement(Element element) {
        if (element.getAttribute("type") != null && element.getAttribute("type").getValue().equals("integer")) {
            ASTNumber aSTNumber = ASTNumber.createNumber(Integer.parseInt(element.getText().trim()));
            this.curr.addChildNode(aSTNumber);
        } else if (element.getAttribute("type") != null && element.getAttribute("type").getValue().equals("rational")) {
            if (element.getContent().size() == 3) {
                int n = Integer.parseInt(((Text)element.getContent().get(0)).getText());
                int n2 = Integer.parseInt(((Text)element.getContent().get(2)).getText());
                RationalNumber rationalNumber = ASTNumber.createNumber(n, n2);
                this.curr.addChildNode(rationalNumber);
            }
        } else if (element.getAttribute("type") != null && element.getAttribute("type").getValue().equals("e-notation")) {
            if (element.getContent().size() == 3) {
                double d = Double.parseDouble(((Text)element.getContent().get(0)).getText());
                double d2 = Double.parseDouble(((Text)element.getContent().get(2)).getText());
                ENotationNumber eNotationNumber = ASTNumber.createNumber(d, d2);
                this.curr.addChildNode(eNotationNumber);
            }
        } else {
            ASTNumber aSTNumber = null;
            aSTNumber = element.getText().trim().equalsIgnoreCase("pi") ? ASTNumber.createNumber(Math.PI) : (element.getText().trim().equalsIgnoreCase("exponentiale") ? ASTNumber.createNumber(Math.E) : (element.getText().trim().equalsIgnoreCase("notanumber") ? ASTNumber.createNumber(Double.NaN) : (element.getText().trim().equalsIgnoreCase("infinity") ? ASTNumber.createNumber(Double.POSITIVE_INFINITY) : ASTNumber.createNumber(Double.parseDouble(element.getText())))));
            this.curr.addChildNode(aSTNumber);
        }
    }
}

