/*
 * Decompiled with CFR 0.152.
 */
package org.jmathml;

import org.jmathml.ASTNode;
import org.jmathml.ASTOperator;
import org.jmathml.ASTSymbol;
import org.jmathml.ASTTypeI;

public class FormulaFormatter {
    public String formulaToString(ASTNode aSTNode) {
        StringBuffer stringBuffer = new StringBuffer();
        if (aSTNode == null) {
            throw new IllegalArgumentException();
        }
        this.FormulaFormatter_visit(null, aSTNode, stringBuffer);
        return stringBuffer.toString();
    }

    boolean FormulaFormatter_isFunction(ASTNode aSTNode) {
        return aSTNode.isFunction() || aSTNode.isLogical() || aSTNode.isSymbol() && ((ASTSymbol)aSTNode).isSymbolFunction();
    }

    boolean FormulaFormatter_isGrouped(ASTNode aSTNode, ASTNode aSTNode2) {
        boolean bl = false;
        if (aSTNode != null && !this.FormulaFormatter_isFunction(aSTNode)) {
            int n;
            int n2 = aSTNode.getPrecedence();
            if (n2 > (n = aSTNode2.getPrecedence())) {
                bl = true;
            } else if (n2 == n && aSTNode.getRightChild().equals(aSTNode2)) {
                ASTTypeI aSTTypeI;
                ASTTypeI aSTTypeI2 = aSTNode.getType();
                bl = aSTTypeI2 != (aSTTypeI = aSTNode2.getType()) || aSTTypeI2 == ASTNode.ASTType.MINUS || aSTTypeI2 == ASTNode.ASTType.DIVIDE;
            }
        }
        return bl;
    }

    void FormulaFormatter_format(StringBuffer stringBuffer, ASTNode aSTNode) {
        if (aSTNode.isOperator()) {
            this.FormulaFormatter_formatOperator(stringBuffer, aSTNode);
        } else if (aSTNode.isRelational()) {
            this.FormulaFormatter_formatRelation(stringBuffer, aSTNode);
        } else if (aSTNode.isFunction()) {
            this.FormulaFormatter_formatFunction(stringBuffer, aSTNode);
        } else if (aSTNode.isNumber()) {
            stringBuffer.append(aSTNode.getString());
        } else if (aSTNode.isNumber() && aSTNode.getAsASTNumber().isInfinity()) {
            stringBuffer.append("infinity");
        } else {
            stringBuffer.append(aSTNode.getString());
        }
    }

    private void FormulaFormatter_formatRelation(StringBuffer stringBuffer, ASTNode aSTNode) {
        if (!aSTNode.isRelational()) {
            throw new IllegalArgumentException();
        }
        stringBuffer.append(" ");
        stringBuffer.append(aSTNode.getString());
        stringBuffer.append(" ");
    }

    void FormulaFormatter_formatFunction(StringBuffer stringBuffer, ASTNode aSTNode) {
        if (!aSTNode.isFunction()) {
            throw new IllegalArgumentException();
        }
        stringBuffer.append(aSTNode.getString());
    }

    void FormulaFormatter_formatOperator(StringBuffer stringBuffer, ASTNode aSTNode) {
        if (!aSTNode.isOperator()) {
            throw new IllegalArgumentException();
        }
        ASTOperator aSTOperator = aSTNode.getNodeAsOperator();
        if (!aSTOperator.isPower()) {
            stringBuffer.append(" ");
        }
        stringBuffer.append(aSTNode.getString());
        if (!aSTOperator.isPower()) {
            stringBuffer.append(" ");
        }
    }

    void FormulaFormatter_visit(ASTNode aSTNode, ASTNode aSTNode2, StringBuffer stringBuffer) {
        if (this.FormulaFormatter_isFunction(aSTNode2)) {
            this.FormulaFormatter_visitFunction(aSTNode, aSTNode2, stringBuffer);
        } else if (this.FormulaFormatter_isFunction(aSTNode2)) {
            this.FormulaFormatter_visitFunction(aSTNode, aSTNode2, stringBuffer);
        } else if (aSTNode2.getType().equals(ASTNode.ASTType.UMINUS)) {
            this.FormulaFormatter_visitUMinus(aSTNode, aSTNode2, stringBuffer);
        } else {
            this.FormulaFormatter_visitOther(aSTNode, aSTNode2, stringBuffer);
        }
    }

    void FormulaFormatter_visitFunction(ASTNode aSTNode, ASTNode aSTNode2, StringBuffer stringBuffer) {
        int n = aSTNode2.getNumChildren();
        this.FormulaFormatter_format(stringBuffer, aSTNode2);
        stringBuffer.append("(");
        if (n > 0) {
            this.FormulaFormatter_visit(aSTNode2, aSTNode2.firstChild(), stringBuffer);
        }
        for (int i = 1; i < n; ++i) {
            stringBuffer.append(", ");
            this.FormulaFormatter_visit(aSTNode2, aSTNode2.getChildAtIndex(i), stringBuffer);
        }
        stringBuffer.append(")");
    }

    void FormulaFormatter_visitLog10(ASTNode aSTNode, ASTNode aSTNode2, StringBuffer stringBuffer) {
        stringBuffer.append("log10(");
        if (aSTNode2.getNumChildren() == 1) {
            this.FormulaFormatter_visit(aSTNode2, aSTNode2.firstChild(), stringBuffer);
        } else {
            this.FormulaFormatter_visit(aSTNode2, aSTNode2.getChildAtIndex(1), stringBuffer);
        }
        stringBuffer.append(")");
    }

    void FormulaFormatter_visitSqrt(ASTNode aSTNode, ASTNode aSTNode2, StringBuffer stringBuffer) {
        stringBuffer.append("root(");
        this.FormulaFormatter_visit(aSTNode2, aSTNode2.getChildAtIndex(0), stringBuffer);
        stringBuffer.append(")");
    }

    void FormulaFormatter_visitUMinus(ASTNode aSTNode, ASTNode aSTNode2, StringBuffer stringBuffer) {
        stringBuffer.append("-");
        this.FormulaFormatter_visit(aSTNode2, aSTNode2.firstChild(), stringBuffer);
    }

    void FormulaFormatter_visitOther(ASTNode aSTNode, ASTNode aSTNode2, StringBuffer stringBuffer) {
        int n = aSTNode2.getNumChildren();
        boolean bl = this.FormulaFormatter_isGrouped(aSTNode, aSTNode2);
        if (bl) {
            stringBuffer.append("(");
        }
        if (n > 0) {
            this.FormulaFormatter_visit(aSTNode2, aSTNode2.firstChild(), stringBuffer);
        }
        this.FormulaFormatter_format(stringBuffer, aSTNode2);
        if (n > 1) {
            for (int i = 1; i < n; ++i) {
                this.FormulaFormatter_visit(aSTNode2, aSTNode2.getChildAtIndex(i), stringBuffer);
                if (!aSTNode2.isOperator() || i >= n - 1) continue;
                stringBuffer.append(" " + aSTNode2.getString() + " ");
            }
        }
        if (bl) {
            stringBuffer.append(")");
        }
    }
}

