/*
 * Decompiled with CFR 0.152.
 */
package org.jmathml;

import java.util.ArrayList;
import java.util.List;
import org.jmathml.ASTNode;
import org.jmathml.FormulaFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BooleanToString {
    BooleanToString() {
    }

    public String getString(ASTNode aSTNode) {
        if (aSTNode == null || !aSTNode.isLogical() && !aSTNode.isRelational()) {
            throw new IllegalArgumentException();
        }
        if (aSTNode.getNumChildren() == 0) {
            return "";
        }
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        this.populateBottomLogicalNodes(aSTNode, arrayList);
        this.popList(arrayList);
        String string = (String)aSTNode.getUserData();
        return string;
    }

    private void populateBottomLogicalNodes(ASTNode aSTNode, List<ASTNode> list) {
        boolean bl = false;
        for (ASTNode aSTNode2 : aSTNode.getChildren()) {
            if (!aSTNode2.isLogical()) continue;
            bl = true;
            this.populateBottomLogicalNodes(aSTNode2, list);
        }
        if (!bl) {
            list.add(aSTNode);
        }
    }

    private void popList(List<ASTNode> list) {
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        for (ASTNode aSTNode : list) {
            StringBuffer stringBuffer = new StringBuffer();
            if (aSTNode.isRelational()) {
                this.createInequality(stringBuffer, aSTNode);
                aSTNode.setUserData(stringBuffer.toString());
            } else {
                stringBuffer.append("(");
                for (ASTNode aSTNode2 : aSTNode.getChildren()) {
                    if (aSTNode2.getUserData() != null) {
                        stringBuffer.append(aSTNode2.getUserData());
                        if (aSTNode2 == aSTNode.getRightChild()) continue;
                        stringBuffer.append(" " + aSTNode.getString() + " ");
                        continue;
                    }
                    this.createInequality(stringBuffer, aSTNode2);
                    if (aSTNode2 == aSTNode.getRightChild()) continue;
                    stringBuffer.append(" " + aSTNode.getString() + " ");
                }
                stringBuffer.append(")");
            }
            aSTNode.setUserData(stringBuffer.toString());
            if (aSTNode.getParentNode() == null || arrayList.contains(aSTNode.getParentNode())) continue;
            arrayList.add(aSTNode.getParentNode());
        }
        if (!arrayList.isEmpty()) {
            this.popList(arrayList);
        }
    }

    private void createInequality(StringBuffer stringBuffer, ASTNode aSTNode) {
        for (ASTNode aSTNode2 : aSTNode.getChildren()) {
            stringBuffer.append(new FormulaFormatter().formulaToString(aSTNode2));
            if (aSTNode2 == aSTNode.getRightChild()) continue;
            stringBuffer.append(" " + aSTNode.getString() + " ");
        }
    }
}

