/*
 * Decompiled with CFR 0.152.
 */
package org.jmathml;

import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jmathml.ASTCi;
import org.jmathml.ASTFunction;
import org.jmathml.ASTLogical;
import org.jmathml.ASTNumber;
import org.jmathml.ASTOperator;
import org.jmathml.ASTOtherwise;
import org.jmathml.ASTPiece;
import org.jmathml.ASTPiecewise;
import org.jmathml.ASTRelational;
import org.jmathml.ASTRootNode;
import org.jmathml.ASTSymbol;
import org.jmathml.ASTVisitor;

public class ASTToXMLElementVisitor
extends ASTVisitor {
    private Element xml;
    private Element currEl;
    static Namespace MATHML_NS = Namespace.getNamespace((String)"math", (String)"http://www.w3.org/1998/Math/MathML");

    public ASTToXMLElementVisitor() {
        this.currEl = this.xml = new Element("math");
    }

    public Element getElement() {
        return this.xml;
    }

    public boolean visit(ASTOperator aSTOperator) {
        Element element = new Element("apply");
        element.setNamespace(MATHML_NS);
        Element element2 = new Element(aSTOperator.getName());
        element2.setNamespace(MATHML_NS);
        element.addContent((Content)element2);
        this.currEl.addContent((Content)element);
        this.currEl = element;
        return true;
    }

    public boolean endVisit(ASTOperator aSTOperator) {
        this.currEl = (Element)this.currEl.getParent();
        return true;
    }

    public boolean visit(ASTRootNode aSTRootNode) {
        this.xml.setNamespace(MATHML_NS);
        return true;
    }

    public boolean endVisit(ASTRootNode aSTRootNode) {
        return true;
    }

    public boolean visit(ASTNumber aSTNumber) {
        if (this.parentIsLogToOtherBase(aSTNumber) || this.parentIsRootToOtherDegree(aSTNumber)) {
            return true;
        }
        Element element = new Element("cn");
        if (aSTNumber.isInteger()) {
            element.setAttribute("type", "integer");
            element.setText(aSTNumber.getName());
        } else if (aSTNumber.isRational()) {
            element.setAttribute("type", "rational");
            element.setText(Integer.toString(aSTNumber.getNumerator()));
            Element element2 = new Element("sep");
            element.addContent((Content)element2);
            element.addContent(Integer.toString(aSTNumber.getDenominator()));
        } else if (aSTNumber.isENotation()) {
            element.setAttribute("type", "e-notation");
            element.setText(Double.toString(aSTNumber.getMantissa()));
            Element element3 = new Element("sep");
            element.addContent((Content)element3);
            element.addContent(Double.toString(aSTNumber.getExponent()));
        } else if (aSTNumber.isE()) {
            element = new Element("exponentiale");
        } else if (aSTNumber.isPI()) {
            element = new Element("pi");
        } else if (aSTNumber.isTruth()) {
            element = new Element("true");
        } else if (aSTNumber.isFalse()) {
            element = new Element("false");
        } else if (aSTNumber.isNaN()) {
            element = new Element("notanumber");
        } else if (aSTNumber.isInfinity()) {
            element = new Element("infinity");
        } else {
            element.setAttribute("type", "real");
            element.setText(aSTNumber.getName());
        }
        element.setNamespace(MATHML_NS);
        this.currEl.addContent((Content)element);
        return true;
    }

    private boolean parentIsRootToOtherDegree(ASTNumber aSTNumber) {
        return aSTNumber.getParentNode() != null && aSTNumber.getParentNode().getType().equals(ASTFunction.ASTFunctionType.ROOT) && !aSTNumber.getParentNode().isSqrt() && aSTNumber.getIndex() == 0;
    }

    private boolean parentIsLogToOtherBase(ASTNumber aSTNumber) {
        return aSTNumber.getParentNode() != null && aSTNumber.getParentNode().getType().equals(ASTFunction.ASTFunctionType.LOG) && !aSTNumber.getParentNode().isLog10() && aSTNumber.getIndex() == 0;
    }

    public boolean endVisit(ASTNumber aSTNumber) {
        this.currEl = (Element)this.currEl.getParent();
        return true;
    }

    public boolean visit(ASTFunction aSTFunction) {
        Element element = new Element("apply");
        element.setNamespace(MATHML_NS);
        Element element2 = new Element(aSTFunction.getName());
        element2.setNamespace(MATHML_NS);
        element.addContent((Content)element2);
        if (aSTFunction.getType().equals(ASTFunction.ASTFunctionType.LOG)) {
            this.createXMLForLogbase(aSTFunction, element);
        } else if (aSTFunction.getType().equals(ASTFunction.ASTFunctionType.ROOT)) {
            this.createXMLForRootDegree(aSTFunction, element);
        }
        this.currEl.addContent((Content)element);
        this.currEl = element;
        return true;
    }

    private void createXMLForRootDegree(ASTFunction aSTFunction, Element element) {
        ASTFunction.ASTRoot aSTRoot = (ASTFunction.ASTRoot)aSTFunction;
        if (!aSTRoot.isSqrt()) {
            Element element2 = new Element("degree");
            element2.setNamespace(MATHML_NS);
            Element element3 = new Element("cn");
            element3.setNamespace(MATHML_NS);
            element3.setText(aSTFunction.firstChild().getString());
            element2.addContent((Content)element3);
            element.addContent((Content)element2);
        }
    }

    private void createXMLForLogbase(ASTFunction aSTFunction, Element element) {
        ASTFunction.ASTLog aSTLog = (ASTFunction.ASTLog)aSTFunction;
        if (!aSTLog.isLog10()) {
            Element element2 = new Element("logbase");
            element2.setNamespace(MATHML_NS);
            Element element3 = new Element("cn");
            element3.setNamespace(MATHML_NS);
            element3.setText(aSTFunction.firstChild().getString());
            element2.addContent((Content)element3);
            element.addContent((Content)element2);
        }
    }

    public boolean endVisit(ASTFunction aSTFunction) {
        this.currEl = (Element)this.currEl.getParent();
        return true;
    }

    public void clear() {
        this.currEl = this.xml = new Element("math");
    }

    public boolean visit(ASTCi aSTCi) {
        Element element = new Element("ci");
        element.setNamespace(MATHML_NS);
        element.setText(aSTCi.getString());
        this.currEl.addContent((Content)element);
        return true;
    }

    public boolean endVisit(ASTCi aSTCi) {
        this.currEl = (Element)this.currEl.getParent();
        return true;
    }

    public boolean visit(ASTRelational aSTRelational) {
        Element element = new Element("apply");
        element.setNamespace(MATHML_NS);
        Element element2 = new Element(aSTRelational.getName());
        element2.setNamespace(MATHML_NS);
        element.addContent((Content)element2);
        this.currEl.addContent((Content)element);
        this.currEl = element;
        return true;
    }

    public boolean endVisit(ASTRelational aSTRelational) {
        this.currEl = (Element)this.currEl.getParent();
        return true;
    }

    public boolean visit(ASTLogical aSTLogical) {
        Element element = new Element("apply");
        element.setNamespace(MATHML_NS);
        Element element2 = new Element(aSTLogical.getName());
        element2.setNamespace(MATHML_NS);
        element.addContent((Content)element2);
        this.currEl.addContent((Content)element);
        this.currEl = element;
        return true;
    }

    public boolean endVisit(ASTLogical aSTLogical) {
        this.currEl = (Element)this.currEl.getParent();
        return true;
    }

    public boolean visit(ASTSymbol aSTSymbol) {
        if (aSTSymbol.isSymbolFunction()) {
            Element element = new Element("apply");
            element.setNamespace(MATHML_NS);
            Element element2 = this.createCsymbolXML(aSTSymbol);
            element.addContent((Content)element2);
            this.currEl.addContent((Content)element);
            this.currEl = element;
            return true;
        }
        Element element = this.createCsymbolXML(aSTSymbol);
        this.currEl.addContent((Content)element);
        return true;
    }

    Element createCsymbolXML(ASTSymbol aSTSymbol) {
        Element element = new Element("csymbol");
        element.setNamespace(MATHML_NS);
        if (aSTSymbol.getDefinitionURL() != null) {
            element.setAttribute("definitionURL", aSTSymbol.getDefinitionURL());
        }
        if (aSTSymbol.getEncoding() != null) {
            element.setAttribute("encoding", aSTSymbol.getEncoding());
        }
        element.setText(aSTSymbol.getName());
        return element;
    }

    public boolean endVisit(ASTSymbol aSTSymbol) {
        this.currEl = (Element)this.currEl.getParent();
        return true;
    }

    public boolean visit(ASTOtherwise aSTOtherwise) {
        Element element = new Element("otherwise");
        element.setNamespace(MATHML_NS);
        this.currEl.addContent((Content)element);
        this.currEl = element;
        return true;
    }

    public boolean endVisit(ASTOtherwise aSTOtherwise) {
        this.currEl = (Element)this.currEl.getParent();
        return true;
    }

    public boolean visit(ASTPiecewise aSTPiecewise) {
        Element element = new Element("piecewise");
        element.setNamespace(MATHML_NS);
        this.currEl.addContent((Content)element);
        this.currEl = element;
        return true;
    }

    public boolean endVisit(ASTPiecewise aSTPiecewise) {
        this.currEl = (Element)this.currEl.getParent();
        return true;
    }

    public boolean visit(ASTPiece aSTPiece) {
        Element element = new Element("piece");
        element.setNamespace(MATHML_NS);
        this.currEl.addContent((Content)element);
        this.currEl = element;
        return true;
    }

    public boolean endVisit(ASTPiece aSTPiece) {
        this.currEl = (Element)this.currEl.getParent();
        return true;
    }
}

