/*
 * Decompiled with CFR 0.152.
 */
package org.jmathml;

import org.jmathml.ASTNode;
import org.jmathml.ASTNumber;
import org.jmathml.ASTTypeI;
import org.jmathml.ASTVisitor;
import org.jmathml.IEvaluationContext;

public class ASTSymbol
extends ASTNode {
    private String encoding;
    private String definitionURL;
    private String id;
    private boolean isSymbolFunction = true;

    ASTSymbol(ASTTypeI aSTTypeI) {
        super(AST_SYMBOL_TYPE.AST_SYMBOL);
    }

    public ASTSymbol(String string) {
        super(AST_SYMBOL_TYPE.AST_SYMBOL);
        this.id = string;
        this.setName(string);
    }

    public ASTSymbol(String string, boolean bl) {
        super(AST_SYMBOL_TYPE.AST_SYMBOL);
        this.id = string;
        this.isSymbolFunction = !bl;
        this.setName(string);
    }

    boolean doAccept(ASTVisitor aSTVisitor) {
        block1: {
            if (!aSTVisitor.visit(this)) break block1;
            for (ASTNode aSTNode : this.getChildren()) {
                if (!aSTNode.accept(aSTVisitor)) break;
            }
        }
        return aSTVisitor.endVisit(this);
    }

    public final String getEncoding() {
        return this.encoding;
    }

    public final void setEncoding(String string) {
        this.encoding = string;
    }

    public final String getDefinitionURL() {
        return this.definitionURL;
    }

    public final void setDefinitionURL(String string) {
        this.definitionURL = string;
    }

    public String getString() {
        return this.getName();
    }

    public boolean hasCorrectNumberChildren() {
        return this.getNumChildren() == 0;
    }

    protected ASTNumber doEvaluate(IEvaluationContext iEvaluationContext) {
        return ASTNumber.createNumber(iEvaluationContext.getValueFor(this.id).iterator().next());
    }

    public final boolean isSymbol() {
        return true;
    }

    public final boolean isSymbolFunction() {
        return this.isSymbolFunction;
    }

    public final boolean isSymbolValue() {
        return !this.isSymbolFunction;
    }

    public boolean isVectorOperation() {
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AST_SYMBOL_TYPE implements ASTTypeI
    {
        AST_SYMBOL;


        @Override
        public String getString() {
            return null;
        }
    }
}

