/*
 * Decompiled with CFR 0.152.
 */
package org.jmathml;

import org.jmathml.ASTNode;
import org.jmathml.ASTNumber;
import org.jmathml.ASTTypeI;
import org.jmathml.ASTVisitor;
import org.jmathml.IEvaluationContext;

public class ASTRelational
extends ASTNode {
    public static final double TOLERANCE = 1.0E-4;
    Tester GET = new Tester(){

        public boolean test(ASTNode aSTNode, ASTNode aSTNode2, IEvaluationContext iEvaluationContext) {
            return aSTNode.evaluate(iEvaluationContext).getValue() >= aSTNode2.evaluate(iEvaluationContext).getValue();
        }
    };
    Tester GT = new Tester(){

        public boolean test(ASTNode aSTNode, ASTNode aSTNode2, IEvaluationContext iEvaluationContext) {
            return aSTNode.evaluate(iEvaluationContext).getValue() > aSTNode2.evaluate(iEvaluationContext).getValue();
        }
    };
    Tester EQ = new Tester(){

        public boolean test(ASTNode aSTNode, ASTNode aSTNode2, IEvaluationContext iEvaluationContext) {
            return Math.abs(aSTNode.evaluate(iEvaluationContext).getValue() - aSTNode2.evaluate(iEvaluationContext).getValue()) < 1.0E-4;
        }
    };
    Tester LEQ = new Tester(){

        public boolean test(ASTNode aSTNode, ASTNode aSTNode2, IEvaluationContext iEvaluationContext) {
            return aSTNode.evaluate(iEvaluationContext).getValue() <= aSTNode2.evaluate(iEvaluationContext).getValue();
        }
    };
    Tester LT = new Tester(){

        public boolean test(ASTNode aSTNode, ASTNode aSTNode2, IEvaluationContext iEvaluationContext) {
            return aSTNode.evaluate(iEvaluationContext).getValue() < aSTNode2.evaluate(iEvaluationContext).getValue();
        }
    };
    Tester NE = new Tester(){

        public boolean test(ASTNode aSTNode, ASTNode aSTNode2, IEvaluationContext iEvaluationContext) {
            return Math.abs(aSTNode.evaluate(iEvaluationContext).getValue() - aSTNode2.evaluate(iEvaluationContext).getValue()) > 1.0E-4;
        }
    };

    public ASTRelational(ASTRelationalType aSTRelationalType) {
        super(aSTRelationalType);
        this.setName(this.getType().toString().toLowerCase());
    }

    boolean doAccept(ASTVisitor aSTVisitor) {
        block1: {
            if (!aSTVisitor.visit(this)) break block1;
            for (ASTNode aSTNode : this.getChildren()) {
                if (!aSTNode.accept(aSTVisitor)) break;
            }
        }
        return aSTVisitor.endVisit(this);
    }

    ASTNumber doEvaluate(IEvaluationContext iEvaluationContext) {
        if (this.getType().equals(ASTRelationalType.EQ)) {
            return this.test(iEvaluationContext, this.EQ);
        }
        if (this.getType().equals(ASTRelationalType.GEQ)) {
            return this.test(iEvaluationContext, this.GET);
        }
        if (this.getType().equals(ASTRelationalType.GT)) {
            return this.test(iEvaluationContext, this.GT);
        }
        if (this.getType().equals(ASTRelationalType.LT)) {
            return this.test(iEvaluationContext, this.LT);
        }
        if (this.getType().equals(ASTRelationalType.LEQ)) {
            return this.test(iEvaluationContext, this.LEQ);
        }
        if (this.getType().equals(ASTRelationalType.NEQ)) {
            return this.test(iEvaluationContext, this.NE);
        }
        return ASTNumber.FALSE();
    }

    private ASTNumber test(IEvaluationContext iEvaluationContext, Tester tester) {
        ASTNode aSTNode = this.firstChild();
        if (this.getNumChildren() == 1) {
            return this.getType().equals(ASTRelationalType.EQ) ? ASTNumber.TRUE() : ASTNumber.FALSE();
        }
        for (int i = 1; i < this.getNumChildren(); ++i) {
            if (!tester.test(aSTNode, this.getChildAtIndex(i), iEvaluationContext)) {
                return ASTNumber.FALSE();
            }
            aSTNode = this.getChildAtIndex(i);
        }
        return ASTNumber.TRUE();
    }

    public String getString() {
        return this.getType().getString();
    }

    public boolean hasCorrectNumberChildren() {
        return this.getNumChildren() >= 2;
    }

    public boolean isRelational() {
        return true;
    }

    static interface Tester {
        public boolean test(ASTNode var1, ASTNode var2, IEvaluationContext var3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ASTRelationalType implements ASTTypeI
    {
        EQ(1),
        NEQ(2),
        GT(3),
        GEQ(4),
        LT(5),
        LEQ(6);

        private int code;

        private ASTRelationalType(int n2) {
            this.code = n2;
        }

        @Override
        public String getString() {
            switch (this.code) {
                case 1: {
                    return "==";
                }
                case 2: {
                    return "!=";
                }
                case 3: {
                    return ">";
                }
                case 4: {
                    return ">=";
                }
                case 5: {
                    return "<";
                }
                case 6: {
                    return "<=";
                }
            }
            return "";
        }
    }
}

