/*
 * Decompiled with CFR 0.152.
 */
package org.jmathml;

import org.jmathml.ASTNode;
import org.jmathml.ASTNumber;
import org.jmathml.ASTOperator;
import org.jmathml.IEvaluationContext;

public class ASTPlus
extends ASTOperator {
    static final String PLUS_NAME = "plus";

    public ASTPlus() {
        super(ASTNode.ASTType.PLUS);
        this.setName(PLUS_NAME);
    }

    public String getString() {
        return "+";
    }

    ASTNumber doEvaluate(IEvaluationContext iEvaluationContext) {
        double d = 0.0;
        for (ASTNode aSTNode : this.getChildren()) {
            d += aSTNode.evaluate(iEvaluationContext).getValue();
        }
        return ASTNumber.createNumber(d);
    }

    public boolean hasCorrectNumberChildren() {
        return this.getNumChildren() >= 1;
    }

    public int getPrecedence() {
        return 2;
    }
}

