/*
 * Decompiled with CFR 0.152.
 */
package org.jmathml;

import java.util.HashMap;
import java.util.Map;
import org.jmathml.ASTNode;
import org.jmathml.ASTTypeI;
import org.jmathml.ASTVisitor;
import org.jmathml.ENotationNumber;
import org.jmathml.IEvaluationContext;
import org.jmathml.RationalNumber;
import org.jmathml.RealNumber;

public abstract class ASTNumber
extends ASTNode {
    static Map<String, ASTNumberType> ENUMNAME_2_ENUM = new HashMap<String, ASTNumberType>();
    public static final ASTNumber AST_NULL_NUMBER;

    public static ASTNumber getConstant(String string) {
        if (string.equalsIgnoreCase("exponentiale")) {
            return ASTNumber.E();
        }
        if (string.equalsIgnoreCase("pi")) {
            return ASTNumber.PI();
        }
        if (string.equalsIgnoreCase("nan")) {
            return ASTNumber.NaN();
        }
        if (string.equalsIgnoreCase("infinity")) {
            return ASTNumber.INFINITY();
        }
        return null;
    }

    public static boolean isConstant(String string) {
        return ASTNumber.getConstant(string) != null;
    }

    public static ASTNumberType getFunctionTypeForName(String string) {
        return ENUMNAME_2_ENUM.get(string);
    }

    public static final ASTNumber TRUE() {
        RealNumber realNumber = new RealNumber(1.0);
        realNumber.setType(ASTNumberType.TRUE);
        return realNumber;
    }

    public static final ASTNumber FALSE() {
        RealNumber realNumber = new RealNumber(0.0);
        realNumber.setType(ASTNumberType.FALSE);
        return realNumber;
    }

    public static final ASTNumber E() {
        RealNumber realNumber = new RealNumber(Math.E);
        realNumber.setType(ASTNumberType.E);
        return realNumber;
    }

    public static final ASTNumber PI() {
        RealNumber realNumber = new RealNumber(Math.PI);
        realNumber.setType(ASTNumberType.PI);
        return realNumber;
    }

    public static final ASTNumber NaN() {
        RealNumber realNumber = new RealNumber(Double.NaN);
        realNumber.setType(ASTNumberType.NaN);
        return realNumber;
    }

    public static final ASTNumber INFINITY() {
        RealNumber realNumber = new RealNumber(Double.POSITIVE_INFINITY);
        realNumber.setType(ASTNumberType.INFINITY);
        return realNumber;
    }

    public static ASTNumber createNumber(double d) {
        return new RealNumber(d);
    }

    public static ASTNumber createNumber(int n) {
        return new RealNumber(n);
    }

    public static ASTNumber createNumber(long l) {
        return new RealNumber(l);
    }

    public static ENotationNumber createNumber(double d, double d2) {
        return new ENotationNumber(d, d2);
    }

    public static RationalNumber createNumber(int n, int n2) {
        if (n2 == 0) {
            throw new IllegalArgumentException("denominator is zero");
        }
        return new RationalNumber(n, n2);
    }

    public abstract double getValue();

    boolean doAccept(ASTVisitor aSTVisitor) {
        return aSTVisitor.visit(this);
    }

    ASTNumber(ASTNumberType aSTNumberType) {
        super(aSTNumberType);
    }

    ASTNumber doEvaluate(IEvaluationContext iEvaluationContext) {
        return this;
    }

    public boolean hasCorrectNumberChildren() {
        return this.getNumChildren() == 0;
    }

    public boolean isNumber() {
        return true;
    }

    public boolean isRational() {
        return false;
    }

    public boolean isInteger() {
        return false;
    }

    public int getNumerator() {
        throw new UnsupportedOperationException();
    }

    public int getDenominator() {
        throw new UnsupportedOperationException();
    }

    public double getExponent() {
        throw new UnsupportedOperationException();
    }

    public double getMantissa() {
        throw new UnsupportedOperationException();
    }

    public boolean isENotation() {
        return false;
    }

    public boolean isTruth() {
        return this.getType().equals(ASTNumberType.TRUE);
    }

    public boolean isFalse() {
        return this.getType().equals(ASTNumberType.FALSE);
    }

    public boolean isNaN() {
        return this.getType().equals(ASTNumberType.NaN);
    }

    public boolean isPI() {
        return this.getType().equals(ASTNumberType.PI);
    }

    public boolean isInfinity() {
        return this.getType().equals(ASTNumberType.INFINITY);
    }

    public boolean isE() {
        return this.getType().equals(ASTNumberType.E);
    }

    static {
        for (ASTNumberType aSTNumberType : ASTNumberType.values()) {
            ENUMNAME_2_ENUM.put(aSTNumberType.name().toLowerCase(), aSTNumberType);
        }
        AST_NULL_NUMBER = new RealNumber(Double.NaN);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ASTNumberType implements ASTTypeI
    {
        PI(1),
        E(2),
        NaN(3),
        INFINITY(4),
        TRUE(5),
        FALSE(6),
        NUMBER(7);

        private int code;

        private ASTNumberType(int n2) {
            this.code = n2;
        }

        @Override
        public String getString() {
            switch (this.code) {
                case 1: {
                    return "pi";
                }
                case 2: {
                    return "exponentiale";
                }
                case 3: {
                    return "notanumber";
                }
                case 4: {
                    return "infinity";
                }
                case 5: {
                    return "true";
                }
                case 6: {
                    return "false";
                }
            }
            return "";
        }
    }
}

