/*
 * Decompiled with CFR 0.152.
 */
package org.jmathml;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jmathml.ASTCi;
import org.jmathml.ASTFunction;
import org.jmathml.ASTNumber;
import org.jmathml.ASTOperator;
import org.jmathml.ASTTypeI;
import org.jmathml.ASTVisitor;
import org.jmathml.IEvaluationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ASTNode {
    private List<ASTNode> children = new ArrayList<ASTNode>();
    private ASTNode parentNode;
    private boolean isOperator = false;
    private int level;
    private ASTTypeI type;
    private String name;
    private Object userData;

    public Object getUserData() {
        return this.userData;
    }

    public void setUserData(Object object) {
        this.userData = object;
    }

    void setType(ASTTypeI aSTTypeI) {
        this.type = aSTTypeI;
    }

    ASTNode(ASTTypeI aSTTypeI) {
        this.type = aSTTypeI;
    }

    public ASTTypeI getType() {
        return this.type;
    }

    public final int getLevel() {
        return this.level;
    }

    void setLevel(int n) {
        this.level = n;
    }

    public final String getName() {
        return this.name;
    }

    void setName(String string) {
        assert (string != null);
        this.name = string;
    }

    public final Set<ASTCi> getIdentifiers() {
        HashSet<ASTCi> hashSet = new HashSet<ASTCi>();
        if (this.isVariable()) {
            hashSet.add((ASTCi)this);
        }
        for (ASTNode aSTNode : this.getChildren()) {
            this.getIdentifiers(hashSet, aSTNode, false);
        }
        return hashSet;
    }

    public final Set<ASTCi> getUniqueIdentifiers() {
        HashSet<ASTCi> hashSet = new HashSet<ASTCi>();
        if (this.isVariable()) {
            hashSet.add((ASTCi)this);
        }
        for (ASTNode aSTNode : this.getChildren()) {
            this.getIdentifiers(hashSet, aSTNode, true);
        }
        return hashSet;
    }

    private void getIdentifiers(Set<ASTCi> set, ASTNode aSTNode, boolean bl) {
        if (aSTNode.isVariable()) {
            if (bl) {
                boolean bl2 = false;
                for (ASTCi aSTCi : set) {
                    if (!aSTNode.getName().equals(aSTCi.getName())) continue;
                    bl2 = true;
                    break;
                }
                if (!bl2) {
                    set.add((ASTCi)aSTNode);
                }
            } else {
                set.add((ASTCi)aSTNode);
            }
        }
        for (ASTNode aSTNode2 : aSTNode.getChildren()) {
            this.getIdentifiers(set, aSTNode2, bl);
        }
    }

    public final boolean addChildNode(ASTNode aSTNode) {
        this.assertNotNull(aSTNode);
        boolean bl = this.children.add(aSTNode);
        if (bl) {
            aSTNode.setParent(this);
            aSTNode.setLevel(this.getLevel() + 1);
        }
        return bl;
    }

    public final void addChildNodeAt(int n, ASTNode aSTNode) {
        this.assertNotNull(aSTNode);
        this.children.add(n, aSTNode);
        aSTNode.setParent(this);
        aSTNode.setLevel(this.getLevel() + 1);
    }

    public final boolean removeChildNode(ASTNode aSTNode) {
        this.assertNotNull(aSTNode);
        boolean bl = this.children.remove(aSTNode);
        if (bl) {
            aSTNode.setParent(null);
            aSTNode.setLevel(0);
        }
        return bl;
    }

    public final ASTNode getParentNode() {
        return this.parentNode;
    }

    void setParent(ASTNode aSTNode) {
        this.parentNode = aSTNode;
    }

    public final boolean isOperator() {
        return this.isOperator;
    }

    void setOperator(boolean bl) {
        this.isOperator = bl;
    }

    public final List<ASTNode> getChildren() {
        return this.children;
    }

    public final ASTNode firstChild() {
        if (this.children.isEmpty()) {
            throw new IllegalStateException();
        }
        return this.children.get(0);
    }

    public final ASTNode getChildAtIndex(int n) {
        if (this.indexOK(n)) {
            return this.children.get(n);
        }
        throw new IllegalArgumentException("index ouside range");
    }

    public final ASTNode removeChildAtIndex(int n) {
        if (this.indexOK(n)) {
            return this.children.remove(n);
        }
        throw new IllegalArgumentException("index outside range");
    }

    public final boolean replaceChild(ASTNode aSTNode, ASTNode aSTNode2) {
        this.assertNotNull(aSTNode, aSTNode2);
        int n = this.children.indexOf(aSTNode);
        if (n == -1) {
            return false;
        }
        boolean bl = false;
        bl = this.removeChildNode(aSTNode);
        this.addChildNodeAt(n, aSTNode2);
        return bl;
    }

    void assertNotNull(Object ... objectArray) {
        for (Object object : objectArray) {
            if (object != null) continue;
            throw new IllegalArgumentException();
        }
    }

    private boolean indexOK(int n) {
        return this.children.size() > n && n >= 0;
    }

    public final int getIndex() {
        if (this.getParentNode() == null) {
            throw new IllegalStateException("Node has no parent!");
        }
        return this.getParentNode().getChildren().indexOf(this);
    }

    public final boolean isLeaf() {
        return this.children.size() == 0;
    }

    public boolean isLog10() {
        return false;
    }

    public boolean isSqrt() {
        return false;
    }

    public boolean isVariable() {
        return false;
    }

    public boolean isSymbol() {
        return false;
    }

    ASTOperator getNodeAsOperator() {
        if (this.isOperator()) {
            return (ASTOperator)this;
        }
        throw new IllegalStateException();
    }

    public final boolean accept(ASTVisitor aSTVisitor) {
        return this.doAccept(aSTVisitor);
    }

    abstract boolean doAccept(ASTVisitor var1);

    public abstract String getString();

    public final ASTNumber evaluate(IEvaluationContext iEvaluationContext) {
        return this.doEvaluate(iEvaluationContext);
    }

    public final ASTNumber evaluate() {
        return this.doEvaluate(IEvaluationContext.NULL_CONTEXT);
    }

    abstract ASTNumber doEvaluate(IEvaluationContext var1);

    public final boolean canEvaluate(IEvaluationContext iEvaluationContext) {
        if (this.isVariable() && !iEvaluationContext.hasValueFor(this.getName()) || !this.hasCorrectNumberChildren() || this.isFunction() && this.getType().equals(ASTFunction.ASTFunctionType.MISCELLANEOUS) && this.subclassCanEvaluate(iEvaluationContext)) {
            return false;
        }
        return this.canEvaluateChildren(this.getChildren(), iEvaluationContext);
    }

    protected boolean subclassCanEvaluate(IEvaluationContext iEvaluationContext) {
        return true;
    }

    private boolean canEvaluateChildren(List<ASTNode> list, IEvaluationContext iEvaluationContext) {
        for (ASTNode aSTNode : this.getChildren()) {
            if (aSTNode.canEvaluate(iEvaluationContext)) continue;
            return false;
        }
        return true;
    }

    public final int getNumChildren() {
        return this.children.size();
    }

    public final ASTNode getRightChild() {
        if (this.isLeaf()) {
            return null;
        }
        return this.children.get(this.children.size() - 1);
    }

    public abstract boolean hasCorrectNumberChildren();

    public boolean isFunction() {
        return false;
    }

    public boolean isLambda() {
        return false;
    }

    public boolean isLogical() {
        return false;
    }

    public boolean isNumber() {
        return false;
    }

    public boolean isRelational() {
        return false;
    }

    public int getPrecedence() {
        return 6;
    }

    public ASTNumber getAsASTNumber() {
        return (ASTNumber)this;
    }

    public ASTFunction getAsASTFunction() {
        return (ASTFunction)this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ASTType implements ASTTypeI
    {
        PLUS,
        MINUS,
        DIVIDE,
        TIMES,
        UMINUS,
        PIECEWISE,
        PIECE,
        OTHERWISE,
        ROOTNODE;


        @Override
        public String getString() {
            return null;
        }
    }
}

