/*
 * Decompiled with CFR 0.152.
 */
package org.jmathml;

import org.jmathml.ASTNode;
import org.jmathml.ASTNumber;
import org.jmathml.ASTTypeI;
import org.jmathml.ASTVisitor;
import org.jmathml.IEvaluationContext;

public final class ASTLogical
extends ASTNode {
    public ASTLogical(ASTLogicalType aSTLogicalType) {
        super(aSTLogicalType);
        this.setName(this.getType().toString().toLowerCase());
    }

    boolean doAccept(ASTVisitor aSTVisitor) {
        block1: {
            if (!aSTVisitor.visit(this)) break block1;
            for (ASTNode aSTNode : this.getChildren()) {
                if (!aSTNode.accept(aSTVisitor)) break;
            }
        }
        return aSTVisitor.endVisit(this);
    }

    ASTNumber doEvaluate(IEvaluationContext iEvaluationContext) {
        if (this.getType().equals(ASTLogicalType.AND)) {
            for (ASTNode aSTNode : this.getChildren()) {
                if (!aSTNode.evaluate(iEvaluationContext).isFalse()) continue;
                return ASTNumber.FALSE();
            }
            return ASTNumber.TRUE();
        }
        if (this.getType().equals(ASTLogicalType.OR)) {
            for (ASTNode aSTNode : this.getChildren()) {
                if (!aSTNode.evaluate(iEvaluationContext).isTruth()) continue;
                return ASTNumber.TRUE();
            }
            return ASTNumber.FALSE();
        }
        if (this.getType().equals(ASTLogicalType.NOT)) {
            if (this.firstChild().evaluate(iEvaluationContext).isTruth()) {
                return ASTNumber.FALSE();
            }
            return ASTNumber.TRUE();
        }
        if (this.getType().equals(ASTLogicalType.XOR)) {
            int n = 0;
            for (ASTNode aSTNode : this.getChildren()) {
                if (!aSTNode.evaluate(iEvaluationContext).isTruth() || ++n <= 1) continue;
                return ASTNumber.FALSE();
            }
            return n == 1 ? ASTNumber.TRUE() : ASTNumber.FALSE();
        }
        return ASTNumber.TRUE();
    }

    public String getString() {
        return this.getType().getString();
    }

    public boolean hasCorrectNumberChildren() {
        return this.getType().equals(ASTLogicalType.NOT) && this.getNumChildren() == 1 || this.getNumChildren() >= 2;
    }

    public boolean isLogical() {
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ASTLogicalType implements ASTTypeI
    {
        AND(1),
        OR(2),
        NOT(3),
        XOR(4);

        private int code;

        private ASTLogicalType(int n2) {
            this.code = n2;
        }

        @Override
        public String getString() {
            switch (this.code) {
                case 1: {
                    return "&&";
                }
                case 2: {
                    return "||";
                }
                case 3: {
                    return "!";
                }
                case 4: {
                    return "^";
                }
            }
            return "";
        }
    }
}

