/*
 * Decompiled with CFR 0.152.
 */
package org.jmathml;

import java.util.HashMap;
import java.util.Map;
import org.jmathml.ASTNode;
import org.jmathml.ASTNumber;
import org.jmathml.ASTPower;
import org.jmathml.ASTTypeI;
import org.jmathml.ASTVisitor;
import org.jmathml.IEvaluationContext;

public abstract class ASTFunction
extends ASTNode {
    static Map<String, ASTFunctionType> ENUMNAME_2_ENUM = new HashMap<String, ASTFunctionType>();
    public static double ABSTOLERANCE;

    public static ASTFunctionType getFunctionTypeForName(String string) {
        ASTFunctionType aSTFunctionType = ENUMNAME_2_ENUM.get(string);
        if (aSTFunctionType == null) {
            aSTFunctionType = ASTFunctionType.MISCELLANEOUS;
        }
        return aSTFunctionType;
    }

    ASTFunction(ASTFunctionType aSTFunctionType) {
        super(aSTFunctionType);
    }

    public static ASTLog createASTLog(int n) {
        if (n < 1) {
            throw new IllegalArgumentException();
        }
        ASTLog aSTLog = new ASTLog(ASTFunctionType.LOG);
        aSTLog.addChildNode(ASTNumber.createNumber(n));
        return aSTLog;
    }

    public static ASTRoot createASTRoot(int n) {
        if (n < 1) {
            throw new IllegalArgumentException();
        }
        ASTRoot aSTRoot = new ASTRoot(ASTFunctionType.ROOT);
        aSTRoot.addChildNode(ASTNumber.createNumber(n));
        return aSTRoot;
    }

    public static ASTFunction createFunctionNode(ASTFunctionType aSTFunctionType) {
        if (aSTFunctionType == null) {
            throw new IllegalArgumentException();
        }
        if (aSTFunctionType.equals(ASTFunctionType.SIN)) {
            return new ASTSin(aSTFunctionType);
        }
        if (aSTFunctionType.equals(ASTFunctionType.ARCSIN)) {
            return new ASTArcSin(aSTFunctionType);
        }
        if (aSTFunctionType.equals(ASTFunctionType.ARCSIN)) {
            return new ASTArcSin(aSTFunctionType);
        }
        if (aSTFunctionType.equals(ASTFunctionType.SINH)) {
            return new ASTSinh(aSTFunctionType);
        }
        if (aSTFunctionType.equals(ASTFunctionType.ARCCOS)) {
            return new ASTArcSin(aSTFunctionType);
        }
        if (aSTFunctionType.equals(ASTFunctionType.COS)) {
            return new ASTCos(aSTFunctionType);
        }
        if (aSTFunctionType.equals(ASTFunctionType.TAN)) {
            return new ASTTan(aSTFunctionType);
        }
        if (aSTFunctionType.equals(ASTFunctionType.ARCTAN)) {
            return new ASTArcTan(aSTFunctionType);
        }
        if (aSTFunctionType.equals(ASTFunctionType.TANH)) {
            return new ASTTanh(aSTFunctionType);
        }
        if (aSTFunctionType.equals(ASTFunctionType.SEC)) {
            return new ASTSec(aSTFunctionType);
        }
        if (aSTFunctionType.equals(ASTFunctionType.COSEC)) {
            return new ASTCosec(aSTFunctionType);
        }
        if (aSTFunctionType.equals(ASTFunctionType.COT)) {
            return new ASTCot(aSTFunctionType);
        }
        if (aSTFunctionType.equals(ASTFunctionType.LOG)) {
            return new ASTLog(aSTFunctionType);
        }
        if (aSTFunctionType.equals(ASTFunctionType.COSH)) {
            return new ASTCosh(aSTFunctionType);
        }
        if (aSTFunctionType.equals(ASTFunctionType.ROOT)) {
            return new ASTRoot(aSTFunctionType);
        }
        if (aSTFunctionType.equals(ASTFunctionType.LN)) {
            return new ASTLn(aSTFunctionType);
        }
        if (aSTFunctionType.equals(ASTFunctionType.EXP)) {
            return new ASTExp(aSTFunctionType);
        }
        if (aSTFunctionType.equals(ASTFunctionType.FLOOR)) {
            return new ASTFloor(aSTFunctionType);
        }
        if (aSTFunctionType.equals(ASTFunctionType.CEIL)) {
            return new ASTCeil(aSTFunctionType);
        }
        if (aSTFunctionType.equals(ASTFunctionType.ABS)) {
            return new ASTAbs(aSTFunctionType);
        }
        if (aSTFunctionType.equals(ASTFunctionType.FACTORIAL)) {
            return new ASTFactorial(aSTFunctionType);
        }
        if (aSTFunctionType.equals(ASTFunctionType.POW)) {
            return new ASTPower();
        }
        return new ASTMiscellaneousFunction("misc");
    }

    public boolean isFunction() {
        return true;
    }

    public String toString() {
        return this.getName();
    }

    public boolean isSqrt() {
        return false;
    }

    public boolean hasCorrectNumberChildren() {
        return this.getNumChildren() == 1;
    }

    ASTNumber doEvaluate(IEvaluationContext iEvaluationContext) {
        return this.evaluate0(iEvaluationContext);
    }

    double getFirstChildEvaluatedValue(IEvaluationContext iEvaluationContext) {
        return this.firstChild().evaluate(iEvaluationContext).getValue();
    }

    abstract ASTNumber evaluate0(IEvaluationContext var1);

    boolean doAccept(ASTVisitor aSTVisitor) {
        block1: {
            if (!aSTVisitor.visit(this)) break block1;
            for (ASTNode aSTNode : this.getChildren()) {
                if (!aSTNode.accept(aSTVisitor)) break;
            }
        }
        return aSTVisitor.endVisit(this);
    }

    static {
        for (ASTFunctionType aSTFunctionType : ASTFunctionType.values()) {
            ENUMNAME_2_ENUM.put(aSTFunctionType.name().toLowerCase(), aSTFunctionType);
        }
        ABSTOLERANCE = 1.0E-9;
    }

    public static class ASTCot
    extends ASTFunction {
        ASTCot(ASTFunctionType aSTFunctionType) {
            super(aSTFunctionType);
            this.setName("cot");
        }

        ASTNumber evaluate0(IEvaluationContext iEvaluationContext) {
            double d = this.getFirstChildEvaluatedValue(iEvaluationContext);
            if (Math.sin(d) == 0.0) {
                return ASTNumber.createNumber(Double.POSITIVE_INFINITY);
            }
            double d2 = Math.cos(d) / Math.sin(d);
            return ASTNumber.createNumber(d2);
        }

        public String getString() {
            return "1/tan";
        }
    }

    public static class ASTCosec
    extends ASTFunction {
        ASTCosec(ASTFunctionType aSTFunctionType) {
            super(aSTFunctionType);
            this.setName("cosec");
        }

        ASTNumber evaluate0(IEvaluationContext iEvaluationContext) {
            double d = this.getFirstChildEvaluatedValue(iEvaluationContext);
            if (Math.sin(d) == 0.0) {
                return ASTNumber.createNumber(Double.POSITIVE_INFINITY);
            }
            double d2 = 1.0 / Math.sin(d);
            return ASTNumber.createNumber(d2);
        }

        public String getString() {
            return "1/sin";
        }
    }

    public static class ASTSec
    extends ASTFunction {
        ASTSec(ASTFunctionType aSTFunctionType) {
            super(aSTFunctionType);
            this.setName("sec");
        }

        ASTNumber evaluate0(IEvaluationContext iEvaluationContext) {
            if (Math.cos(this.getFirstChildEvaluatedValue(iEvaluationContext)) < ABSTOLERANCE) {
                return ASTNumber.createNumber(Double.POSITIVE_INFINITY);
            }
            double d = 1.0 / Math.cos(this.getFirstChildEvaluatedValue(iEvaluationContext));
            return ASTNumber.createNumber(d);
        }

        public String getString() {
            return "1/cos";
        }
    }

    public static class ASTRoot
    extends ASTFunction {
        private int degree = 2;

        ASTRoot(ASTFunctionType aSTFunctionType) {
            super(aSTFunctionType);
            this.setName("root");
        }

        ASTNumber evaluate0(IEvaluationContext iEvaluationContext) {
            double d = Double.NaN;
            ASTNumber aSTNumber = this.firstChild().evaluate(iEvaluationContext);
            if (this.isSqrt()) {
                d = Math.sqrt(this.getRightChild().evaluate(iEvaluationContext).getValue());
            } else if (this.isCbrt(iEvaluationContext)) {
                d = Math.cbrt(this.getChildAtIndex(1).evaluate(iEvaluationContext).getValue());
            } else {
                double d2 = aSTNumber.getValue();
                if (d2 == 0.0) {
                    d2 = 2.0;
                }
                d = Math.pow(this.getRightChild().evaluate(iEvaluationContext).getValue(), 1.0 / aSTNumber.getValue());
            }
            return ASTNumber.createNumber(d);
        }

        public boolean hasCorrectNumberChildren() {
            return this.getNumChildren() == 1 || this.getNumChildren() == 2;
        }

        public String getString() {
            return "root";
        }

        public boolean isSqrt() {
            return this.getNumChildren() == 1 || this.getNumChildren() == 2 && this.firstChild().getName().equals("2");
        }

        boolean isCbrt(IEvaluationContext iEvaluationContext) {
            return this.getNumChildren() == 2 && this.getFirstChildEvaluatedValue(iEvaluationContext) - 3.0 < 1.0E-5;
        }
    }

    public static class ASTLog
    extends ASTFunction {
        private int base = 10;

        ASTLog(ASTFunctionType aSTFunctionType) {
            super(aSTFunctionType);
            this.setName("log");
        }

        ASTNumber evaluate0(IEvaluationContext iEvaluationContext) {
            double d = Double.NaN;
            if (this.logHasBaseOtherThan10()) {
                ASTNumber aSTNumber = this.getChildAtIndex(1).evaluate(iEvaluationContext);
                d = Math.log(aSTNumber.getValue()) / Math.log(this.firstChild().evaluate(iEvaluationContext).getValue());
            } else {
                d = Math.log10(this.firstChild().evaluate(iEvaluationContext).getValue());
            }
            return ASTNumber.createNumber(d);
        }

        void setBase(int n) {
            assert (n > 0);
            this.base = n;
            this.addChildNode(ASTNumber.createNumber(n));
        }

        private boolean logHasBaseOtherThan10() {
            return this.getNumChildren() > 1;
        }

        public int getBase() {
            return this.base;
        }

        public boolean hasCorrectNumberChildren() {
            return this.getNumChildren() == 1 || this.getNumChildren() == 2;
        }

        public String getString() {
            return "log";
        }

        public boolean isLog10() {
            return this.getNumChildren() == 1;
        }
    }

    public static class ArcTan
    extends ASTFunction {
        ArcTan(ASTFunctionType aSTFunctionType) {
            super(aSTFunctionType);
            this.setName("arctan");
        }

        ASTNumber evaluate0(IEvaluationContext iEvaluationContext) {
            double d = Math.atan(this.getFirstChildEvaluatedValue(iEvaluationContext));
            return ASTNumber.createNumber(d);
        }

        public String getString() {
            return "arctan";
        }
    }

    public static class ASTTanh
    extends ASTFunction {
        ASTTanh(ASTFunctionType aSTFunctionType) {
            super(aSTFunctionType);
            this.setName("tanh");
        }

        ASTNumber evaluate0(IEvaluationContext iEvaluationContext) {
            double d = this.getFirstChildEvaluatedValue(iEvaluationContext);
            double d2 = Math.exp(d);
            double d3 = Math.exp(d * -1.0);
            double d4 = (d2 + d3) / 2.0;
            double d5 = (d2 - d3) / 2.0;
            if (d > 500.0) {
                return ASTNumber.createNumber(1);
            }
            if (d < -500.0) {
                return ASTNumber.createNumber(-1);
            }
            return ASTNumber.createNumber(d5 / d4);
        }

        public String getString() {
            return "tanh";
        }
    }

    public static class ASTArcTan
    extends ASTFunction {
        ASTArcTan(ASTFunctionType aSTFunctionType) {
            super(aSTFunctionType);
            this.setName("arctan");
        }

        ASTNumber evaluate0(IEvaluationContext iEvaluationContext) {
            double d = Math.atan(this.getFirstChildEvaluatedValue(iEvaluationContext));
            return ASTNumber.createNumber(d);
        }

        public String getString() {
            return "arctan";
        }
    }

    public static class ASTTan
    extends ASTFunction {
        ASTTan(ASTFunctionType aSTFunctionType) {
            super(aSTFunctionType);
            this.setName("tan");
        }

        ASTNumber evaluate0(IEvaluationContext iEvaluationContext) {
            double d = Math.tan(this.getFirstChildEvaluatedValue(iEvaluationContext));
            return ASTNumber.createNumber(d);
        }

        public String getString() {
            return "tan";
        }
    }

    public static class ASTLn
    extends ASTFunction {
        ASTLn(ASTFunctionType aSTFunctionType) {
            super(aSTFunctionType);
            this.setName("ln");
        }

        ASTNumber evaluate0(IEvaluationContext iEvaluationContext) {
            return ASTNumber.createNumber(Math.log(this.getFirstChildEvaluatedValue(iEvaluationContext)));
        }

        public String getString() {
            return "ln";
        }
    }

    public static class ASTExp
    extends ASTFunction {
        ASTExp(ASTFunctionType aSTFunctionType) {
            super(aSTFunctionType);
            this.setName("exp");
        }

        ASTNumber evaluate0(IEvaluationContext iEvaluationContext) {
            return ASTNumber.createNumber(Math.exp(this.getFirstChildEvaluatedValue(iEvaluationContext)));
        }

        public String getString() {
            return "exp";
        }
    }

    public static class ASTArcCos
    extends ASTFunction {
        ASTArcCos(ASTFunctionType aSTFunctionType) {
            super(aSTFunctionType);
            this.setName("arccos");
        }

        ASTNumber evaluate0(IEvaluationContext iEvaluationContext) {
            double d = Math.acos(this.getFirstChildEvaluatedValue(iEvaluationContext));
            return ASTNumber.createNumber(d);
        }

        public String getString() {
            return "arccos";
        }
    }

    public static class ASTCosh
    extends ASTFunction {
        ASTCosh(ASTFunctionType aSTFunctionType) {
            super(aSTFunctionType);
            this.setName("cosh");
        }

        ASTNumber evaluate0(IEvaluationContext iEvaluationContext) {
            double d = this.getFirstChildEvaluatedValue(iEvaluationContext);
            double d2 = (Math.exp(d) + Math.exp(d * -1.0)) / 2.0;
            return ASTNumber.createNumber(d2);
        }

        public String getString() {
            return "cosh";
        }
    }

    public static class ASTCos
    extends ASTFunction {
        ASTCos(ASTFunctionType aSTFunctionType) {
            super(aSTFunctionType);
            this.setName("cos");
        }

        ASTNumber evaluate0(IEvaluationContext iEvaluationContext) {
            double d = Math.cos(this.getFirstChildEvaluatedValue(iEvaluationContext));
            return ASTNumber.createNumber(d);
        }

        public String getString() {
            return "cos";
        }
    }

    public static class ASTArcSin
    extends ASTFunction {
        ASTArcSin(ASTFunctionType aSTFunctionType) {
            super(aSTFunctionType);
            this.setName("arcsin");
        }

        ASTNumber evaluate0(IEvaluationContext iEvaluationContext) {
            double d = Math.asin(this.getFirstChildEvaluatedValue(iEvaluationContext));
            return ASTNumber.createNumber(d);
        }

        public String getString() {
            return "arcsin";
        }
    }

    public static class ASTSinh
    extends ASTFunction {
        ASTSinh(ASTFunctionType aSTFunctionType) {
            super(aSTFunctionType);
            this.setName("sinh");
        }

        ASTNumber evaluate0(IEvaluationContext iEvaluationContext) {
            double d = this.getFirstChildEvaluatedValue(iEvaluationContext);
            double d2 = (Math.exp(d) - Math.exp(d * -1.0)) / 2.0;
            return ASTNumber.createNumber(d2);
        }

        public String getString() {
            return "sinh";
        }
    }

    public static class ASTMiscellaneousFunction
    extends ASTFunction {
        ASTMiscellaneousFunction(String string) {
            super(ASTFunctionType.MISCELLANEOUS);
            this.setName(string);
        }

        ASTNumber evaluate0(IEvaluationContext iEvaluationContext) {
            return ASTNumber.AST_NULL_NUMBER;
        }

        public String getString() {
            return this.getName();
        }
    }

    public static class ASTSin
    extends ASTFunction {
        ASTSin(ASTFunctionType aSTFunctionType) {
            super(aSTFunctionType);
            this.setName("sin");
        }

        ASTNumber evaluate0(IEvaluationContext iEvaluationContext) {
            double d = Math.sin(this.getFirstChildEvaluatedValue(iEvaluationContext));
            return ASTNumber.createNumber(d);
        }

        public String getString() {
            return "sin";
        }
    }

    public static class ASTFloor
    extends ASTFunction {
        ASTFloor(ASTFunctionType aSTFunctionType) {
            super(aSTFunctionType);
            this.setName("floor");
        }

        ASTNumber evaluate0(IEvaluationContext iEvaluationContext) {
            return ASTNumber.createNumber(Math.floor(this.getFirstChildEvaluatedValue(iEvaluationContext)));
        }

        public String getString() {
            return "floor";
        }
    }

    public static class ASTCeil
    extends ASTFunction {
        ASTCeil(ASTFunctionType aSTFunctionType) {
            super(aSTFunctionType);
            this.setName("ceil");
        }

        ASTNumber evaluate0(IEvaluationContext iEvaluationContext) {
            return ASTNumber.createNumber(Math.ceil(this.getFirstChildEvaluatedValue(iEvaluationContext)));
        }

        public String getString() {
            return this.getName();
        }
    }

    public static class ASTFactorial
    extends ASTFunction {
        ASTFactorial(ASTFunctionType aSTFunctionType) {
            super(aSTFunctionType);
            this.setName("factorial");
        }

        ASTNumber evaluate0(IEvaluationContext iEvaluationContext) {
            int n = (int)this.getFirstChildEvaluatedValue(iEvaluationContext);
            return ASTNumber.createNumber(this.factorial(n));
        }

        private long factorial(int n) {
            if (n <= 1) {
                return 1L;
            }
            return (long)n * this.factorial(n - 1);
        }

        public String getString() {
            return "factorial";
        }
    }

    public static class ASTAbs
    extends ASTFunction {
        ASTAbs(ASTFunctionType aSTFunctionType) {
            super(aSTFunctionType);
            this.setName("abs");
        }

        ASTNumber evaluate0(IEvaluationContext iEvaluationContext) {
            return ASTNumber.createNumber(Math.abs(this.getFirstChildEvaluatedValue(iEvaluationContext)));
        }

        public String getString() {
            return "abs";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ASTFunctionType implements ASTTypeI
    {
        SIN,
        COS,
        TAN,
        ARCSIN,
        ARCCOS,
        ARCTAN,
        SEC,
        COSEC,
        COT,
        SINH,
        COSH,
        TANH,
        LOG,
        ROOT,
        LN,
        EXP,
        ABS,
        FLOOR,
        CEIL,
        POW,
        FACTORIAL,
        MISCELLANEOUS;


        @Override
        public String getString() {
            return this.toString().toLowerCase();
        }
    }
}

