/*
 * Decompiled with CFR 0.152.
 */
package plugin.sample2.table;

import java.awt.Color;
import javax.swing.JTabbedPane;
import javax.swing.table.AbstractTableModel;
import jp.sbi.celldesigner.plugin.PluginAntiSenseRNA;
import jp.sbi.celldesigner.plugin.PluginAssignmentRule;
import jp.sbi.celldesigner.plugin.PluginCompartment;
import jp.sbi.celldesigner.plugin.PluginEvent;
import jp.sbi.celldesigner.plugin.PluginFunctionDefinition;
import jp.sbi.celldesigner.plugin.PluginGene;
import jp.sbi.celldesigner.plugin.PluginKineticLaw;
import jp.sbi.celldesigner.plugin.PluginModel;
import jp.sbi.celldesigner.plugin.PluginParameter;
import jp.sbi.celldesigner.plugin.PluginProtein;
import jp.sbi.celldesigner.plugin.PluginRNA;
import jp.sbi.celldesigner.plugin.PluginRateRule;
import jp.sbi.celldesigner.plugin.PluginReaction;
import jp.sbi.celldesigner.plugin.PluginRule;
import jp.sbi.celldesigner.plugin.PluginSBase;
import jp.sbi.celldesigner.plugin.PluginSpecies;
import jp.sbi.celldesigner.plugin.PluginUnitDefinition;
import org.sbml.libsbml.libsbml;
import plugin.sample2.dialog.CommonSBaseViewingTab;
import plugin.sample2.dialog.PluginSampleDialog;

class JarViewingTableModel
extends AbstractTableModel {
    private Object[][] data;
    protected Object[] COL_NAMES;
    private String tabName;

    public JarViewingTableModel(Object[][] data, Object[] names, String tabName) {
        this.COL_NAMES = names;
        this.data = data;
        this.tabName = tabName;
    }

    public void delData(int selectedRow) {
        Object[][] newData = new Object[this.data.length - 1][4];
        int row = 0;
        int i = 0;
        while (i < this.data.length) {
            if (i != selectedRow) {
                int k = 0;
                while (k < this.data[i].length) {
                    newData[row][k] = this.data[i][k];
                    ++k;
                }
                ++row;
            }
            ++i;
        }
        this.data = newData;
        this.fireTableDataChanged();
    }

    public int getColumnCount() {
        return this.COL_NAMES.length;
    }

    public int getRowCount() {
        return this.data.length;
    }

    public String getColumnName(int col) {
        return (String)this.COL_NAMES[col];
    }

    public Object getValueAt(int row, int col) {
        return this.data[row][col];
    }

    public Class getColumnClass(int c) {
        if (this.getValueAt(0, c) != null) {
            return this.getValueAt(0, c).getClass();
        }
        if (c == 0) {
            return new Boolean(false).getClass();
        }
        return new String().getClass();
    }

    public boolean isCellEditable(int row, int col) {
        if (this.tabName.equals("Species")) {
            if (col == 0 || col == 1 || col == 2 || col == 3) {
                return false;
            }
        } else {
            if (this.tabName.equals("SpeciesAlias")) {
                return false;
            }
            if (this.tabName.equals("Proteins") || this.tabName.equals("Genes") || this.tabName.equals("RNAs") || this.tabName.equals("AsRNAs")) {
                if (col == 1) {
                    return false;
                }
            } else if (this.tabName.equals("Reactions")) {
                if (col == 1 || col == 5 || col == 6 || col == 7 || col == 8) {
                    return false;
                }
            } else {
                if (this.tabName.equals("KineticLaws")) {
                    return false;
                }
                if (this.tabName.equals("Compartments") ? col == 0 : (this.tabName.equals("Lacal_Parameter") ? col == 0 : (this.tabName.equals("Global_Parameters") ? col == 0 : (this.tabName.equals("Functions") ? col == 0 : (this.tabName.equals("UnitDefinitions") ? col == 0 || col == 2 : (this.tabName.equals("Units") ? col == 0 : !this.tabName.equals("Rules") && this.tabName.equals("Events") && col == 0)))))) {
                    return false;
                }
            }
        }
        return true;
    }

    public void setValueAt(Object value, int row, int col) {
        if (this.data[0][col] instanceof Integer && !(value instanceof Integer)) {
            try {
                this.data[row][col] = new Integer(value.toString());
                this.fireTableCellUpdated(row, col);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        } else {
            this.data[row][col] = value;
            this.fireTableCellUpdated(row, col);
            PluginModel model = PluginSampleDialog.model;
            JTabbedPane pane = PluginSampleDialog.tabPane;
            if (pane.getSelectedIndex() == 0) {
                CommonSBaseViewingTab tab = (CommonSBaseViewingTab)pane.getComponent(0);
                PluginSpecies sp = model.getSpecies(tab.getViewTabel().getSelectedRow());
                int j = 0;
                while (j < tab.getViewTabel().getColumnCount()) {
                    String rowvalue = null;
                    Boolean boo = null;
                    try {
                        rowvalue = (String)tab.getViewTabel().getModel().getValueAt(tab.getViewTabel().getSelectedRow(), j);
                    }
                    catch (Exception ex) {
                        boo = (Boolean)tab.getViewTabel().getModel().getValueAt(tab.getViewTabel().getSelectedRow(), j);
                    }
                    if (j != 0 && j != 1 && j != 2 && j != 3) {
                        if (j == 5) {
                            sp.setCompartment(rowvalue);
                        } else if (j != 6) {
                            if (j == 7) {
                                if (sp.isSetInitialAmount()) {
                                    sp.setInitialAmount(Double.parseDouble(rowvalue));
                                } else {
                                    sp.setInitialConcentration(Double.parseDouble(rowvalue));
                                }
                            } else if (j == 8) {
                                sp.setSubstanceUnits(rowvalue);
                            } else if (j == 9) {
                                sp.setSpatialSizeUnits(rowvalue);
                            } else if (j == 10) {
                                sp.setHasOnlySubstanceUnits(boo.booleanValue());
                            } else if (j == 11) {
                                sp.setBoundaryCondition(boo.booleanValue());
                            } else if (j == 12) {
                                sp.setCharge(Integer.parseInt(rowvalue));
                            } else if (j == 13) {
                                sp.setConstant(boo.booleanValue());
                            } else if (j == 14) {
                                sp.setNotes(rowvalue);
                            }
                        }
                    }
                    ++j;
                }
                PluginSampleDialog.plug.notifySBaseChanged((PluginSBase)sp);
            } else if (2 == pane.getSelectedIndex()) {
                CommonSBaseViewingTab tab = (CommonSBaseViewingTab)pane.getComponent(2);
                PluginProtein pro = model.getProtein((String)tab.getViewTabel().getValueAt(tab.getViewTabel().getSelectedRow(), 1));
                int j = 0;
                while (j < tab.getViewTabel().getColumnCount()) {
                    String rowvalue = null;
                    Boolean boo = null;
                    try {
                        rowvalue = (String)tab.getViewTabel().getModel().getValueAt(tab.getViewTabel().getSelectedRow(), j);
                    }
                    catch (Exception ex) {
                        boo = (Boolean)tab.getViewTabel().getModel().getValueAt(tab.getViewTabel().getSelectedRow(), j);
                    }
                    if (j == 0) {
                        pro.setType(rowvalue);
                    } else if (j != 1) {
                        if (j == 2) {
                            pro.setName(rowvalue);
                        } else if (j == 3) {
                            pro.setNotes(rowvalue);
                        }
                    }
                    ++j;
                }
                PluginSampleDialog.plug.notifySBaseChanged((PluginSBase)pro);
            } else if (3 == pane.getSelectedIndex()) {
                CommonSBaseViewingTab tab = (CommonSBaseViewingTab)pane.getComponent(3);
                PluginGene pro = model.getGene((String)tab.getViewTabel().getValueAt(tab.getViewTabel().getSelectedRow(), 1));
                int j = 0;
                while (j < tab.getViewTabel().getColumnCount()) {
                    String rowvalue = null;
                    Boolean boo = null;
                    try {
                        rowvalue = (String)tab.getViewTabel().getModel().getValueAt(tab.getViewTabel().getSelectedRow(), j);
                    }
                    catch (Exception ex) {
                        boo = (Boolean)tab.getViewTabel().getModel().getValueAt(tab.getViewTabel().getSelectedRow(), j);
                    }
                    if (j == 0) {
                        pro.setType(rowvalue);
                    } else if (j != 1) {
                        if (j == 2) {
                            pro.setName(rowvalue);
                        } else if (j == 3) {
                            pro.setNotes(rowvalue);
                        }
                    }
                    ++j;
                }
                PluginSampleDialog.plug.notifySBaseChanged((PluginSBase)pro);
            } else if (4 == pane.getSelectedIndex()) {
                CommonSBaseViewingTab tab = (CommonSBaseViewingTab)pane.getComponent(4);
                PluginRNA pro = model.getRNA((String)tab.getViewTabel().getValueAt(tab.getViewTabel().getSelectedRow(), 1));
                int j = 0;
                while (j < tab.getViewTabel().getColumnCount()) {
                    String rowvalue = null;
                    Boolean boo = null;
                    try {
                        rowvalue = (String)tab.getViewTabel().getModel().getValueAt(tab.getViewTabel().getSelectedRow(), j);
                    }
                    catch (Exception ex) {
                        boo = (Boolean)tab.getViewTabel().getModel().getValueAt(tab.getViewTabel().getSelectedRow(), j);
                    }
                    if (j == 0) {
                        pro.setType(rowvalue);
                    } else if (j != 1) {
                        if (j == 2) {
                            pro.setName(rowvalue);
                        } else if (j == 3) {
                            pro.setNotes(rowvalue);
                        }
                    }
                    ++j;
                }
                PluginSampleDialog.plug.notifySBaseChanged((PluginSBase)pro);
            } else if (5 == pane.getSelectedIndex()) {
                CommonSBaseViewingTab tab = (CommonSBaseViewingTab)pane.getComponent(5);
                PluginAntiSenseRNA pro = model.getAntiSenseRNA((String)tab.getViewTabel().getValueAt(tab.getViewTabel().getSelectedRow(), 1));
                int j = 0;
                while (j < tab.getViewTabel().getColumnCount()) {
                    String rowvalue = null;
                    Boolean boo = null;
                    try {
                        rowvalue = (String)tab.getViewTabel().getModel().getValueAt(tab.getViewTabel().getSelectedRow(), j);
                    }
                    catch (Exception ex) {
                        boo = (Boolean)tab.getViewTabel().getModel().getValueAt(tab.getViewTabel().getSelectedRow(), j);
                    }
                    if (j == 0) {
                        pro.setType(rowvalue);
                    } else if (j != 1) {
                        if (j == 2) {
                            pro.setName(rowvalue);
                        } else if (j == 3) {
                            pro.setNotes(rowvalue);
                        }
                    }
                    ++j;
                }
                PluginSampleDialog.plug.notifySBaseChanged((PluginSBase)pro);
            } else if (6 == pane.getSelectedIndex()) {
                CommonSBaseViewingTab tab = (CommonSBaseViewingTab)pane.getComponent(6);
                PluginReaction sp = model.getReaction(tab.getViewTabel().getSelectedRow());
                int j = 0;
                while (j < tab.getViewTabel().getColumnCount()) {
                    String rowvalue = null;
                    Boolean boo = null;
                    try {
                        rowvalue = (String)tab.getViewTabel().getModel().getValueAt(tab.getViewTabel().getSelectedRow(), j);
                    }
                    catch (Exception ex) {
                        boo = (Boolean)tab.getViewTabel().getModel().getValueAt(tab.getViewTabel().getSelectedRow(), j);
                    }
                    if (j == 0) {
                        sp.setReactionType(rowvalue);
                    } else if (j != 1) {
                        if (j == 2) {
                            sp.setName(rowvalue);
                        } else if (j == 3) {
                            sp.setReversible(boo.booleanValue());
                        } else if (j == 4) {
                            sp.setFast(boo.booleanValue());
                        } else if (j != 5 && j != 6 && j != 7) {
                            if (j == 8) {
                                if (sp.getKineticLaw() != null) {
                                    sp.getKineticLaw().setFormula(rowvalue);
                                }
                            } else if (j == 9) {
                                sp.setLineWidth(Double.parseDouble(rowvalue));
                            } else if (j == 10) {
                                sp.setNotes(rowvalue);
                            }
                        }
                    }
                    ++j;
                }
                PluginSampleDialog.plug.notifySBaseChanged((PluginSBase)sp);
            } else if (7 == pane.getSelectedIndex()) {
                CommonSBaseViewingTab tab = (CommonSBaseViewingTab)pane.getComponent(7);
                PluginReaction re = model.getReaction(tab.getViewTabel().getSelectedRow());
                PluginKineticLaw sp = re.getKineticLaw();
                int j = 0;
                while (j < tab.getViewTabel().getColumnCount()) {
                    String rowvalue = null;
                    Boolean boo = null;
                    try {
                        rowvalue = (String)tab.getViewTabel().getModel().getValueAt(tab.getViewTabel().getSelectedRow(), j);
                    }
                    catch (Exception ex) {
                        boo = (Boolean)tab.getViewTabel().getModel().getValueAt(tab.getViewTabel().getSelectedRow(), j);
                    }
                    if (j == 0) {
                        sp.setFormula(rowvalue);
                    } else if (j == 1) {
                        sp.setSubstanceUnits(rowvalue);
                    } else if (j == 2) {
                        sp.setTimeUnits(rowvalue);
                    }
                    ++j;
                }
                PluginSampleDialog.plug.notifySBaseChanged((PluginSBase)sp);
            } else if (8 == pane.getSelectedIndex()) {
                CommonSBaseViewingTab tab = (CommonSBaseViewingTab)pane.getComponent(8);
                PluginCompartment sp = model.getCompartment(tab.getViewTabel().getSelectedRow());
                int j = 0;
                while (j < tab.getViewTabel().getColumnCount()) {
                    String rowvalue = null;
                    Boolean boo = null;
                    try {
                        rowvalue = (String)tab.getViewTabel().getModel().getValueAt(tab.getViewTabel().getSelectedRow(), j);
                    }
                    catch (Exception ex) {
                        boo = (Boolean)tab.getViewTabel().getModel().getValueAt(tab.getViewTabel().getSelectedRow(), j);
                    }
                    if (j != 0) {
                        if (j == 1) {
                            sp.setName(rowvalue);
                        } else if (j == 2) {
                            sp.setSpatialDimensions(Long.parseLong(rowvalue));
                        } else if (j == 3) {
                            sp.setSize(Double.parseDouble(rowvalue));
                        } else if (j == 4) {
                            sp.setUnits(rowvalue);
                        } else if (j == 5) {
                            sp.setOutside(rowvalue);
                        } else if (j == 6) {
                            sp.setConstant(boo.booleanValue());
                        } else if (j == 7) {
                            sp.setX(Double.parseDouble(rowvalue));
                        } else if (j == 8) {
                            sp.setY(Double.parseDouble(rowvalue));
                        } else if (j == 9) {
                            sp.setWidth(Double.parseDouble(rowvalue));
                        } else if (j == 10) {
                            sp.setHeight(Double.parseDouble(rowvalue));
                        } else if (j == 11) {
                            sp.setNotes(rowvalue);
                        }
                    }
                    ++j;
                }
                sp.setLineColor(Color.BLACK);
                System.out.println("sp.setLineColor(Color.BLACK);");
                PluginSampleDialog.plug.notifySBaseChanged((PluginSBase)sp);
            } else if (9 == pane.getSelectedIndex()) {
                CommonSBaseViewingTab tab = (CommonSBaseViewingTab)pane.getComponent(9);
                PluginParameter sp = model.getParameter(tab.getViewTabel().getSelectedRow());
                int j = 0;
                while (j < tab.getViewTabel().getColumnCount()) {
                    String rowvalue = null;
                    Boolean boo = null;
                    try {
                        rowvalue = (String)tab.getViewTabel().getModel().getValueAt(tab.getViewTabel().getSelectedRow(), j);
                    }
                    catch (Exception ex) {
                        boo = (Boolean)tab.getViewTabel().getModel().getValueAt(tab.getViewTabel().getSelectedRow(), j);
                    }
                    if (j != 0) {
                        if (j == 1) {
                            sp.setName(rowvalue);
                        } else if (j == 2) {
                            sp.setValue(Double.parseDouble(rowvalue));
                        } else if (j == 3) {
                            sp.setUnits(rowvalue);
                        } else if (j == 4) {
                            sp.setConstant(boo.booleanValue());
                        }
                    }
                    ++j;
                }
                PluginSampleDialog.plug.notifySBaseChanged((PluginSBase)sp);
            } else if (10 == pane.getSelectedIndex()) {
                CommonSBaseViewingTab tab = (CommonSBaseViewingTab)pane.getComponent(10);
                PluginFunctionDefinition sp = model.getFunctionDefinition(tab.getViewTabel().getSelectedRow());
                int j = 0;
                while (j < tab.getViewTabel().getColumnCount()) {
                    String rowvalue = null;
                    Boolean boo = null;
                    try {
                        rowvalue = (String)tab.getViewTabel().getModel().getValueAt(tab.getViewTabel().getSelectedRow(), j);
                    }
                    catch (Exception ex) {
                        boo = (Boolean)tab.getViewTabel().getModel().getValueAt(tab.getViewTabel().getSelectedRow(), j);
                    }
                    if (j != 0) {
                        if (j == 1) {
                            sp.setName(rowvalue);
                        } else if (j != 2 && j == 3) {
                            sp.setMath(libsbml.parseFormula((String)rowvalue));
                        }
                    }
                    ++j;
                }
                PluginSampleDialog.plug.notifySBaseChanged((PluginSBase)sp);
            } else if (11 == pane.getSelectedIndex()) {
                CommonSBaseViewingTab tab = (CommonSBaseViewingTab)pane.getComponent(11);
                PluginUnitDefinition sp = model.getUnitDefinition(tab.getViewTabel().getSelectedRow());
                int j = 0;
                while (j < tab.getViewTabel().getColumnCount()) {
                    String rowvalue = null;
                    Boolean boo = null;
                    try {
                        rowvalue = (String)tab.getViewTabel().getModel().getValueAt(tab.getViewTabel().getSelectedRow(), j);
                    }
                    catch (Exception ex) {
                        boo = (Boolean)tab.getViewTabel().getModel().getValueAt(tab.getViewTabel().getSelectedRow(), j);
                    }
                    if (j != 0 && j == 1) {
                        sp.setName(rowvalue);
                    }
                    ++j;
                }
                PluginSampleDialog.plug.notifySBaseChanged((PluginSBase)sp);
            } else if (12 == pane.getSelectedIndex()) {
                CommonSBaseViewingTab tab = (CommonSBaseViewingTab)pane.getComponent(12);
                PluginRule rule = model.getRule(tab.getViewTabel().getSelectedRow());
                int j = 0;
                while (j < tab.getViewTabel().getColumnCount()) {
                    String rowvalue = null;
                    Object boo = null;
                    try {
                        rowvalue = (String)tab.getViewTabel().getModel().getValueAt(tab.getViewTabel().getSelectedRow(), j);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    if (j == 1) {
                        rule.setFormula(rowvalue);
                    } else if (j == 2) {
                        PluginAssignmentRule r;
                        if (rule instanceof PluginAssignmentRule) {
                            r = (PluginAssignmentRule)rule;
                            r.setVariable(rowvalue);
                        } else if (rule instanceof PluginRateRule) {
                            r = (PluginRateRule)rule;
                            r.setVariable(rowvalue);
                        }
                    }
                    ++j;
                }
                PluginSampleDialog.plug.notifySBaseChanged((PluginSBase)rule);
            } else if (13 == pane.getSelectedIndex()) {
                CommonSBaseViewingTab tab = (CommonSBaseViewingTab)pane.getComponent(13);
                PluginEvent sp = model.getEvent(tab.getViewTabel().getSelectedRow());
                int j = 0;
                while (j < tab.getViewTabel().getColumnCount()) {
                    String rowvalue = null;
                    Boolean boo = null;
                    try {
                        rowvalue = (String)tab.getViewTabel().getModel().getValueAt(tab.getViewTabel().getSelectedRow(), j);
                    }
                    catch (Exception ex) {
                        boo = (Boolean)tab.getViewTabel().getModel().getValueAt(tab.getViewTabel().getSelectedRow(), j);
                    }
                    if (j != 0) {
                        if (j == 1) {
                            sp.setName(rowvalue);
                        } else if (j == 2) {
                            if (rowvalue != null && !rowvalue.equals("")) {
                                sp.setTrigger(libsbml.parseFormula((String)rowvalue));
                            }
                        } else if (j == 3) {
                            if (rowvalue != null && !rowvalue.equals("")) {
                                sp.setDelay(libsbml.parseFormula((String)rowvalue));
                            }
                        } else if (j == 4) {
                            sp.setTimeUnits(rowvalue);
                        }
                    }
                    ++j;
                }
                PluginSampleDialog.plug.notifySBaseChanged((PluginSBase)sp);
            }
        }
    }
}

