/*
 * Decompiled with CFR 0.152.
 */
package plugin.sample2.dialog.editdialog;

import java.awt.Component;
import java.awt.Rectangle;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jp.sbi.celldesigner.plugin.PluginModifierSpeciesReference;
import jp.sbi.celldesigner.plugin.PluginSBase;
import jp.sbi.celldesigner.plugin.PluginSpeciesReference;
import jp.sbi.sbml.util.MathEditPanel;
import org.sbml.libsbml.ASTNode;
import org.sbml.libsbml.libsbml;
import plugin.sample2.dialog.editdialog.PluginSBaseDialog;

public class PluginSpeciesReferenceDialog
extends PluginSBaseDialog {
    private JTextField speciesTextField;
    private JTextField aliasTextField;
    private JTextField stoichiometryTextField;
    private JTextField mathTextField;
    private MathEditPanel mathPanel;
    private String type;

    public PluginSpeciesReferenceDialog(PluginSpeciesReference ref) {
        this.editingSBase = ref;
        this.setDialogFromObject((PluginSBase)ref);
        this.setVisible(true);
    }

    public PluginSpeciesReferenceDialog(PluginModifierSpeciesReference ref) {
        this.editingSBase = ref;
        this.setDialogFromObject((PluginSBase)ref);
        this.setVisible(true);
    }

    protected JPanel createDialogPanel() {
        this.LABEL_WIDTH = 90;
        this.TEXT_WIDTH = 300;
        this.setLayoutConstants();
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(null);
        int yline = this.VERTICAL_MARGIN;
        JLabel speciesLabel = new JLabel("species ID");
        speciesLabel.setBounds(new Rectangle(this.HORIZONTAL_MARGIN, yline, this.LABEL_WIDTH, this.LINE_HEIGHT));
        this.mainPanel.add((Component)speciesLabel, null);
        this.speciesTextField = new JTextField();
        this.speciesTextField.setBounds(new Rectangle(this.TEXT_POSITION_X, yline, this.TEXT_WIDTH, this.LINE_HEIGHT));
        this.speciesTextField.setEditable(true);
        this.mainPanel.add((Component)this.speciesTextField, null);
        JLabel aliasLabel = new JLabel("speciesAlias ID");
        aliasLabel.setBounds(new Rectangle(this.HORIZONTAL_MARGIN, yline += this.BASELINE_SKIP, this.LABEL_WIDTH, this.LINE_HEIGHT));
        this.mainPanel.add((Component)aliasLabel, null);
        this.aliasTextField = new JTextField();
        this.aliasTextField.setBounds(new Rectangle(this.TEXT_POSITION_X, yline, this.TEXT_WIDTH, this.LINE_HEIGHT));
        this.aliasTextField.setEditable(true);
        this.mainPanel.add((Component)this.aliasTextField, null);
        JLabel stoichiometryLabel = new JLabel("stoichiometry");
        stoichiometryLabel.setBounds(new Rectangle(this.HORIZONTAL_MARGIN, yline += this.BASELINE_SKIP, this.LABEL_WIDTH, this.LINE_HEIGHT));
        this.mainPanel.add((Component)stoichiometryLabel, null);
        this.stoichiometryTextField = new JTextField();
        this.stoichiometryTextField.setBounds(new Rectangle(this.TEXT_POSITION_X, yline, this.TEXT_WIDTH, this.LINE_HEIGHT));
        this.stoichiometryTextField.setEditable(true);
        this.mainPanel.add((Component)this.stoichiometryTextField, null);
        JLabel stoichiometryMathLabel = new JLabel("stoichiometryMath");
        stoichiometryMathLabel.setBounds(new Rectangle(this.HORIZONTAL_MARGIN, yline += this.BASELINE_SKIP, this.LABEL_WIDTH, this.LINE_HEIGHT));
        this.mainPanel.add((Component)stoichiometryMathLabel, null);
        this.mathPanel = new MathEditPanel();
        int mpheight = this.mathPanel.createUI(this.TEXT_WIDTH, this.LINE_HEIGHT, this.BASELINE_SKIP);
        this.mathPanel.setBounds(new Rectangle(this.TEXT_POSITION_X, yline, this.TEXT_WIDTH, mpheight));
        this.mathTextField = this.mathPanel.getTextField();
        this.mathTextField.setEditable(true);
        this.mainPanel.add((Component)this.mathPanel, null);
        this.BUTTON_POSITION_Y = yline += mpheight + this.BASELINE_SKIP - this.LINE_HEIGHT;
        this.setDefaultButtonsLayout();
        this.addDefaultButtonsToPanel();
        return this.mainPanel;
    }

    protected void setDialogFromObject(PluginSBase sbase) {
        if (sbase == null) {
            return;
        }
        if (sbase instanceof PluginSpeciesReference) {
            PluginSpeciesReference speciesReference = (PluginSpeciesReference)sbase;
            String species = speciesReference.getSpecies();
            this.speciesTextField.setText(species);
            this.aliasTextField.setText(speciesReference.getAlias().getAliasID());
            this.aliasTextField.setCaretPosition(speciesReference.getAlias().getAliasID().length());
            String mathString = "";
            if (speciesReference.getStoichiometryMath() != null) {
                mathString = libsbml.formulaToString((ASTNode)speciesReference.getStoichiometryMath().getMath());
            }
            if (mathString.equals("")) {
                double stoichiometry = speciesReference.getStoichiometry();
                String s1 = Double.toString(stoichiometry);
                this.stoichiometryTextField.setText(s1);
                this.stoichiometryTextField.setCaretPosition(s1.length());
            } else {
                this.stoichiometryTextField.setText("");
            }
            this.mathTextField.setText(mathString);
            this.mathTextField.setCaretPosition(mathString.length());
        } else {
            PluginModifierSpeciesReference speciesReference = (PluginModifierSpeciesReference)sbase;
            String species = speciesReference.getSpecies();
            this.speciesTextField.setText(species);
            this.aliasTextField.setText(speciesReference.getAlias().getAliasID());
            this.aliasTextField.setCaretPosition(species.length());
            this.stoichiometryTextField.setEditable(false);
            this.mathTextField.setEditable(false);
        }
    }

    protected void updateObject() {
        double stoichiometry;
        String s1;
        PluginSpeciesReference ref = (PluginSpeciesReference)this.editingSBase;
        String mathString = "";
        if (mathString.equals("") && (s1 = Double.toString(stoichiometry = Double.parseDouble(this.stoichiometryTextField.getText()))) != null && !s1.equals("")) {
            ref.setStoichiometry(Double.valueOf(s1).doubleValue());
        }
        ref.setStoichiometryMath(this.mathTextField.getText());
    }
}

