/*
 * Decompiled with CFR 0.152.
 */
package plugin.sample2.dialog.editdialog;

import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;
import jp.sbi.celldesigner.plugin.PluginAntiSenseRNA;
import jp.sbi.celldesigner.plugin.PluginGene;
import jp.sbi.celldesigner.plugin.PluginModification;
import jp.sbi.celldesigner.plugin.PluginProtein;
import jp.sbi.celldesigner.plugin.PluginRNA;
import jp.sbi.celldesigner.plugin.PluginSBase;
import jp.sbi.celldesigner.plugin.PluginSpeciesAlias;
import plugin.sample2.dialog.PluginSampleDialog;

public class PluginSpeciesNodeDialog
extends JDialog {
    PluginSpeciesAlias alias;
    JButton buttonOK;
    JButton buttonClose;
    JLabel labelSpeciesId;
    JLabel labelExtensionType;
    JLabel labelExtensionID;
    JLabel labelName;
    JLabel labelHomodimer;
    JLabel labelHypothetical;
    JLabel labelX;
    JLabel labelY;
    JLabel labelWidth;
    JLabel labelHeight;
    JLabel labelColor;
    JLabel labelLineWidth;
    String[] typeData = new String[]{"PROTEIN", "GENE", "RNA", "ANTISENSE_RNA", "ION", "SIMPLE_MOLECULE", "PHENOTYPE", "UNKNOWN", "COMPLEX", "DEGRADED"};
    JTextField textSpeciesId;
    JComboBox comboExtensionType = new JComboBox<String>(this.typeData);
    JComboBox comboExtensionID = new JComboBox();
    JTextField textName;
    JTextField textHomodimer;
    JCheckBox checkHypothetical;
    JTextField textX;
    JTextField textY;
    JTextField textWidth;
    JTextField textHeight;
    JTextField textColor;
    JTextField textLineWidth;

    private String[] getProteinData() {
        String[] data = new String[PluginSampleDialog.model.getListOfProteins().size()];
        int i = 0;
        while (i < PluginSampleDialog.model.getListOfProteins().size()) {
            PluginProtein p = (PluginProtein)PluginSampleDialog.model.getListOfProteins().get(i);
            data[i] = p.getExtensionId();
            ++i;
        }
        return data;
    }

    private String[] getGeneData() {
        String[] data = new String[PluginSampleDialog.model.getListOfGenes().size()];
        int i = 0;
        while (i < PluginSampleDialog.model.getListOfGenes().size()) {
            PluginGene p = (PluginGene)PluginSampleDialog.model.getListOfGenes().get(i);
            data[i] = p.getExtensionId();
            ++i;
        }
        return data;
    }

    private String[] getRNAData() {
        String[] data = new String[PluginSampleDialog.model.getListOfRNAs().size()];
        int i = 0;
        while (i < PluginSampleDialog.model.getListOfRNAs().size()) {
            PluginRNA p = (PluginRNA)PluginSampleDialog.model.getListOfRNAs().get(i);
            data[i] = p.getExtensionId();
            ++i;
        }
        return data;
    }

    private String[] getasRNAData() {
        String[] data = new String[PluginSampleDialog.model.getListOfAntiSenseRNAs().size()];
        int i = 0;
        while (i < PluginSampleDialog.model.getListOfAntiSenseRNAs().size()) {
            PluginAntiSenseRNA p = (PluginAntiSenseRNA)PluginSampleDialog.model.getListOfAntiSenseRNAs().get(i);
            data[i] = p.getExtensionId();
            ++i;
        }
        return data;
    }

    public PluginSpeciesNodeDialog(PluginSpeciesAlias alias) {
        this.alias = alias;
        this.init();
        this.setDataDialog();
    }

    private void init() {
        this.setSize(400, 400);
        this.getContentPane().setLayout(new GridLayout(14, 2, 1, 1));
        this.labelSpeciesId = new JLabel("   Species ID");
        this.getContentPane().add(this.labelSpeciesId);
        this.textSpeciesId = new JTextField();
        this.getContentPane().add(this.textSpeciesId);
        this.textSpeciesId.setEditable(false);
        this.labelExtensionType = new JLabel("   Species Type");
        this.getContentPane().add(this.labelExtensionType);
        this.getContentPane().add(this.comboExtensionType);
        this.comboExtensionType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (PluginSpeciesNodeDialog.this.comboExtensionType == null || PluginSpeciesNodeDialog.this.comboExtensionType.getSelectedItem() == null) {
                    return;
                }
                PluginSpeciesNodeDialog.this.comboExtensionID.removeAllItems();
                if (((String)PluginSpeciesNodeDialog.this.comboExtensionType.getSelectedItem()).equals("PROTEIN")) {
                    String[] item = PluginSpeciesNodeDialog.this.getProteinData();
                    int i = 0;
                    while (i < item.length) {
                        PluginSpeciesNodeDialog.this.comboExtensionID.addItem(item[i]);
                        ++i;
                    }
                    PluginSpeciesNodeDialog.this.comboExtensionID.updateUI();
                } else if (((String)PluginSpeciesNodeDialog.this.comboExtensionType.getSelectedItem()).equals("GENE")) {
                    String[] item = PluginSpeciesNodeDialog.this.getGeneData();
                    int i = 0;
                    while (i < item.length) {
                        PluginSpeciesNodeDialog.this.comboExtensionID.addItem(item[i]);
                        ++i;
                    }
                    PluginSpeciesNodeDialog.this.comboExtensionID.updateUI();
                } else if (((String)PluginSpeciesNodeDialog.this.comboExtensionType.getSelectedItem()).equals("RNA")) {
                    String[] item = PluginSpeciesNodeDialog.this.getRNAData();
                    int i = 0;
                    while (i < item.length) {
                        PluginSpeciesNodeDialog.this.comboExtensionID.addItem(item[i]);
                        ++i;
                    }
                    PluginSpeciesNodeDialog.this.comboExtensionID.updateUI();
                } else if (((String)PluginSpeciesNodeDialog.this.comboExtensionType.getSelectedItem()).equals("ANTISENSE_RNA")) {
                    String[] item = PluginSpeciesNodeDialog.this.getasRNAData();
                    int i = 0;
                    while (i < item.length) {
                        PluginSpeciesNodeDialog.this.comboExtensionID.addItem(item[i]);
                        ++i;
                    }
                    PluginSpeciesNodeDialog.this.comboExtensionID.updateUI();
                }
            }
        });
        this.labelName = new JLabel("   name");
        this.getContentPane().add(this.labelName);
        this.textName = new JTextField();
        this.getContentPane().add(this.textName);
        this.labelExtensionID = new JLabel("   extension ID");
        this.getContentPane().add(this.labelExtensionID);
        this.getContentPane().add(this.comboExtensionID);
        this.comboExtensionID.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (((String)PluginSpeciesNodeDialog.this.comboExtensionType.getSelectedItem()).equals("PROTEIN")) {
                    String id = (String)PluginSpeciesNodeDialog.this.comboExtensionID.getSelectedItem();
                    PluginProtein p = PluginSampleDialog.model.getProtein(id);
                    if (p != null) {
                        PluginSpeciesNodeDialog.this.textName.setText(p.getName());
                        PluginSpeciesNodeDialog.this.textName.setEditable(false);
                    } else {
                        System.out.println("<Illegal protein ID.> = " + id);
                    }
                } else if (((String)PluginSpeciesNodeDialog.this.comboExtensionType.getSelectedItem()).equals("GENE")) {
                    String id = (String)PluginSpeciesNodeDialog.this.comboExtensionID.getSelectedItem();
                    PluginGene p = PluginSampleDialog.model.getGene(id);
                    if (p != null) {
                        PluginSpeciesNodeDialog.this.textName.setText(p.getName());
                        PluginSpeciesNodeDialog.this.textName.setEditable(false);
                    } else {
                        System.out.println("<Illegal gene ID.> = " + id);
                    }
                } else if (((String)PluginSpeciesNodeDialog.this.comboExtensionType.getSelectedItem()).equals("RNA")) {
                    String id = (String)PluginSpeciesNodeDialog.this.comboExtensionID.getSelectedItem();
                    PluginRNA p = PluginSampleDialog.model.getRNA(id);
                    if (p != null) {
                        PluginSpeciesNodeDialog.this.textName.setText(p.getName());
                        PluginSpeciesNodeDialog.this.textName.setEditable(false);
                    } else {
                        System.out.println("<Illegal rna ID.> = " + id);
                    }
                } else if (((String)PluginSpeciesNodeDialog.this.comboExtensionType.getSelectedItem()).equals("ANTISENSE_RNA")) {
                    String id = (String)PluginSpeciesNodeDialog.this.comboExtensionID.getSelectedItem();
                    PluginAntiSenseRNA p = PluginSampleDialog.model.getAntiSenseRNA(id);
                    if (p != null) {
                        PluginSpeciesNodeDialog.this.textName.setText(p.getName());
                        PluginSpeciesNodeDialog.this.textName.setEditable(false);
                    } else {
                        System.out.println("<Illegal asrna ID.> = " + id);
                    }
                } else {
                    PluginSpeciesNodeDialog.this.textName.setEditable(true);
                }
            }
        });
        this.labelHomodimer = new JLabel("   Homodimer");
        this.getContentPane().add(this.labelHomodimer);
        this.textHomodimer = new JTextField();
        this.getContentPane().add(this.textHomodimer);
        this.labelHypothetical = new JLabel("   Hypothetical");
        this.getContentPane().add(this.labelHypothetical);
        this.checkHypothetical = new JCheckBox();
        this.getContentPane().add(this.checkHypothetical);
        this.labelX = new JLabel("   x");
        this.getContentPane().add(this.labelX);
        this.textX = new JTextField();
        this.getContentPane().add(this.textX);
        this.labelY = new JLabel("   y");
        this.getContentPane().add(this.labelY);
        this.textY = new JTextField();
        this.getContentPane().add(this.textY);
        this.labelWidth = new JLabel("   width");
        this.getContentPane().add(this.labelWidth);
        this.textWidth = new JTextField();
        this.getContentPane().add(this.textWidth);
        this.labelHeight = new JLabel("   height");
        this.getContentPane().add(this.labelHeight);
        this.textHeight = new JTextField();
        this.getContentPane().add(this.textHeight);
        this.labelColor = new JLabel("   Color");
        this.getContentPane().add(this.labelColor);
        this.textColor = new JTextField();
        this.getContentPane().add(this.textColor);
        this.labelLineWidth = new JLabel("   LineWidth");
        this.getContentPane().add(this.labelLineWidth);
        this.textLineWidth = new JTextField();
        this.getContentPane().add(this.textLineWidth);
        this.buttonOK = new JButton("Update");
        this.buttonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PluginSpeciesNodeDialog.this.setAliasData();
                PluginSampleDialog.plug.notifySBaseChanged((PluginSBase)PluginSpeciesNodeDialog.this.alias);
            }
        });
        this.getContentPane().add(this.buttonOK);
        this.buttonClose = new JButton("Close");
        this.buttonClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PluginSpeciesNodeDialog.this.setVisible(false);
                PluginSpeciesNodeDialog.this.dispose();
            }
        });
        this.getContentPane().add(this.buttonClose);
        this.setVisible(true);
    }

    private void setDataDialog() {
        this.textSpeciesId.setText(this.alias.getSpecies().getId());
        this.textName.setText(this.alias.getName());
        this.comboExtensionType.setSelectedItem(this.alias.getType());
        this.comboExtensionID.removeAllItems();
        if (this.comboExtensionType != null && this.comboExtensionType.getSelectedItem() != null) {
            if (((String)this.comboExtensionType.getSelectedItem()).equals("PROTEIN")) {
                String[] item = this.getProteinData();
                int i = 0;
                while (i < item.length) {
                    this.comboExtensionID.addItem(item[i]);
                    ++i;
                }
                this.comboExtensionID.setSelectedItem(this.alias.getExtensionId());
                this.comboExtensionID.updateUI();
            } else if (((String)this.comboExtensionType.getSelectedItem()).equals("GENE")) {
                String[] item = this.getGeneData();
                int i = 0;
                while (i < item.length) {
                    this.comboExtensionID.addItem(item[i]);
                    ++i;
                }
                this.comboExtensionID.setSelectedItem(this.alias.getExtensionId());
                this.comboExtensionID.updateUI();
            } else if (((String)this.comboExtensionType.getSelectedItem()).equals("RNA")) {
                String[] item = this.getRNAData();
                int i = 0;
                while (i < item.length) {
                    this.comboExtensionID.addItem(item[i]);
                    ++i;
                }
                this.comboExtensionID.setSelectedItem(this.alias.getExtensionId());
                this.comboExtensionID.updateUI();
            } else if (((String)this.comboExtensionType.getSelectedItem()).equals("ANTISENSE_RNA")) {
                String[] item = this.getasRNAData();
                int i = 0;
                while (i < item.length) {
                    this.comboExtensionID.addItem(item[i]);
                    ++i;
                }
                this.comboExtensionID.setSelectedItem(this.alias.getExtensionId());
                this.comboExtensionID.updateUI();
            }
        }
        this.textHomodimer.setText(String.valueOf(this.alias.getHomodimer()));
        this.checkHypothetical.setSelected(this.alias.getHypothetical());
        this.textX.setText(String.valueOf(this.alias.getX()));
        this.textY.setText(String.valueOf(this.alias.getY()));
        this.textWidth.setText(String.valueOf(this.alias.getWidth()));
        this.textHeight.setText(String.valueOf(this.alias.getHeight()));
        this.textColor.setText(String.valueOf(this.alias.getColor()));
        this.textLineWidth.setText(String.valueOf(this.alias.getFrameLineWidth()));
    }

    private void setAliasData() {
        this.alias.setType((String)this.comboExtensionType.getSelectedItem());
        System.out.println("(String)comboExtensionType.getSelectedItem() = " + this.alias.getType());
        this.alias.setName(this.textName.getText());
        this.alias.setHomodimer(Integer.parseInt(this.textHomodimer.getText()));
        this.alias.setHypothetical(this.checkHypothetical.isSelected());
        this.alias.setFramePosition(Double.parseDouble(this.textX.getText()), Double.parseDouble(this.textY.getText()));
        this.alias.setFrameSize(Double.parseDouble(this.textWidth.getText()), Double.parseDouble(this.textHeight.getText()));
        this.alias.setFrameLineWidth(Double.parseDouble(this.textLineWidth.getText()));
        if (this.alias.getType().equals("PROTEIN")) {
            PluginProtein pro = PluginSampleDialog.model.getProtein((String)this.comboExtensionID.getSelectedItem());
            if (pro != null) {
                this.alias.setProtein(pro);
            }
        } else if (this.alias.getType().equals("GENE")) {
            PluginGene ge = PluginSampleDialog.model.getGene((String)this.comboExtensionID.getSelectedItem());
            if (ge != null) {
                this.alias.setGene(ge);
            }
        } else if (this.alias.getType().equals("RNA")) {
            PluginRNA rna = PluginSampleDialog.model.getRNA((String)this.comboExtensionID.getSelectedItem());
            if (rna != null) {
                this.alias.setRNA(rna);
            }
            System.out.println("(String)comboExtensionID.getSelectedItem() = " + (String)this.comboExtensionID.getSelectedItem());
        } else if (this.alias.getType().equals("ANTISENSE_RNA")) {
            PluginAntiSenseRNA as = PluginSampleDialog.model.getAntiSenseRNA((String)this.comboExtensionID.getSelectedItem());
            if (as != null) {
                this.alias.setAntiSenseRNA(as);
            }
        } else {
            this.alias.setProtein(null);
            this.alias.setGene(null);
            this.alias.setRNA(null);
            this.alias.setAntiSenseRNA(null);
        }
        this.alias.setColor(Color.BLUE);
        PluginModification m = new PluginModification();
        m.setResidue("rs100");
        m.setState("phosphorylated");
        this.alias.getModifications().append((PluginSBase)m);
        PluginSampleDialog.updateTable();
    }
}

