/*
 * Decompiled with CFR 0.152.
 */
package plugin.sample2.dialog.editdialog;

import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import jp.sbi.celldesigner.plugin.PluginSBase;
import jp.sbi.celldesigner.plugin.PluginSpecies;
import plugin.sample2.dialog.editdialog.PluginSBaseDialog;

public class PluginSpeciesDialog
extends PluginSBaseDialog {
    private JTextField idTextField;
    private JTextField nameTextField;
    private JTextField compartmentTextField;
    private JRadioButton amountRadioButton;
    private JRadioButton concentrationRadioButton;
    private JTextField initialQuantityTextField;
    private JTextField substanceUnitsTextField;
    private JTextField spatialSizeUnitsTextField;
    private JRadioButton hasOnlySubstanceUnitsRadio;
    private JRadioButton hasOnlySubstanceUnitsFalseRadio;
    private JRadioButton boundaryConditionRadio;
    private JRadioButton boundaryConditionFalseRadio;
    private JTextField chargeTextField;
    private JRadioButton constantRadio;
    private JRadioButton constantFalseRadio;

    public PluginSpeciesDialog(PluginSpecies editSpecies) {
        this.editingSBase = editSpecies;
        this.setDialogFromObject(this.editingSBase);
        this.setVisible(true);
    }

    protected JPanel createDialogPanel() {
        JLabel idLabel = new JLabel("id");
        this.idTextField = new JTextField();
        this.idTextField.setEditable(true);
        JLabel nameLabel = new JLabel("name");
        this.nameTextField = new JTextField();
        this.nameTextField.setEditable(true);
        JLabel compartmentLabel = new JLabel("compartment");
        this.compartmentTextField = new JTextField();
        this.compartmentTextField.setEditable(true);
        JLabel initialQuantityLabel = new JLabel("initial...");
        JPanel initialQuantityPanel = new JPanel(null);
        initialQuantityPanel.setOpaque(true);
        initialQuantityPanel.setBorder(BorderFactory.createEtchedBorder(1));
        this.amountRadioButton = new JRadioButton("Amount");
        this.concentrationRadioButton = new JRadioButton("Concentration");
        ButtonGroup quantityTypeGroup = new ButtonGroup();
        quantityTypeGroup.add(this.amountRadioButton);
        quantityTypeGroup.add(this.concentrationRadioButton);
        this.initialQuantityTextField = new JTextField();
        this.initialQuantityTextField.setEditable(true);
        JLabel substanceUnitsLabel = new JLabel("substanceUnits");
        this.substanceUnitsTextField = new JTextField();
        this.substanceUnitsTextField.setEditable(true);
        JLabel spatialSizeUnitsLabel = new JLabel("spatialSizeUnits");
        this.spatialSizeUnitsTextField = new JTextField();
        this.spatialSizeUnitsTextField.setEditable(true);
        JLabel hasOnlySubstanceUnitsLabel = new JLabel("hasOnlySubstanceUnits");
        this.hasOnlySubstanceUnitsRadio = new JRadioButton("true");
        this.hasOnlySubstanceUnitsFalseRadio = new JRadioButton("false");
        ButtonGroup onlySubstanceUnitsGroup = new ButtonGroup();
        onlySubstanceUnitsGroup.add(this.hasOnlySubstanceUnitsRadio);
        onlySubstanceUnitsGroup.add(this.hasOnlySubstanceUnitsFalseRadio);
        JLabel boundaryConditionLabel = new JLabel("boundaryCondition");
        this.boundaryConditionRadio = new JRadioButton("true");
        this.boundaryConditionFalseRadio = new JRadioButton("false");
        ButtonGroup boundaryConditionGroup = new ButtonGroup();
        boundaryConditionGroup.add(this.boundaryConditionRadio);
        boundaryConditionGroup.add(this.boundaryConditionFalseRadio);
        JLabel chargeLabel = new JLabel("charge");
        this.chargeTextField = new JTextField();
        this.chargeTextField.setEditable(true);
        JLabel constantLabel = new JLabel("constant");
        this.constantRadio = new JRadioButton("true");
        this.constantFalseRadio = new JRadioButton("false");
        ButtonGroup constantsGroup = new ButtonGroup();
        constantsGroup.add(this.constantRadio);
        constantsGroup.add(this.constantFalseRadio);
        this.LABEL_WIDTH = 120;
        this.TEXT_WIDTH = 200;
        this.setLayoutConstants();
        int x1 = this.HORIZONTAL_MARGIN;
        int x2 = this.TEXT_POSITION_X;
        int yline = this.VERTICAL_MARGIN;
        idLabel.setBounds(x1, yline, this.LABEL_WIDTH, this.LINE_HEIGHT);
        this.idTextField.setBounds(x2, yline, this.TEXT_WIDTH, this.LINE_HEIGHT);
        nameLabel.setBounds(x1, yline += this.BASELINE_SKIP, this.LABEL_WIDTH, this.LINE_HEIGHT);
        this.nameTextField.setBounds(x2, yline, this.TEXT_WIDTH, this.LINE_HEIGHT);
        compartmentLabel.setBounds(x1, yline += this.BASELINE_SKIP, this.LABEL_WIDTH, this.LINE_HEIGHT);
        this.compartmentTextField.setBounds(x2, yline, this.TEXT_WIDTH, this.LINE_HEIGHT);
        initialQuantityLabel.setBounds(x1, yline += this.BASELINE_SKIP, this.LABEL_WIDTH, this.LINE_HEIGHT);
        int margin = 4;
        initialQuantityPanel.setBounds(x2, yline, this.TEXT_WIDTH, this.BASELINE_SKIP + this.LINE_HEIGHT + 8);
        this.amountRadioButton.setBounds(4, 4, this.BUTTON_WIDTH, this.LINE_HEIGHT);
        this.concentrationRadioButton.setBounds(4 + this.BUTTON_WIDTH + this.BUTTON_MARGIN, 4, this.BUTTON_WIDTH + 20, this.LINE_HEIGHT);
        this.initialQuantityTextField.setBounds(4, 4 + this.BASELINE_SKIP, this.TEXT_WIDTH - 8, this.LINE_HEIGHT);
        substanceUnitsLabel.setBounds(x1, yline += 2 * this.BASELINE_SKIP + 8, this.LABEL_WIDTH, this.LINE_HEIGHT);
        this.substanceUnitsTextField.setBounds(x2, yline, this.TEXT_WIDTH, this.LINE_HEIGHT);
        spatialSizeUnitsLabel.setBounds(x1, yline += this.BASELINE_SKIP, this.LABEL_WIDTH, this.LINE_HEIGHT);
        this.spatialSizeUnitsTextField.setBounds(x2, yline, this.TEXT_WIDTH, this.LINE_HEIGHT);
        hasOnlySubstanceUnitsLabel.setBounds(x1, yline += this.BASELINE_SKIP, this.LABEL_WIDTH, this.LINE_HEIGHT);
        this.hasOnlySubstanceUnitsRadio.setBounds(x2, yline, this.BUTTON_WIDTH, this.LINE_HEIGHT);
        this.hasOnlySubstanceUnitsFalseRadio.setBounds(x2 + this.BUTTON_WIDTH + this.BUTTON_MARGIN, yline, this.BUTTON_WIDTH, this.LINE_HEIGHT);
        boundaryConditionLabel.setBounds(x1, yline += this.BASELINE_SKIP, this.LABEL_WIDTH, this.LINE_HEIGHT);
        this.boundaryConditionRadio.setBounds(x2, yline, this.BUTTON_WIDTH, this.LINE_HEIGHT);
        this.boundaryConditionFalseRadio.setBounds(x2 + this.BUTTON_WIDTH + this.BUTTON_MARGIN, yline, this.BUTTON_WIDTH, this.LINE_HEIGHT);
        chargeLabel.setBounds(x1, yline += this.BASELINE_SKIP, this.LABEL_WIDTH, this.LINE_HEIGHT);
        this.chargeTextField.setBounds(x2, yline, this.TEXT_WIDTH, this.LINE_HEIGHT);
        constantLabel.setBounds(x1, yline += this.BASELINE_SKIP, this.LABEL_WIDTH, this.LINE_HEIGHT);
        this.constantRadio.setBounds(x2, yline, this.BUTTON_WIDTH, this.LINE_HEIGHT);
        this.constantFalseRadio.setBounds(x2 + this.BUTTON_WIDTH + this.BUTTON_MARGIN, yline, this.BUTTON_WIDTH, this.LINE_HEIGHT);
        this.BUTTON_POSITION_Y = yline += this.BASELINE_SKIP;
        this.setDefaultButtonsLayout();
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(null);
        this.mainPanel.add((Component)idLabel, null);
        this.mainPanel.add((Component)this.idTextField, null);
        this.mainPanel.add((Component)nameLabel, null);
        this.mainPanel.add((Component)this.nameTextField, null);
        this.mainPanel.add((Component)compartmentLabel, null);
        this.mainPanel.add((Component)this.compartmentTextField, null);
        this.mainPanel.add((Component)initialQuantityLabel, null);
        this.mainPanel.add((Component)initialQuantityPanel, null);
        initialQuantityPanel.add((Component)this.amountRadioButton, null);
        initialQuantityPanel.add((Component)this.concentrationRadioButton, null);
        initialQuantityPanel.add((Component)this.initialQuantityTextField, null);
        this.mainPanel.add((Component)substanceUnitsLabel, null);
        this.mainPanel.add((Component)this.substanceUnitsTextField, null);
        this.mainPanel.add((Component)spatialSizeUnitsLabel, null);
        this.mainPanel.add((Component)this.spatialSizeUnitsTextField, null);
        this.mainPanel.add((Component)hasOnlySubstanceUnitsLabel, null);
        this.mainPanel.add((Component)this.hasOnlySubstanceUnitsRadio, null);
        this.mainPanel.add((Component)this.hasOnlySubstanceUnitsFalseRadio, null);
        this.mainPanel.add((Component)boundaryConditionLabel, null);
        this.mainPanel.add((Component)this.boundaryConditionRadio, null);
        this.mainPanel.add((Component)this.boundaryConditionFalseRadio, null);
        this.mainPanel.add((Component)chargeLabel, null);
        this.mainPanel.add((Component)this.chargeTextField, null);
        this.mainPanel.add((Component)constantLabel, null);
        this.mainPanel.add((Component)this.constantRadio, null);
        this.mainPanel.add((Component)this.constantFalseRadio, null);
        this.addDefaultButtonsToPanel();
        return this.mainPanel;
    }

    protected void setDialogFromObject(PluginSBase sbase) {
        double initialQuantity;
        String s1;
        if (sbase == null) {
            return;
        }
        PluginSpecies species = (PluginSpecies)sbase;
        String id = species.getId();
        this.idTextField.setText(id);
        this.idTextField.setCaretPosition(id.length());
        String name = species.getName();
        this.nameTextField.setText(name);
        this.nameTextField.setCaretPosition(name.length());
        String compartment = species.getCompartment();
        this.compartmentTextField.setText(compartment);
        this.compartmentTextField.setCaretPosition(compartment.length());
        if (species.isSetInitialAmount()) {
            this.amountRadioButton.setSelected(true);
            s1 = "";
            initialQuantity = species.getInitialAmount();
            s1 = Double.toString(initialQuantity);
            this.initialQuantityTextField.setText(s1);
            this.initialQuantityTextField.setCaretPosition(s1.length());
        } else if (species.isSetInitialConcentration()) {
            this.concentrationRadioButton.setSelected(true);
            s1 = "";
            initialQuantity = species.getInitialConcentration();
            s1 = Double.toString(initialQuantity);
            this.initialQuantityTextField.setText(s1);
            this.initialQuantityTextField.setCaretPosition(s1.length());
        } else {
            this.amountRadioButton.setSelected(true);
            s1 = "";
            this.initialQuantityTextField.setText(s1);
            this.initialQuantityTextField.setCaretPosition(s1.length());
        }
        String substanceUnits = species.getSubstanceUnits();
        this.substanceUnitsTextField.setText(substanceUnits);
        this.substanceUnitsTextField.setCaretPosition(substanceUnits.length());
        String spatialSizeUnits = species.getSpatialSizeUnits();
        this.spatialSizeUnitsTextField.setText(spatialSizeUnits);
        this.spatialSizeUnitsTextField.setCaretPosition(spatialSizeUnits.length());
        boolean hasOnly = species.getHasOnlySubstanceUnits();
        this.hasOnlySubstanceUnitsRadio.setSelected(hasOnly);
        this.hasOnlySubstanceUnitsFalseRadio.setSelected(!hasOnly);
        boolean b1 = species.getBoundaryCondition();
        this.boundaryConditionRadio.setSelected(b1);
        this.boundaryConditionFalseRadio.setSelected(!b1);
        int charge = species.getCharge();
        String s2 = Integer.toString(charge);
        this.chargeTextField.setText(s2);
        this.chargeTextField.setCaretPosition(s2.length());
        boolean b2 = species.getConstant();
        this.constantRadio.setSelected(b2);
        this.constantFalseRadio.setSelected(!b2);
    }

    protected void updateObject() {
    }
}

