/*
 * Decompiled with CFR 0.152.
 */
package plugin.sample2.dialog.editdialog;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import jp.sbi.celldesigner.plugin.PluginKineticLaw;
import jp.sbi.celldesigner.plugin.PluginListOf;
import jp.sbi.celldesigner.plugin.PluginModifierSpeciesReference;
import jp.sbi.celldesigner.plugin.PluginReaction;
import jp.sbi.celldesigner.plugin.PluginSBase;
import jp.sbi.celldesigner.plugin.PluginSpeciesReference;
import plugin.sample2.dialog.PluginSampleDialog;
import plugin.sample2.dialog.editdialog.PluginKineticLawDialog;
import plugin.sample2.dialog.editdialog.PluginSBaseDialog;
import plugin.sample2.table.ReferenceViewingTable;

public class PluginReactionDialog
extends PluginSBaseDialog {
    private JTextField idTextField;
    private JTextField nameTextField;
    private JRadioButton reversibleRadio;
    private JRadioButton reversibleFalseRadio;
    private JRadioButton fastRadio;
    private JRadioButton fastFalseRadio;
    private JButton reactantListDlgButton;
    private JButton productListDlgButton;
    private JButton modifierListDlgButton;
    private JTextArea kineticLawElementsTextArea;
    private JButton kineticLawCreateButton;
    private JButton kineticLawDeleteButton;
    private JFrame frame;
    public static JTabbedPane jTabbedPane;
    private boolean[] isFirstShowing;
    private boolean isKineticLawFirstShowing = true;
    private static String[] dialogClassName;
    private static String[] ListName;
    public static final int LIST_OF_REACTANTS = 0;
    public static final int LIST_OF_PRODUCTS = 1;
    public static final int LIST_OF_MODIFIERS = 2;
    public static final int SIZE_OF_LISTS = 3;
    public static final String REACTANTS = "Reactants";
    public static final String PRODUCTS = "Products";
    public static final String MODIFIERS = "Modifiers";
    private JButton buttonAdd;
    private JButton buttonRemove;

    static {
        dialogClassName = new String[]{"PluginSpeciesReferenceDialog", "PluginSpeciesReferenceDialog", "PluginModifierSpeciesReferenceDialog"};
        ListName = new String[]{"listOfReactants", "listOfProducts", "listOfModifiers"};
    }

    public PluginReactionDialog(PluginReaction re, boolean mode) {
        this.editingSBase = re;
        this.addmode = mode;
        this.initListDialogs();
        this.setDialogFromObject(this.editingSBase);
        this.setVisible(true);
    }

    private void initListDialogs() {
        PluginReaction re = (PluginReaction)this.editingSBase;
        JScrollPane panel1 = new JScrollPane();
        JScrollPane panel2 = new JScrollPane();
        JScrollPane panel3 = new JScrollPane();
        jTabbedPane = new JTabbedPane();
        panel1.getViewport().add(new ReferenceViewingTable(this.formatForTableData(re.getListOfReactants(), ListName[0]), ListName[0], re));
        panel2.getViewport().add(new ReferenceViewingTable(this.formatForTableData(re.getListOfProducts(), ListName[1]), ListName[1], re));
        panel3.getViewport().add(new ReferenceViewingTable(this.formatForTableData(re.getListOfModifiers(), ListName[2]), ListName[2], re));
        jTabbedPane.add(ListName[0], panel1);
        jTabbedPane.add(ListName[1], panel2);
        jTabbedPane.add(ListName[2], panel3);
        jTabbedPane.setBorder(BorderFactory.createEtchedBorder(1));
        jTabbedPane.setBounds(new Rectangle(10, 118, 440, 170));
        jTabbedPane.setSelectedIndex(0);
        this.mainPanel.add((Component)jTabbedPane, null);
    }

    private void updatePanel() {
        this.mainPanel.remove(jTabbedPane);
        jTabbedPane = new JTabbedPane();
        this.initListDialogs();
    }

    protected Object[][] formatForTableData(PluginListOf listOfSBase, String tabName) {
        ArrayList newData = new ArrayList();
        if (listOfSBase == null) {
            return new Object[0][0];
        }
        int i = 0;
        while (i < listOfSBase.size()) {
            PluginSpeciesReference species;
            ArrayList<String> rowData = new ArrayList<String>();
            if (tabName.equals(ListName[0]) || tabName.equals(ListName[1])) {
                species = (PluginSpeciesReference)listOfSBase.get(i);
                rowData.add(species.getSpecies());
                rowData.add(species.getAlias().getAliasID());
                rowData.add(String.valueOf(species.getStoichiometry()));
                rowData.add((String)species.getStoichiometryMath());
                newData.add(rowData);
            } else if (tabName.equals(ListName[2])) {
                species = (PluginModifierSpeciesReference)listOfSBase.get(i);
                rowData.add(species.getSpecies());
                rowData.add(species.getAlias().getAliasID());
                newData.add(rowData);
            }
            ++i;
        }
        Object[][] arrayData = new Object[newData.size()][1];
        int i2 = 0;
        while (i2 < newData.size()) {
            ArrayList data = (ArrayList)newData.get(i2);
            arrayData[i2] = data.toArray();
            ++i2;
        }
        return arrayData;
    }

    protected JPanel createDialogPanel() {
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(null);
        JLabel idLabel = new JLabel("id");
        idLabel.setBounds(new Rectangle(10, 10, 60, 20));
        this.mainPanel.add((Component)idLabel, null);
        this.idTextField = new JTextField();
        this.idTextField.setBounds(new Rectangle(80, 10, 200, 20));
        this.idTextField.setEditable(true);
        this.mainPanel.add((Component)this.idTextField, null);
        JLabel nameLabel = new JLabel("name");
        nameLabel.setBounds(new Rectangle(10, 34, 60, 20));
        this.mainPanel.add((Component)nameLabel, null);
        this.nameTextField = new JTextField();
        this.nameTextField.setBounds(new Rectangle(80, 34, 200, 20));
        this.nameTextField.setEditable(true);
        this.mainPanel.add((Component)this.nameTextField, null);
        JLabel reversibleLabel = new JLabel("reversible");
        reversibleLabel.setBounds(new Rectangle(10, 58, 120, 20));
        this.mainPanel.add((Component)reversibleLabel, null);
        this.reversibleRadio = new JRadioButton("true");
        this.reversibleRadio.setBounds(new Rectangle(80, 58, 60, 20));
        this.mainPanel.add((Component)this.reversibleRadio, null);
        this.reversibleFalseRadio = new JRadioButton("false");
        this.reversibleFalseRadio.setBounds(new Rectangle(150, 58, 90, 20));
        this.mainPanel.add((Component)this.reversibleFalseRadio, null);
        ButtonGroup bg1 = new ButtonGroup();
        bg1.add(this.reversibleRadio);
        bg1.add(this.reversibleFalseRadio);
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (PluginReactionDialog.this.reversibleRadio.hasFocus() || PluginReactionDialog.this.reversibleFalseRadio.hasFocus()) {
                    switch (e.getKeyCode()) {
                        case 39: {
                            PluginReactionDialog.this.reversibleFalseRadio.setSelected(true);
                            PluginReactionDialog.this.reversibleFalseRadio.grabFocus();
                            break;
                        }
                        case 37: {
                            PluginReactionDialog.this.reversibleRadio.setSelected(true);
                            PluginReactionDialog.this.reversibleRadio.grabFocus();
                        }
                    }
                }
            }
        });
        JLabel fastLabel = new JLabel("fast");
        fastLabel.setBounds(new Rectangle(10, 82, 120, 20));
        this.mainPanel.add((Component)fastLabel, null);
        this.fastRadio = new JRadioButton("true");
        this.fastRadio.setBounds(new Rectangle(80, 82, 60, 20));
        this.mainPanel.add((Component)this.fastRadio, null);
        this.fastFalseRadio = new JRadioButton("false");
        this.fastFalseRadio.setBounds(new Rectangle(150, 82, 90, 20));
        this.mainPanel.add((Component)this.fastFalseRadio, null);
        this.buttonAdd = new JButton("ADD");
        this.buttonAdd.setBounds(new Rectangle(280, 82, 80, 20));
        this.buttonAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PluginReaction re = (PluginReaction)PluginReactionDialog.this.editingSBase;
                if (jTabbedPane.getSelectedIndex() == 0) {
                    PluginSpeciesReference ref = new PluginSpeciesReference(re, PluginSampleDialog.model.getSpecies(0).getSpeciesAlias(0));
                    re.addReactant(ref);
                    PluginSampleDialog.plug.notifySBaseAdded((PluginSBase)ref);
                } else if (jTabbedPane.getSelectedIndex() == 1) {
                    PluginSpeciesReference ref = new PluginSpeciesReference(re, PluginSampleDialog.model.getSpecies(0).getSpeciesAlias(0));
                    re.addProduct(ref);
                    PluginSampleDialog.plug.notifySBaseAdded((PluginSBase)ref);
                } else if (jTabbedPane.getSelectedIndex() == 2) {
                    PluginModifierSpeciesReference ref = new PluginModifierSpeciesReference(re, PluginSampleDialog.model.getSpecies(0).getSpeciesAlias(0));
                    ref.setModificationType("TRANSPORT");
                    re.addModifier(ref);
                    PluginSampleDialog.plug.notifySBaseAdded((PluginSBase)ref);
                }
                PluginReactionDialog.this.updatePanel();
                jTabbedPane.updateUI();
            }
        });
        this.mainPanel.add((Component)this.buttonAdd, null);
        this.buttonRemove = new JButton("REMOVE");
        this.buttonRemove.setBounds(new Rectangle(360, 82, 80, 20));
        this.buttonRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PluginReaction re = (PluginReaction)PluginReactionDialog.this.editingSBase;
                if (jTabbedPane.getSelectedIndex() == 0) {
                    JScrollPane pane = (JScrollPane)jTabbedPane.getSelectedComponent();
                    JTable table = (JTable)pane.getViewport().getComponent(0);
                    PluginSpeciesReference ref = re.getReactant(table.getSelectedRow());
                    re.removeReactant(table.getSelectedRow());
                    PluginSampleDialog.plug.notifySBaseDeleted((PluginSBase)ref);
                } else if (jTabbedPane.getSelectedIndex() == 1) {
                    JScrollPane pane = (JScrollPane)jTabbedPane.getSelectedComponent();
                    JTable table = (JTable)pane.getViewport().getComponent(0);
                    PluginSpeciesReference ref = re.getProduct(table.getSelectedRow());
                    re.removeProduct(table.getSelectedRow());
                    PluginSampleDialog.plug.notifySBaseDeleted((PluginSBase)ref);
                } else if (jTabbedPane.getSelectedIndex() == 2) {
                    JScrollPane pane = (JScrollPane)jTabbedPane.getSelectedComponent();
                    JTable table = (JTable)pane.getViewport().getComponent(0);
                    PluginModifierSpeciesReference ref = re.getModifier(table.getSelectedRow());
                    re.removeModifier(table.getSelectedRow());
                    PluginSampleDialog.plug.notifySBaseDeleted((PluginSBase)ref);
                }
                PluginReactionDialog.this.updatePanel();
                jTabbedPane.updateUI();
            }
        });
        this.mainPanel.add((Component)this.buttonRemove, null);
        ButtonGroup bg2 = new ButtonGroup();
        bg2.add(this.fastRadio);
        bg2.add(this.fastFalseRadio);
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (PluginReactionDialog.this.fastRadio.hasFocus() || PluginReactionDialog.this.fastFalseRadio.hasFocus()) {
                    switch (e.getKeyCode()) {
                        case 39: {
                            PluginReactionDialog.this.fastFalseRadio.setSelected(true);
                            PluginReactionDialog.this.fastFalseRadio.grabFocus();
                            break;
                        }
                        case 37: {
                            PluginReactionDialog.this.fastRadio.setSelected(true);
                            PluginReactionDialog.this.fastRadio.grabFocus();
                        }
                    }
                }
            }
        });
        JLabel kineticLawLabel = new JLabel("KineticLaw");
        kineticLawLabel.setBounds(new Rectangle(10, 300, 160, 20));
        this.mainPanel.add((Component)kineticLawLabel, null);
        this.kineticLawCreateButton = new JButton("Create");
        this.kineticLawCreateButton.setMnemonic(67);
        this.kineticLawCreateButton.setBounds(new Rectangle(180, 300, 100, 20));
        this.kineticLawCreateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PluginReactionDialog.this.CreateButton_actionPerformed();
            }
        });
        this.kineticLawCreateButton.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                PluginReactionDialog.this.rootPane.setDefaultButton(PluginReactionDialog.this.kineticLawCreateButton);
            }
        });
        this.mainPanel.add((Component)this.kineticLawCreateButton, null);
        this.kineticLawDeleteButton = new JButton("Delete"){

            public boolean isFocusTraversable() {
                return false;
            }
        };
        this.kineticLawElementsTextArea = new JTextArea(""){

            public boolean isManagingFocus() {
                return false;
            }

            public boolean isFocusTraversable() {
                return false;
            }
        };
        this.LABEL_WIDTH = 60;
        this.TEXT_WIDTH = 371;
        this.setLayoutConstants();
        this.BUTTON_POSITION_Y = 100 + 10 * this.BASELINE_SKIP;
        this.setDefaultButtonsLayout();
        this.addDefaultButtonsToPanel();
        return this.mainPanel;
    }

    private void CreateButton_actionPerformed() {
        PluginReaction reaction = (PluginReaction)this.editingSBase;
        if (reaction.getKineticLaw() == null) {
            PluginKineticLaw law = new PluginKineticLaw(reaction);
            reaction.setKineticLaw(law);
        }
        PluginKineticLawDialog kineticLawDialog = new PluginKineticLawDialog(reaction.getKineticLaw());
    }

    protected void setDialogFromObject(PluginSBase sbase) {
        if (sbase == null) {
            return;
        }
        PluginReaction reaction = (PluginReaction)sbase;
        String id = reaction.getId();
        this.idTextField.setText(id);
        this.idTextField.setCaretPosition(id.length());
        this.idTextField.setEditable(false);
        String name = reaction.getName();
        this.nameTextField.setText(name);
        this.nameTextField.setCaretPosition(name.length());
        boolean b1 = reaction.getReversible();
        this.reversibleRadio.setSelected(b1);
        this.reversibleFalseRadio.setSelected(!b1);
        boolean b2 = reaction.getFast();
        this.fastRadio.setSelected(b2);
        this.fastFalseRadio.setSelected(!b2);
    }

    protected void updateObject() {
        PluginReaction reaction = (PluginReaction)this.editingSBase;
        reaction.setName(this.nameTextField.getText());
        reaction.setFast(this.fastRadio.isSelected());
        reaction.setReversible(this.reversibleRadio.isSelected());
    }
}

