/*
 * Decompiled with CFR 0.152.
 */
package plugin.sample2.dialog.editdialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jp.sbi.celldesigner.plugin.PluginListOf;
import jp.sbi.celldesigner.plugin.PluginModificationResidue;
import jp.sbi.celldesigner.plugin.PluginProtein;
import jp.sbi.celldesigner.plugin.PluginSBase;
import plugin.sample2.dialog.PluginSampleDialog;
import plugin.sample2.table.ProteinViewingTable;

public class PluginProteinDialog
extends JDialog {
    public PluginProtein protein;
    ProteinViewingTable table;
    JScrollPane sc;

    public PluginProteinDialog(PluginSBase alias) {
        this.protein = (PluginProtein)alias;
        this.init();
    }

    private void init() {
        this.setSize(400, 400);
        this.setTitle("ListOfPluginResidue");
        this.getContentPane().setLayout(new BorderLayout());
        this.sc = new JScrollPane();
        this.table = new ProteinViewingTable(this.formatForTableData(this.protein.getListOfPluginResidue()), this);
        this.sc.getViewport().add(this.table);
        this.getContentPane().add((Component)this.sc, "Center");
        JPanel innerPanel = new JPanel();
        JButton buttonAdd = new JButton("Add");
        buttonAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PluginProteinDialog.this.add();
            }
        });
        innerPanel.add(buttonAdd);
        JButton buttonDel = new JButton("Del");
        buttonDel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PluginProteinDialog.this.del();
            }
        });
        innerPanel.add(buttonDel);
        this.getContentPane().add((Component)innerPanel, "South");
        this.setVisible(true);
    }

    protected Object[][] formatForTableData(PluginListOf listOfSBase) {
        ArrayList newData = new ArrayList();
        if (listOfSBase == null) {
            return new Object[0][0];
        }
        int i = 0;
        while (i < listOfSBase.size()) {
            ArrayList<String> rowData = new ArrayList<String>();
            PluginModificationResidue species = (PluginModificationResidue)listOfSBase.get(i);
            rowData.add(species.getId());
            rowData.add(species.getName());
            rowData.add(species.getSide());
            rowData.add(Double.toString(species.getAngle()));
            newData.add(rowData);
            ++i;
        }
        Object[][] arrayData = new Object[newData.size()][1];
        int i2 = 0;
        while (i2 < newData.size()) {
            ArrayList data = (ArrayList)newData.get(i2);
            arrayData[i2] = data.toArray();
            ++i2;
        }
        return arrayData;
    }

    void add() {
        PluginModificationResidue s = new PluginModificationResidue(this.protein);
        this.protein.addPluginModificationResidue(s);
        PluginSampleDialog.plug.notifySBaseChanged((PluginSBase)s);
        this.sc.getViewport().removeAll();
        this.table = new ProteinViewingTable(this.formatForTableData(this.protein.getListOfPluginResidue()), this);
        this.sc.getViewport().add(this.table);
    }

    void del() {
        PluginModificationResidue s = this.protein.getPluginModificationResidue(this.table.getSelectedRow());
        this.protein.removePluginModificationResidue(this.table.getSelectedRow());
        PluginSampleDialog.plug.notifySBaseDeleted((PluginSBase)s);
        this.sc.getViewport().removeAll();
        this.table = new ProteinViewingTable(this.formatForTableData(this.protein.getListOfPluginResidue()), this);
        this.sc.getViewport().add(this.table);
    }
}

