/*
 * Decompiled with CFR 0.152.
 */
package plugin.sample2.dialog.editdialog;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import jp.sbi.celldesigner.plugin.PluginKineticLaw;
import jp.sbi.celldesigner.plugin.PluginListOf;
import jp.sbi.celldesigner.plugin.PluginParameter;
import jp.sbi.celldesigner.plugin.PluginSBase;
import jp.sbi.sbml.util.MathEditPanel;
import plugin.sample2.dialog.PluginSampleDialog;
import plugin.sample2.dialog.editdialog.PluginSBaseDialog;
import plugin.sample2.table.ParameterViewingTable;

public class PluginKineticLawDialog
extends PluginSBaseDialog {
    private JTextField mathTextField;
    private JTextField timeUnitsTextField;
    private JTextField substanceUnitsTextField;
    private MathEditPanel mathPanel;
    private static String[] ListName = new String[]{"listOfParameters"};
    private JButton newButton;
    private JButton removeButton;
    JScrollPane panel;

    public PluginKineticLawDialog(PluginKineticLaw law) {
        this.editingSBase = law;
        this.initListPanelAndDialog();
        this.setDialogFromObject(this.editingSBase);
        this.setVisible(true);
    }

    protected JPanel createDialogPanel() {
        int y = 0;
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(null);
        int hmargin = 4;
        int h = this.BASELINE_SKIP - hmargin;
        JLabel formulaLabel = new JLabel("math");
        formulaLabel.setBounds(new Rectangle(10, y += 10, 60, h));
        this.mainPanel.add((Component)formulaLabel, null);
        this.mathPanel = new MathEditPanel();
        this.mainPanel.add((Component)this.mathPanel);
        int mpheight = this.mathPanel.createUI(300, this.LINE_HEIGHT, this.BASELINE_SKIP);
        this.mathPanel.setBounds(new Rectangle(110, y, 300, mpheight));
        this.mathTextField = this.mathPanel.getTextField();
        y += mpheight + this.BASELINE_SKIP - this.LINE_HEIGHT;
        JLabel timeUnitsLabel = new JLabel("timeUnits");
        timeUnitsLabel.setBounds(new Rectangle(10, y += mpheight + this.BASELINE_SKIP - this.LINE_HEIGHT, 60, h));
        this.mainPanel.add((Component)timeUnitsLabel, null);
        this.timeUnitsTextField = new JTextField();
        this.timeUnitsTextField.setBounds(new Rectangle(110, y, 300, h));
        this.timeUnitsTextField.setEditable(true);
        this.mainPanel.add((Component)this.timeUnitsTextField, null);
        JLabel substanceUnitsLabel = new JLabel("substanceUnits");
        substanceUnitsLabel.setBounds(new Rectangle(10, y += h + hmargin, 100, h));
        this.mainPanel.add((Component)substanceUnitsLabel, null);
        this.substanceUnitsTextField = new JTextField();
        this.substanceUnitsTextField.setBounds(new Rectangle(110, y, 300, h));
        this.substanceUnitsTextField.setEditable(true);
        this.mainPanel.add((Component)this.substanceUnitsTextField, null);
        JLabel listOfParametersLabel = new JLabel("listOfParameters");
        listOfParametersLabel.setBounds(new Rectangle(10, y += h + hmargin, 160, h));
        this.mainPanel.add((Component)listOfParametersLabel, null);
        this.newButton = new JButton("NEW");
        this.newButton.setBounds(new Rectangle(120, y, 80, h));
        this.newButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PluginKineticLaw law = (PluginKineticLaw)PluginKineticLawDialog.this.editingSBase;
                PluginParameter sbase = new PluginParameter(law);
                sbase.setId("test1");
                law.addParameter(sbase);
                PluginKineticLawDialog.this.updatePanel();
                PluginSampleDialog.plug.notifySBaseAdded((PluginSBase)sbase);
            }
        });
        this.removeButton = new JButton("REMOVE");
        this.removeButton.setBounds(new Rectangle(220, y, 80, h));
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JTable table = (JTable)PluginKineticLawDialog.this.panel.getViewport().getComponent(0);
                PluginKineticLaw law = (PluginKineticLaw)PluginKineticLawDialog.this.editingSBase;
                PluginParameter sbase = law.getParameter(table.getSelectedRow());
                law.removeParameter(table.getSelectedRow());
                PluginKineticLawDialog.this.updatePanel();
                PluginSampleDialog.plug.notifySBaseDeleted((PluginSBase)sbase);
            }
        });
        this.mainPanel.add((Component)this.newButton, null);
        this.mainPanel.add((Component)this.removeButton, null);
        y += this.BASELINE_SKIP;
        this.LABEL_WIDTH = 90;
        this.TEXT_WIDTH = 300;
        this.setLayoutConstants();
        this.BUTTON_POSITION_Y = y += 200 + this.BASELINE_SKIP - this.LINE_HEIGHT;
        this.setDefaultButtonsLayout();
        this.addDefaultButtonsToPanel();
        return this.mainPanel;
    }

    private void initListPanelAndDialog() {
        this.panel = new JScrollPane();
        int y = 0;
        y += 10;
        int hmargin = 4;
        int h = this.BASELINE_SKIP - hmargin;
        int mpheight = this.mathPanel.createUI(300, this.LINE_HEIGHT, this.BASELINE_SKIP);
        y += mpheight + this.BASELINE_SKIP - this.LINE_HEIGHT;
        y += mpheight + this.BASELINE_SKIP - this.LINE_HEIGHT;
        y += h + hmargin;
        y += h + hmargin;
        this.panel.setBounds(new Rectangle(10, y += this.BASELINE_SKIP, 400, 200));
        PluginKineticLaw law = (PluginKineticLaw)this.editingSBase;
        this.panel.getViewport().add((Component)new ParameterViewingTable(this.formatForTableData(law.getListOfParameters(), ListName[0]), ListName[0], law), "Center");
        this.mainPanel.add(this.panel);
    }

    private void updatePanel() {
        this.mainPanel.remove(this.panel);
        this.initListPanelAndDialog();
    }

    protected Object[][] formatForTableData(PluginListOf listOfSBase, String tabName) {
        ArrayList newData = new ArrayList();
        if (listOfSBase == null) {
            return new Object[0][0];
        }
        int i = 0;
        while (i < listOfSBase.size()) {
            ArrayList<Object> rowData = new ArrayList<Object>();
            PluginParameter species = (PluginParameter)listOfSBase.get(i);
            rowData.add(species.getId());
            rowData.add(species.getName());
            rowData.add(String.valueOf(species.getValue()));
            rowData.add(species.getUnits());
            rowData.add(new Boolean(species.getConstant()));
            newData.add(rowData);
            ++i;
        }
        Object[][] arrayData = new Object[newData.size()][1];
        int i2 = 0;
        while (i2 < newData.size()) {
            ArrayList data = (ArrayList)newData.get(i2);
            arrayData[i2] = data.toArray();
            ++i2;
        }
        return arrayData;
    }

    protected void setDialogFromObject(PluginSBase sbase) {
        if (sbase == null) {
            return;
        }
        PluginKineticLaw kineticLaw = (PluginKineticLaw)sbase;
        String formula = kineticLaw.getFormula();
        this.mathTextField.setText(formula);
        this.mathTextField.setCaretPosition(formula.length());
        String timeUnits = kineticLaw.getTimeUnits();
        this.timeUnitsTextField.setText(timeUnits);
        this.timeUnitsTextField.setCaretPosition(timeUnits.length());
        String substanceUnits = kineticLaw.getSubstanceUnits();
        this.substanceUnitsTextField.setText(substanceUnits);
        this.substanceUnitsTextField.setCaretPosition(substanceUnits.length());
    }

    protected void updateObject() {
        PluginKineticLaw kineticLaw = (PluginKineticLaw)this.editingSBase;
        kineticLaw.setFormula(this.mathTextField.getText());
        kineticLaw.setSubstanceUnits(this.substanceUnitsTextField.getText());
        kineticLaw.setTimeUnits(this.timeUnitsTextField.getText());
    }
}

