/*
 * Decompiled with CFR 0.152.
 */
package plugin.sample2.dialog.editdialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jp.sbi.celldesigner.plugin.PluginAntiSenseRNA;
import jp.sbi.celldesigner.plugin.PluginGene;
import jp.sbi.celldesigner.plugin.PluginListOf;
import jp.sbi.celldesigner.plugin.PluginModificationRegion;
import jp.sbi.celldesigner.plugin.PluginRNA;
import jp.sbi.celldesigner.plugin.PluginSBase;
import plugin.sample2.dialog.PluginSampleDialog;
import plugin.sample2.table.GeneRNAViewingTable;

public class PluginGeneRNADialog
extends JDialog {
    public PluginSBase sbase;
    GeneRNAViewingTable table;
    JScrollPane sc;

    public PluginGeneRNADialog(PluginSBase alias) {
        this.sbase = alias;
        this.init();
    }

    private void init() {
        PluginGene g;
        this.setSize(400, 400);
        this.setTitle("ListOfPluginResidue");
        this.getContentPane().setLayout(new BorderLayout());
        this.sc = new JScrollPane();
        PluginListOf list = null;
        if (this.sbase instanceof PluginGene) {
            g = (PluginGene)this.sbase;
            list = g.getListOfPluginRegion();
        } else if (this.sbase instanceof PluginRNA) {
            g = (PluginRNA)this.sbase;
            list = g.getListOfPluginRegion();
        } else if (this.sbase instanceof PluginAntiSenseRNA) {
            g = (PluginAntiSenseRNA)this.sbase;
            list = g.getListOfPluginRegion();
        }
        this.table = new GeneRNAViewingTable(this.formatForTableData(list), this);
        this.sc.getViewport().add(this.table);
        this.getContentPane().add((Component)this.sc, "Center");
        JPanel innerPanel = new JPanel();
        JButton buttonAdd = new JButton("Add");
        buttonAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PluginGeneRNADialog.this.add();
            }
        });
        innerPanel.add(buttonAdd);
        JButton buttonDel = new JButton("Del");
        buttonDel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PluginGeneRNADialog.this.del();
            }
        });
        innerPanel.add(buttonDel);
        this.getContentPane().add((Component)innerPanel, "South");
        this.setVisible(true);
    }

    protected Object[][] formatForTableData(PluginListOf listOfSBase) {
        ArrayList newData = new ArrayList();
        if (listOfSBase == null) {
            return new Object[0][0];
        }
        int i = 0;
        while (i < listOfSBase.size()) {
            ArrayList<String> rowData = new ArrayList<String>();
            PluginModificationRegion species = (PluginModificationRegion)listOfSBase.get(i);
            rowData.add(species.getId());
            rowData.add(species.getName());
            rowData.add(species.getType());
            rowData.add(Double.toString(species.getSize()));
            rowData.add(Double.toString(species.getPos()));
            newData.add(rowData);
            ++i;
        }
        Object[][] arrayData = new Object[newData.size()][1];
        int i2 = 0;
        while (i2 < newData.size()) {
            ArrayList data = (ArrayList)newData.get(i2);
            arrayData[i2] = data.toArray();
            ++i2;
        }
        return arrayData;
    }

    void add() {
        PluginGene g;
        PluginModificationRegion s = null;
        if (this.sbase instanceof PluginGene) {
            g = (PluginGene)this.sbase;
            s = new PluginModificationRegion(g);
            g.addPluginModificationRegion(s);
        } else if (this.sbase instanceof PluginRNA) {
            g = (PluginRNA)this.sbase;
            s = new PluginModificationRegion((PluginRNA)g);
            g.addPluginModificationRegion(s);
        } else if (this.sbase instanceof PluginAntiSenseRNA) {
            g = (PluginAntiSenseRNA)this.sbase;
            s = new PluginModificationRegion((PluginAntiSenseRNA)g);
            g.addPluginModificationRegion(s);
        }
        PluginSampleDialog.plug.notifySBaseChanged((PluginSBase)s);
        PluginListOf list = null;
        if (this.sbase instanceof PluginGene) {
            PluginGene g2 = (PluginGene)this.sbase;
            list = g2.getListOfPluginRegion();
        } else if (this.sbase instanceof PluginRNA) {
            PluginRNA g3 = (PluginRNA)this.sbase;
            list = g3.getListOfPluginRegion();
        } else if (this.sbase instanceof PluginAntiSenseRNA) {
            PluginAntiSenseRNA g4 = (PluginAntiSenseRNA)this.sbase;
            list = g4.getListOfPluginRegion();
        }
        this.sc.getViewport().removeAll();
        this.table = new GeneRNAViewingTable(this.formatForTableData(list), this);
        this.sc.getViewport().add(this.table);
    }

    void del() {
        PluginGene g;
        PluginModificationRegion s = null;
        if (this.sbase instanceof PluginGene) {
            g = (PluginGene)this.sbase;
            s = g.getPluginModificationRegion(this.table.getSelectedRow());
            g.removePluginModificationRegion(this.table.getSelectedRow());
        } else if (this.sbase instanceof PluginRNA) {
            g = (PluginRNA)this.sbase;
            s = g.getPluginModificationRegion(this.table.getSelectedRow());
            g.removePluginModificationRegion(this.table.getSelectedRow());
        } else if (this.sbase instanceof PluginAntiSenseRNA) {
            g = (PluginAntiSenseRNA)this.sbase;
            s = g.getPluginModificationRegion(this.table.getSelectedRow());
            g.removePluginModificationRegion(this.table.getSelectedRow());
        }
        PluginSampleDialog.plug.notifySBaseDeleted((PluginSBase)s);
        PluginListOf list = null;
        if (this.sbase instanceof PluginGene) {
            PluginGene g2 = (PluginGene)this.sbase;
            list = g2.getListOfPluginRegion();
        } else if (this.sbase instanceof PluginRNA) {
            PluginRNA g3 = (PluginRNA)this.sbase;
            list = g3.getListOfPluginRegion();
        } else if (this.sbase instanceof PluginAntiSenseRNA) {
            PluginAntiSenseRNA g4 = (PluginAntiSenseRNA)this.sbase;
            list = g4.getListOfPluginRegion();
        }
        this.sc.getViewport().removeAll();
        this.table = new GeneRNAViewingTable(this.formatForTableData(list), this);
        this.sc.getViewport().add(this.table);
    }
}

