/*
 * Decompiled with CFR 0.152.
 */
package plugin.sample2.dialog.editdialog;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jp.sbi.celldesigner.plugin.PluginEvent;
import jp.sbi.sbml.util.MathEditPanel2;
import org.sbml.libsbml.ASTNode;
import org.sbml.libsbml.libsbml;
import plugin.sample2.dialog.editdialog.PluginEventAssDialog;
import plugin.sample2.dialog.editdialog.PluginSBaseDialog;

public class PluginEventDialog
extends PluginSBaseDialog {
    private JTextField idTextField;
    private JTextField nameTextField;
    private JTextField triggerTextField;
    private JTextField delayTextField;
    private JTextField timeUnitsField;
    private JButton eventAssignmentButton;
    private MathEditPanel2 mathPanel;

    public PluginEventDialog(PluginEvent eve, boolean mode) {
        this.editingSBase = eve;
        this.addmode = mode;
        this.setDialogFromObject(eve);
        this.setVisible(true);
    }

    protected JPanel createDialogPanel() {
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(null);
        this.LABEL_WIDTH = 60;
        this.TEXT_WIDTH = 300;
        this.setLayoutConstants();
        int yline = this.VERTICAL_MARGIN;
        JLabel idLabel = new JLabel("id");
        idLabel.setBounds(new Rectangle(this.HORIZONTAL_MARGIN, yline, this.LABEL_WIDTH, this.LINE_HEIGHT));
        this.mainPanel.add((Component)idLabel, null);
        this.idTextField = new JTextField();
        this.idTextField.setBounds(new Rectangle(this.TEXT_POSITION_X, yline, this.TEXT_WIDTH, this.LINE_HEIGHT));
        this.idTextField.setEditable(true);
        this.mainPanel.add((Component)this.idTextField, null);
        JLabel nameLabel = new JLabel("name");
        nameLabel.setBounds(new Rectangle(this.HORIZONTAL_MARGIN, yline += this.BASELINE_SKIP, this.LABEL_WIDTH, this.LINE_HEIGHT));
        this.mainPanel.add((Component)nameLabel, null);
        this.nameTextField = new JTextField();
        this.nameTextField.setBounds(new Rectangle(this.TEXT_POSITION_X, yline, this.TEXT_WIDTH, this.LINE_HEIGHT));
        this.nameTextField.setEditable(true);
        this.mainPanel.add((Component)this.nameTextField, null);
        JLabel triggerLabel = new JLabel("trigger");
        triggerLabel.setBounds(new Rectangle(this.HORIZONTAL_MARGIN, yline += this.BASELINE_SKIP, this.LABEL_WIDTH, this.LINE_HEIGHT));
        this.mainPanel.add((Component)triggerLabel, null);
        this.mathPanel = new MathEditPanel2();
        int mpheight = this.mathPanel.createUI(this.TEXT_WIDTH, this.LINE_HEIGHT, this.BASELINE_SKIP);
        this.mathPanel.setBounds(new Rectangle(this.TEXT_POSITION_X, yline, this.TEXT_WIDTH, mpheight));
        this.triggerTextField = this.mathPanel.getTextField(1);
        this.triggerTextField.setEditable(true);
        this.delayTextField = this.mathPanel.getTextField(2);
        this.delayTextField.setEditable(true);
        this.mainPanel.add((Component)this.mathPanel, null);
        JLabel delayLabel = new JLabel("delay");
        delayLabel.setBounds(new Rectangle(this.HORIZONTAL_MARGIN, yline + mpheight - this.BASELINE_SKIP, this.LABEL_WIDTH, this.LINE_HEIGHT));
        this.mainPanel.add((Component)delayLabel, null);
        JLabel timeUnitsLabel = new JLabel("timeUnits");
        timeUnitsLabel.setBounds(new Rectangle(this.HORIZONTAL_MARGIN, yline += mpheight + this.BASELINE_SKIP - this.LINE_HEIGHT, this.LABEL_WIDTH, this.LINE_HEIGHT));
        this.mainPanel.add(timeUnitsLabel);
        this.timeUnitsField = new JTextField();
        this.timeUnitsField.setBounds(new Rectangle(this.TEXT_POSITION_X, yline, this.TEXT_WIDTH, this.LINE_HEIGHT));
        this.timeUnitsField.setEditable(true);
        this.mainPanel.add(this.timeUnitsField);
        JLabel eventAssignmentLabel = new JLabel("listOfEventAssignments");
        eventAssignmentLabel.setBounds(new Rectangle(this.HORIZONTAL_MARGIN, yline += this.BASELINE_SKIP, this.LABEL_WIDTH + 60, this.LINE_HEIGHT));
        this.mainPanel.add(eventAssignmentLabel);
        this.eventAssignmentButton = new JButton("Show list..");
        this.eventAssignmentButton.setBounds(new Rectangle(this.TEXT_POSITION_X + this.TEXT_WIDTH - this.SHOW_LIST_BUTTON_WIDTH, yline, this.SHOW_LIST_BUTTON_WIDTH, this.LINE_HEIGHT));
        this.eventAssignmentButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PluginEventDialog.this.listDlgButton_actionPerformed();
            }
        });
        this.eventAssignmentButton.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                PluginEventDialog.this.rootPane.setDefaultButton(PluginEventDialog.this.eventAssignmentButton);
            }
        });
        this.mainPanel.add((Component)this.eventAssignmentButton, null);
        this.BUTTON_POSITION_Y = yline += this.BASELINE_SKIP;
        this.setDefaultButtonsLayout();
        this.addDefaultButtonsToPanel();
        return this.mainPanel;
    }

    private void listDlgButton_actionPerformed() {
        PluginEventAssDialog unitDialog = new PluginEventAssDialog((PluginEvent)this.editingSBase);
    }

    protected void setDialogFromObject(PluginEvent ev) {
        String id = ev.getId();
        this.idTextField.setText(id);
        this.idTextField.setCaretPosition(id.length());
        String name = ev.getName();
        this.nameTextField.setText(name);
        this.nameTextField.setCaretPosition(name.length());
        String trigger = "";
        if (ev.getTrigger() != null) {
            trigger = libsbml.formulaToString((ASTNode)ev.getTrigger().getMath());
        }
        this.triggerTextField.setText(trigger);
        this.triggerTextField.setCaretPosition(trigger.length());
        String delay = "";
        if (ev.getDelay() != null) {
            delay = libsbml.formulaToString((ASTNode)ev.getDelay().getMath());
        }
        this.delayTextField.setText(delay);
        this.delayTextField.setCaretPosition(delay.length());
        String timeUnits = ev.getTimeUnits();
        this.timeUnitsField.setText(timeUnits);
        this.timeUnitsField.setCaretPosition(timeUnits.length());
    }

    protected void updateObject() {
        PluginEvent ev = (PluginEvent)this.editingSBase;
        ev.setName(this.nameTextField.getText());
        ev.setTimeUnits(this.timeUnitsField.getText());
        ev.setName(this.nameTextField.getText());
        ev.setName(this.nameTextField.getText());
        try {
            String trigger = this.triggerTextField.getText();
            if (libsbml.parseFormula((String)trigger) == null) {
                throw new Exception();
            }
            ev.setTrigger(libsbml.parseFormula((String)trigger));
        }
        catch (Exception trigger) {
            // empty catch block
        }
        try {
            String delay = this.delayTextField.getText();
            if (libsbml.parseFormula((String)delay) == null) {
                throw new Exception();
            }
            ev.setDelay(libsbml.parseFormula((String)delay));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

