/*
 * Decompiled with CFR 0.152.
 */
package plugin.sample2.dialog;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import jp.sbi.celldesigner.plugin.PluginCompartment;
import jp.sbi.celldesigner.plugin.PluginListOf;
import jp.sbi.celldesigner.plugin.PluginModel;
import jp.sbi.celldesigner.plugin.PluginReaction;
import jp.sbi.celldesigner.plugin.PluginSBase;
import jp.sbi.celldesigner.plugin.PluginSpeciesAlias;
import plugin.sample2.SamplePlugin2;
import plugin.sample2.dialog.BaseTabPanel;
import plugin.sample2.dialog.CommonSBaseViewingTab;

public class PluginSampleDialog
extends JDialog {
    public static PluginSampleDialog thisInstance;
    public static SamplePlugin2 plug;
    public static PluginModel model;
    private JButton buttonSynchronized;
    private JButton buttonDebug;
    private JButton buttonClose;
    private JTextField textCodebase;
    private JTextField textAppName;
    private JTextField textVenderName;
    private JTextField textHPName;
    private JTextField textDescreption;
    private JCheckBox checkOfflineAllowed;
    private JTextField textArg1;
    private JTextField textArg2;
    public static final String SPECIES = "Species";
    public static final String SPECIES_ALIAS = "SpeciesAlias";
    public static final String PROTEINS = "Proteins";
    public static final String GENES = "Genes";
    public static final String RNAS = "RNAs";
    public static final String AS_RNAS = "AsRNAs";
    public static final String REACTIONS = "Reactions";
    public static final String KINETICLAWS = "KineticLaws";
    public static final String LOCAL_PARAM = "Lacal_Parameter";
    public static final String COMPARTMENTS = "Compartments";
    public static final String PARAMETERS = "Global_Parameters";
    public static final String FUNCTIONS = "Functions";
    public static final String UNIT_DEFINITIONS = "UnitDefinitions";
    public static final String UNITS = "Units";
    public static final String RULES = "Rules";
    public static final String EVENTS = "Events";
    public static int idCount;
    public static JTabbedPane tabPane;

    static {
        idCount = 0;
    }

    public PluginSampleDialog(SamplePlugin2 plug2) {
        plug = plug2;
        this.setModal(false);
        thisInstance = this;
        this.init();
    }

    private void init() {
        this.setTitle("Sample Plugin2");
        this.setSize(750, 600);
        this.setResizable(true);
        this.getContentPane().add((Component)this.createRightPanel(), "Center");
        this.getContentPane().add((Component)this.createSouthPanel(), "South");
    }

    public static void updateTable() {
        System.out.println("PluginSampleDialog updateTable");
        int index = tabPane.getSelectedIndex();
        tabPane.removeAll();
        if (model == null) {
            model = plug.getSelectedModel();
        }
        tabPane.add((Component)new CommonSBaseViewingTab(thisInstance, SPECIES, model.getListOfSpecies()), SPECIES);
        tabPane.add((Component)new CommonSBaseViewingTab(thisInstance, SPECIES_ALIAS, model.getListOfAllSpeciesAlias()), SPECIES_ALIAS);
        tabPane.add((Component)new CommonSBaseViewingTab(thisInstance, PROTEINS, model.getListOfProteins()), PROTEINS);
        tabPane.add((Component)new CommonSBaseViewingTab(thisInstance, GENES, model.getListOfGenes()), GENES);
        tabPane.add((Component)new CommonSBaseViewingTab(thisInstance, RNAS, model.getListOfRNAs()), RNAS);
        tabPane.add((Component)new CommonSBaseViewingTab(thisInstance, AS_RNAS, model.getListOfAntiSenseRNAs()), AS_RNAS);
        tabPane.add((Component)new CommonSBaseViewingTab(thisInstance, REACTIONS, model.getListOfReactions()), REACTIONS);
        PluginListOf listOfKineticLaw = new PluginListOf();
        int i = 0;
        while (i < model.getListOfReactions().size()) {
            listOfKineticLaw.append((PluginSBase)model.getReaction(i).getKineticLaw());
            ++i;
        }
        tabPane.add((Component)new CommonSBaseViewingTab(thisInstance, KINETICLAWS, listOfKineticLaw), KINETICLAWS);
        tabPane.add((Component)new CommonSBaseViewingTab(thisInstance, COMPARTMENTS, model.getListOfCompartments()), COMPARTMENTS);
        tabPane.add((Component)new CommonSBaseViewingTab(thisInstance, PARAMETERS, model.getListOfParameters()), PARAMETERS);
        tabPane.add((Component)new CommonSBaseViewingTab(thisInstance, FUNCTIONS, model.getListOfFunctionDefinitions()), FUNCTIONS);
        tabPane.add((Component)new CommonSBaseViewingTab(thisInstance, UNIT_DEFINITIONS, model.getListOfUnitDefinitions()), UNIT_DEFINITIONS);
        tabPane.add((Component)new CommonSBaseViewingTab(thisInstance, RULES, model.getListOfRules()), RULES);
        tabPane.add((Component)new CommonSBaseViewingTab(thisInstance, EVENTS, model.getListOfEvents()), EVENTS);
        tabPane.setSelectedIndex(index);
    }

    private JTabbedPane createRightPanel() {
        tabPane = new JTabbedPane();
        tabPane.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent arg0) {
                if (tabPane.getSelectedIndex() == 1 || tabPane.getSelectedIndex() == 6 || tabPane.getSelectedIndex() == 11 || tabPane.getSelectedIndex() == 13 || tabPane.getSelectedIndex() == 2 || tabPane.getSelectedIndex() == 3 || tabPane.getSelectedIndex() == 4 || tabPane.getSelectedIndex() == 5) {
                    int i = 0;
                    while (i < tabPane.getComponentCount()) {
                        Component comp = tabPane.getComponent(i);
                        if (comp instanceof BaseTabPanel) {
                            ((BaseTabPanel)comp).setEditButtonEnable(true);
                        }
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < tabPane.getComponentCount()) {
                        Component comp = tabPane.getComponent(i);
                        if (comp instanceof BaseTabPanel) {
                            ((BaseTabPanel)comp).setEditButtonEnable(false);
                        }
                        ++i;
                    }
                }
            }

            public void mousePressed(MouseEvent arg0) {
            }

            public void mouseReleased(MouseEvent arg0) {
            }

            public void mouseEntered(MouseEvent arg0) {
            }

            public void mouseExited(MouseEvent arg0) {
            }
        });
        model = plug.getSelectedModel();
        if (model == null) {
            return tabPane;
        }
        tabPane.add((Component)new CommonSBaseViewingTab(this, SPECIES, model.getListOfSpecies()), SPECIES);
        tabPane.add((Component)new CommonSBaseViewingTab(this, SPECIES_ALIAS, model.getListOfAllSpeciesAlias()), SPECIES_ALIAS);
        tabPane.add((Component)new CommonSBaseViewingTab(this, PROTEINS, model.getListOfProteins()), PROTEINS);
        tabPane.add((Component)new CommonSBaseViewingTab(this, GENES, model.getListOfGenes()), GENES);
        tabPane.add((Component)new CommonSBaseViewingTab(this, RNAS, model.getListOfRNAs()), RNAS);
        tabPane.add((Component)new CommonSBaseViewingTab(this, AS_RNAS, model.getListOfAntiSenseRNAs()), AS_RNAS);
        tabPane.add((Component)new CommonSBaseViewingTab(this, REACTIONS, model.getListOfReactions()), REACTIONS);
        PluginListOf listOfKineticLaw = new PluginListOf();
        int i = 0;
        while (i < model.getListOfReactions().size()) {
            listOfKineticLaw.append((PluginSBase)model.getReaction(i).getKineticLaw());
            ++i;
        }
        tabPane.add((Component)new CommonSBaseViewingTab(this, KINETICLAWS, listOfKineticLaw), KINETICLAWS);
        tabPane.add((Component)new CommonSBaseViewingTab(this, COMPARTMENTS, model.getListOfCompartments()), COMPARTMENTS);
        tabPane.add((Component)new CommonSBaseViewingTab(this, PARAMETERS, model.getListOfParameters()), PARAMETERS);
        tabPane.add((Component)new CommonSBaseViewingTab(this, FUNCTIONS, model.getListOfFunctionDefinitions()), FUNCTIONS);
        tabPane.add((Component)new CommonSBaseViewingTab(this, UNIT_DEFINITIONS, model.getListOfUnitDefinitions()), UNIT_DEFINITIONS);
        tabPane.add((Component)new CommonSBaseViewingTab(this, RULES, model.getListOfRules()), RULES);
        tabPane.add((Component)new CommonSBaseViewingTab(this, EVENTS, model.getListOfEvents()), EVENTS);
        return tabPane;
    }

    private JPanel createSouthPanel() {
        JPanel southPanel = new JPanel();
        JPanel innerSouthPanel = new JPanel();
        this.buttonSynchronized = new JButton("Synchronized");
        this.buttonSynchronized.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                PluginSampleDialog.this.buttonSynchronized_actionPerformed(arg0);
            }
        });
        this.buttonDebug = new JButton("debug print");
        this.buttonDebug.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                PluginSampleDialog.this.buttonDebug_actionPerformed(arg0);
            }
        });
        this.buttonClose = new JButton("Close");
        this.buttonClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                PluginSampleDialog.this.buttonClose_actionPerformed(arg0);
            }
        });
        innerSouthPanel.add(this.buttonSynchronized);
        innerSouthPanel.add(this.buttonDebug);
        innerSouthPanel.add(this.buttonClose);
        southPanel.add((Component)innerSouthPanel, "Center");
        return southPanel;
    }

    private void buttonSynchronized_actionPerformed(ActionEvent arg0) {
        model = null;
        PluginSampleDialog.updateTable();
    }

    private void buttonDebug_actionPerformed(ActionEvent arg0) {
        PluginModel pmodel;
        PluginListOf listOfR;
        System.out.println("---------debug print start");
        PluginListOf listOf = plug.getSelectedSpeciesNode();
        if (listOf != null) {
            int i = 0;
            while (i < listOf.size()) {
                PluginSpeciesAlias alias = (PluginSpeciesAlias)listOf.get(i);
                System.out.println("selected SpeciesNode = " + alias.getAliasID());
                System.out.println("selected name = " + alias.getName());
                ++i;
            }
        }
        if ((listOfR = plug.getSelectedReactionNode(model)) != null) {
            int i = 0;
            while (i < listOfR.size()) {
                ((PluginReaction)listOfR.get(i)).setLineColor(Color.BLUE);
                System.out.println("selected ReactionNode = " + ((PluginReaction)listOfR.get(i)).getId());
                System.out.println("selected setLineColor = " + ((PluginReaction)listOfR.get(i)).getLineColor());
                plug.notifySBaseChanged(listOfR.get(i));
                ++i;
            }
        }
        PluginListOf listOfC = plug.getSelectedCompartmentNode(model);
        if (listOfR != null) {
            int i = 0;
            while (i < listOfC.size()) {
                System.out.println("selected CompartmentNode = " + ((PluginCompartment)listOfC.get(i)).getId());
                plug.notifySBaseChanged(listOfC.get(i));
                ++i;
            }
        }
        if ((pmodel = plug.getSelectedModel()) != null) {
            System.out.println("selected model id = " + pmodel.getId());
            System.out.println("selected model name = " + pmodel.getName());
            System.out.println("selected model notes = " + pmodel.getNotesString());
        }
        System.out.println("---------debug print end");
    }

    private boolean isValidData() {
        if (this.textCodebase.getText().equals("")) {
            JOptionPane.showMessageDialog(null, "Please input Codabase.", "Warning", 1);
            return false;
        }
        if (this.textArg1.getText().equals("")) {
            JOptionPane.showMessageDialog(null, "Please input Argument1.", "Warning", 1);
            return false;
        }
        if (this.textArg2.getText().equals("")) {
            JOptionPane.showMessageDialog(null, "Please input Argument2.", "Warning", 1);
            return false;
        }
        return true;
    }

    private void buttonClose_actionPerformed(ActionEvent arg0) {
        this.setVisible(false);
        this.dispose();
    }

    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.setVisible(false);
            this.dispose();
        }
    }
}

